/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import umpaz.farmersrespite.FarmersRespite;
import umpaz.farmersrespite.client.recipebook.KettleRecipeBookTab;
import umpaz.farmersrespite.common.registry.FRItems;
import umpaz.farmersrespite.common.registry.FRRecipeSerializers;
import umpaz.farmersrespite.common.registry.FRRecipeTypes;

public class KettleRecipe
implements Recipe<RecipeWrapper> {
    public static final int INPUT_SLOTS = 2;
    private final ResourceLocation id;
    private final String group;
    private final KettleRecipeBookTab tab;
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ItemStack container;
    private final float experience;
    private final int brewTime;
    private final boolean needWater;

    public KettleRecipe(ResourceLocation id, String group, @Nullable KettleRecipeBookTab tab, NonNullList<Ingredient> inputItems, ItemStack output, ItemStack container, float experience, int brewTime, boolean needWater) {
        this.id = id;
        this.group = group;
        this.tab = tab;
        this.inputItems = inputItems;
        this.output = output;
        this.container = !container.m_41619_() ? container : (!output.getCraftingRemainingItem().m_41619_() ? output.getCraftingRemainingItem() : ItemStack.f_41583_);
        this.experience = experience;
        this.brewTime = brewTime;
        this.needWater = needWater;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    @Nullable
    public KettleRecipeBookTab getRecipeBookTab() {
        return this.tab;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public ItemStack getOutputContainer() {
        return this.container;
    }

    public ItemStack assemble(RecipeWrapper inv) {
        return this.output.m_41777_();
    }

    public float getExperience() {
        return this.experience;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public boolean getNeedWater() {
        return this.needWater;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 2; ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FRRecipeSerializers.BREWING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FRRecipeTypes.BREWING.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)FRItems.KETTLE.get());
    }

    public static class Serializer
    implements RecipeSerializer<KettleRecipe> {
        public KettleRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String groupIn = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputItemsIn = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for brewing recipe");
            }
            if (inputItemsIn.size() > 2) {
                throw new JsonParseException("Too many ingredients for brewing recipe! The max is 2");
            }
            String tabKeyIn = GsonHelper.m_13851_((JsonObject)json, (String)"recipe_book_tab", null);
            KettleRecipeBookTab tabIn = KettleRecipeBookTab.findByName(tabKeyIn);
            if (tabKeyIn != null && tabIn == null) {
                FarmersRespite.LOGGER.warn("Optional field 'recipe_book_tab' does not match any valid tab. If defined, must be one of the following: " + EnumSet.allOf(KettleRecipeBookTab.class));
            }
            ItemStack outputIn = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            ItemStack container = GsonHelper.m_13900_((JsonObject)json, (String)"container") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"container"), (boolean)true) : ItemStack.f_41583_;
            float experienceIn = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int brewTimeIn = GsonHelper.m_13824_((JsonObject)json, (String)"brewingtime", (int)200);
            boolean needWaterIn = GsonHelper.m_13855_((JsonObject)json, (String)"needwater", (boolean)true);
            return new KettleRecipe(recipeId, groupIn, tabIn, inputItemsIn, outputIn, container, experienceIn, brewTimeIn, needWaterIn);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public KettleRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String groupIn = buffer.m_130277_();
            KettleRecipeBookTab tabIn = KettleRecipeBookTab.findByName(buffer.m_130277_());
            int i = buffer.m_130242_();
            NonNullList inputItemsIn = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < inputItemsIn.size(); ++j) {
                inputItemsIn.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack outputIn = buffer.m_130267_();
            ItemStack container = buffer.m_130267_();
            float experienceIn = buffer.readFloat();
            int brewTimeIn = buffer.m_130242_();
            boolean needWaterIn = buffer.readBoolean();
            return new KettleRecipe(recipeId, groupIn, tabIn, (NonNullList<Ingredient>)inputItemsIn, outputIn, container, experienceIn, brewTimeIn, needWaterIn);
        }

        public void toNetwork(FriendlyByteBuf buffer, KettleRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130070_(recipe.tab != null ? recipe.tab.toString() : "");
            buffer.m_130130_(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.m_130055_(recipe.container);
            buffer.writeFloat(recipe.experience);
            buffer.m_130130_(recipe.brewTime);
            buffer.writeBoolean(recipe.needWater);
        }
    }
}

