/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.data.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.farmersrespite.client.recipebook.KettleRecipeBookTab;
import umpaz.farmersrespite.common.registry.FRRecipeSerializers;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class KettleRecipeBuilder {
    private KettleRecipeBookTab tab;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Item result;
    private final int count;
    private final int brewingTime;
    private final boolean needWater;
    private final float experience;
    private final Item container;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;

    private KettleRecipeBuilder(ItemLike resultIn, int count, int brewingTime, boolean needWater, float experience, @Nullable ItemLike container) {
        this.result = resultIn.m_5456_();
        this.count = count;
        this.brewingTime = brewingTime;
        this.needWater = needWater;
        this.experience = experience;
        this.container = container != null ? container.m_5456_() : null;
        this.tab = null;
    }

    public static KettleRecipeBuilder kettleRecipe(ItemLike mainResult, int count, int cookingTime, boolean needWater, float experience) {
        return new KettleRecipeBuilder(mainResult, count, cookingTime, needWater, experience, null);
    }

    public static KettleRecipeBuilder kettleRecipe(ItemLike mainResult, int count, int cookingTime, boolean needWater, float experience, ItemLike container) {
        return new KettleRecipeBuilder(mainResult, count, cookingTime, needWater, experience, container);
    }

    public KettleRecipeBuilder addIngredient(TagKey<Item> tagIn) {
        return this.addIngredient(Ingredient.m_204132_(tagIn));
    }

    public KettleRecipeBuilder addIngredient(ItemLike itemIn) {
        return this.addIngredient(itemIn, 1);
    }

    public KettleRecipeBuilder addIngredient(ItemLike itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
        }
        return this;
    }

    public KettleRecipeBuilder addIngredient(Ingredient ingredientIn) {
        return this.addIngredient(ingredientIn, 1);
    }

    public KettleRecipeBuilder addIngredient(Ingredient ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public KettleRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public KettleRecipeBuilder unlockedBy(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    public KettleRecipeBuilder unlockedByItems(String criterionName, ItemLike ... items) {
        return this.unlockedBy(criterionName, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])items));
    }

    public KettleRecipeBuilder unlockedByAnyIngredient(ItemLike ... items) {
        this.advancement.m_138386_("has_any_ingredient", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(items).m_45077_()}));
        return this;
    }

    public KettleRecipeBuilder setRecipeBookTab(KettleRecipeBookTab tab) {
        this.tab = tab;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)this.result);
        this.build(consumerIn, "farmersrespite:brewing/" + location.m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((Object)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Brewing Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        if (!this.advancement.m_138405_().isEmpty()) {
            this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
            ResourceLocation advancementId = new ResourceLocation(id.m_135827_(), "recipes/farmersrespite/" + id.m_135815_());
            consumerIn.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.brewingTime, this.needWater, this.experience, this.container, this.tab, this.advancement, advancementId));
        } else {
            consumerIn.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.brewingTime, this.needWater, this.experience, this.container, this.tab));
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final KettleRecipeBookTab tab;
        private final List<Ingredient> ingredients;
        private final Item result;
        private final int count;
        private final String group;
        private final int cookingTime;
        private final boolean needWater;
        private final float experience;
        private final Item container;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation idIn, Item resultIn, int countIn, String groupIn, List<Ingredient> ingredientsIn, int cookingTimeIn, boolean needWaterIn, float experienceIn, @Nullable Item containerIn, @Nullable KettleRecipeBookTab tabIn, @Nullable Advancement.Builder advancement, @Nullable ResourceLocation advancementId) {
            this.id = idIn;
            this.tab = tabIn;
            this.ingredients = ingredientsIn;
            this.result = resultIn;
            this.count = countIn;
            this.group = groupIn;
            this.cookingTime = cookingTimeIn;
            this.needWater = needWaterIn;
            this.experience = experienceIn;
            this.container = containerIn;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public Result(ResourceLocation idIn, Item resultIn, int countIn, String groupIn, List<Ingredient> ingredientsIn, int cookingTimeIn, boolean needWaterIn, float experienceIn, @Nullable Item containerIn, @Nullable KettleRecipeBookTab tabIn) {
            this(idIn, resultIn, countIn, groupIn, ingredientsIn, cookingTimeIn, needWaterIn, experienceIn, containerIn, tabIn, null, null);
        }

        public void m_7917_(JsonObject json) {
            if (this.tab != null) {
                json.addProperty("recipe_book_tab", this.tab.toString());
            }
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray arrayIngredients = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                arrayIngredients.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)arrayIngredients);
            JsonObject objectResult = new JsonObject();
            objectResult.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.count > 1) {
                objectResult.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)objectResult);
            if (this.container != null) {
                JsonObject objectContainer = new JsonObject();
                objectContainer.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.container).toString());
                json.add("container", (JsonElement)objectContainer);
            }
            if (this.experience > 0.0f) {
                json.addProperty("experience", (Number)Float.valueOf(this.experience));
            }
            json.addProperty("cookingtime", (Number)this.cookingTime);
            json.addProperty("needwater", Boolean.valueOf(this.needWater));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)FRRecipeSerializers.BREWING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement != null ? this.advancement.m_138400_() : null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

