/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.init;

import codechicken.lib.item.SimpleArmorMaterial;
import codechicken.lib.item.SimpleItemTier;
import codechicken.microblock.item.SawItem;
import java.util.List;
import java.util.function.Supplier;
import mrtjp.projectred.core.init.CoreTags;
import mrtjp.projectred.exploration.ProjectRedExploration;
import mrtjp.projectred.exploration.item.AthameItem;
import mrtjp.projectred.exploration.item.BackpackItem;
import mrtjp.projectred.exploration.item.SickleItem;
import mrtjp.projectred.exploration.item.WoolGinItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ExplorationItems {
    public static final String ID_RAW_TIN = "raw_tin";
    public static final String ID_TIN_INGOT = "tin_ingot";
    public static final String ID_RAW_SILVER = "raw_silver";
    public static final String ID_SILVER_INGOT = "silver_ingot";
    public static final String ID_WOOL_GIN = "wool_gin";
    public static final String ID_ATHAME = "athame";
    public static final String ID_RUBY_AXE = "ruby_axe";
    public static final String ID_SAPPHIRE_AXE = "sapphire_axe";
    public static final String ID_PERIDOT_AXE = "peridot_axe";
    public static final String ID_RUBY_PICKAXE = "ruby_pickaxe";
    public static final String ID_SAPPHIRE_PICKAXE = "sapphire_pickaxe";
    public static final String ID_PERIDOT_PICKAXE = "peridot_pickaxe";
    public static final String ID_RUBY_SHOVEL = "ruby_shovel";
    public static final String ID_SAPPHIRE_SHOVEL = "sapphire_shovel";
    public static final String ID_PERIDOT_SHOVEL = "peridot_shovel";
    public static final String ID_RUBY_HOE = "ruby_hoe";
    public static final String ID_SAPPHIRE_HOE = "sapphire_hoe";
    public static final String ID_PERIDOT_HOE = "peridot_hoe";
    public static final String ID_RUBY_SWORD = "ruby_sword";
    public static final String ID_SAPPHIRE_SWORD = "sapphire_sword";
    public static final String ID_PERIDOT_SWORD = "peridot_sword";
    public static final String ID_RUBY_HELMET = "ruby_helmet";
    public static final String ID_SAPPHIRE_HELMET = "sapphire_helmet";
    public static final String ID_PERIDOT_HELMET = "peridot_helmet";
    public static final String ID_RUBY_CHESTPLATE = "ruby_chestplate";
    public static final String ID_SAPPHIRE_CHESTPLATE = "sapphire_chestplate";
    public static final String ID_PERIDOT_CHESTPLATE = "peridot_chestplate";
    public static final String ID_RUBY_LEGGINGS = "ruby_leggings";
    public static final String ID_SAPPHIRE_LEGGINGS = "sapphire_leggings";
    public static final String ID_PERIDOT_LEGGINGS = "peridot_leggings";
    public static final String ID_RUBY_BOOTS = "ruby_boots";
    public static final String ID_SAPPHIRE_BOOTS = "sapphire_boots";
    public static final String ID_PERIDOT_BOOTS = "peridot_boots";
    public static final String ID_GOLD_SAW = "gold_saw";
    public static final String ID_RUBY_SAW = "ruby_saw";
    public static final String ID_SAPPHIRE_SAW = "sapphire_saw";
    public static final String ID_PERIDOT_SAW = "peridot_saw";
    public static final String ID_WOOD_SICKLE = "wood_sickle";
    public static final String ID_STONE_SICKLE = "stone_sickle";
    public static final String ID_IRON_SICKLE = "iron_sickle";
    public static final String ID_GOLD_SICKLE = "gold_sickle";
    public static final String ID_DIAMOND_SICKLE = "diamond_sickle";
    public static final String ID_RUBY_SICKLE = "ruby_sickle";
    public static final String ID_SAPPHIRE_SICKLE = "sapphire_sickle";
    public static final String ID_PERIDOT_SICKLE = "peridot_sickle";
    public static final String ID_WHITE_BACKPACK = "white_backpack";
    public static final String ID_ORANGE_BACKPACK = "orange_backpack";
    public static final String ID_MAGENTA_BACKPACK = "magenta_backpack";
    public static final String ID_LIGHT_BLUE_BACKPACK = "light_blue_backpack";
    public static final String ID_YELLOW_BACKPACK = "yellow_backpack";
    public static final String ID_LIME_BACKPACK = "lime_backpack";
    public static final String ID_PINK_BACKPACK = "pink_backpack";
    public static final String ID_GRAY_BACKPACK = "gray_backpack";
    public static final String ID_LIGHT_GRAY_BACKPACK = "light_gray_backpack";
    public static final String ID_CYAN_BACKPACK = "cyan_backpack";
    public static final String ID_PURPLE_BACKPACK = "purple_backpack";
    public static final String ID_BLUE_BACKPACK = "blue_backpack";
    public static final String ID_BROWN_BACKPACK = "brown_backpack";
    public static final String ID_GREEN_BACKPACK = "green_backpack";
    public static final String ID_RED_BACKPACK = "red_backpack";
    public static final String ID_BLACK_BACKPACK = "black_backpack";
    public static RegistryObject<Item> RAW_TIN_ITEM;
    public static RegistryObject<Item> TIN_INGOT_ITEM;
    public static RegistryObject<Item> RAW_SILVER_ITEM;
    public static RegistryObject<Item> SILVER_INGOT_ITEM;
    public static RegistryObject<Item> WOOL_GIN;
    public static RegistryObject<Item> ATHAME;
    public static RegistryObject<Item> RUBY_AXE;
    public static RegistryObject<Item> SAPPHIRE_AXE;
    public static RegistryObject<Item> PERIDOT_AXE;
    public static RegistryObject<Item> RUBY_PICKAXE;
    public static RegistryObject<Item> SAPPHIRE_PICKAXE;
    public static RegistryObject<Item> PERIDOT_PICKAXE;
    public static RegistryObject<Item> RUBY_SHOVEL;
    public static RegistryObject<Item> SAPPHIRE_SHOVEL;
    public static RegistryObject<Item> PERIDOT_SHOVEL;
    public static RegistryObject<Item> RUBY_HOE;
    public static RegistryObject<Item> SAPPHIRE_HOE;
    public static RegistryObject<Item> PERIDOT_HOE;
    public static RegistryObject<Item> RUBY_SWORD;
    public static RegistryObject<Item> SAPPHIRE_SWORD;
    public static RegistryObject<Item> PERIDOT_SWORD;
    public static RegistryObject<Item> GOLD_SAW;
    public static RegistryObject<Item> RUBY_SAW;
    public static RegistryObject<Item> SAPPHIRE_SAW;
    public static RegistryObject<Item> PERIDOT_SAW;
    public static RegistryObject<Item> WOOD_SICKLE;
    public static RegistryObject<Item> STONE_SICKLE;
    public static RegistryObject<Item> IRON_SICKLE;
    public static RegistryObject<Item> GOLD_SICKLE;
    public static RegistryObject<Item> DIAMOND_SICKLE;
    public static RegistryObject<Item> RUBY_SICKLE;
    public static RegistryObject<Item> SAPPHIRE_SICKLE;
    public static RegistryObject<Item> PERIDOT_SICKLE;
    public static RegistryObject<Item> RUBY_HELMET;
    public static RegistryObject<Item> SAPPHIRE_HELMET;
    public static RegistryObject<Item> PERIDOT_HELMET;
    public static RegistryObject<Item> RUBY_CHESTPLATE;
    public static RegistryObject<Item> SAPPHIRE_CHESTPLATE;
    public static RegistryObject<Item> PERIDOT_CHESTPLATE;
    public static RegistryObject<Item> RUBY_LEGGINGS;
    public static RegistryObject<Item> SAPPHIRE_LEGGINGS;
    public static RegistryObject<Item> PERIDOT_LEGGINGS;
    public static RegistryObject<Item> RUBY_BOOTS;
    public static RegistryObject<Item> SAPPHIRE_BOOTS;
    public static RegistryObject<Item> PERIDOT_BOOTS;
    public static RegistryObject<Item> WHITE_BACKPACK;
    public static RegistryObject<Item> ORANGE_BACKPACK;
    public static RegistryObject<Item> MAGENTA_BACKPACK;
    public static RegistryObject<Item> LIGHT_BLUE_BACKPACK;
    public static RegistryObject<Item> YELLOW_BACKPACK;
    public static RegistryObject<Item> LIME_BACKPACK;
    public static RegistryObject<Item> PINK_BACKPACK;
    public static RegistryObject<Item> GRAY_BACKPACK;
    public static RegistryObject<Item> LIGHT_GRAY_BACKPACK;
    public static RegistryObject<Item> CYAN_BACKPACK;
    public static RegistryObject<Item> PURPLE_BACKPACK;
    public static RegistryObject<Item> BLUE_BACKPACK;
    public static RegistryObject<Item> BROWN_BACKPACK;
    public static RegistryObject<Item> GREEN_BACKPACK;
    public static RegistryObject<Item> RED_BACKPACK;
    public static RegistryObject<Item> BLACK_BACKPACK;
    public static final SimpleItemTier ATHAME_ITEM_TIER;
    public static final SimpleItemTier RUBY_ITEM_TIER;
    public static final SimpleItemTier SAPPHIRE_ITEM_TIER;
    public static final SimpleItemTier PERIDOT_ITEM_TIER;
    public static final SimpleArmorMaterial RUBY_ARMOR_MATERIAL;
    public static final SimpleArmorMaterial SAPPHIRE_ARMOR_MATERIAL;
    public static final SimpleArmorMaterial PERIDOT_ARMOR_MATERIAL;

    public static void register() {
        RAW_TIN_ITEM = ProjectRedExploration.ITEMS.register(ID_RAW_TIN, ExplorationItems.createSimpleItemSupplier());
        TIN_INGOT_ITEM = ProjectRedExploration.ITEMS.register(ID_TIN_INGOT, ExplorationItems.createSimpleItemSupplier());
        RAW_SILVER_ITEM = ProjectRedExploration.ITEMS.register(ID_RAW_SILVER, ExplorationItems.createSimpleItemSupplier());
        SILVER_INGOT_ITEM = ProjectRedExploration.ITEMS.register(ID_SILVER_INGOT, ExplorationItems.createSimpleItemSupplier());
        WOOL_GIN = ProjectRedExploration.ITEMS.register(ID_WOOL_GIN, WoolGinItem::new);
        ATHAME = ProjectRedExploration.ITEMS.register(ID_ATHAME, () -> new AthameItem((Tier)ATHAME_ITEM_TIER, 3, -2.4f));
        ExplorationItems.registerSubDiamondTeir((Tier)ATHAME_ITEM_TIER, ID_ATHAME);
        ExplorationItems.registerSubDiamondTeir((Tier)RUBY_ITEM_TIER, "ruby");
        ExplorationItems.registerSubDiamondTeir((Tier)SAPPHIRE_ITEM_TIER, "sapphire");
        ExplorationItems.registerSubDiamondTeir((Tier)PERIDOT_ITEM_TIER, "peridot");
        RUBY_AXE = ProjectRedExploration.ITEMS.register(ID_RUBY_AXE, () -> ExplorationItems.createAxeItem((Tier)RUBY_ITEM_TIER, 5.0f, -3.0f));
        SAPPHIRE_AXE = ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_AXE, () -> ExplorationItems.createAxeItem((Tier)SAPPHIRE_ITEM_TIER, 5.0f, -3.0f));
        PERIDOT_AXE = ProjectRedExploration.ITEMS.register(ID_PERIDOT_AXE, () -> ExplorationItems.createAxeItem((Tier)PERIDOT_ITEM_TIER, 5.0f, -3.0f));
        RUBY_PICKAXE = ProjectRedExploration.ITEMS.register(ID_RUBY_PICKAXE, () -> ExplorationItems.createPickaxeItem((Tier)RUBY_ITEM_TIER, 1, -2.8f));
        SAPPHIRE_PICKAXE = ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_PICKAXE, () -> ExplorationItems.createPickaxeItem((Tier)SAPPHIRE_ITEM_TIER, 1, -2.8f));
        PERIDOT_PICKAXE = ProjectRedExploration.ITEMS.register(ID_PERIDOT_PICKAXE, () -> ExplorationItems.createPickaxeItem((Tier)PERIDOT_ITEM_TIER, 1, -2.8f));
        RUBY_SHOVEL = ProjectRedExploration.ITEMS.register(ID_RUBY_SHOVEL, () -> ExplorationItems.createShovelItem((Tier)RUBY_ITEM_TIER, 1.5f, -3.0f));
        SAPPHIRE_SHOVEL = ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_SHOVEL, () -> ExplorationItems.createShovelItem((Tier)SAPPHIRE_ITEM_TIER, 1.5f, -3.0f));
        PERIDOT_SHOVEL = ProjectRedExploration.ITEMS.register(ID_PERIDOT_SHOVEL, () -> ExplorationItems.createShovelItem((Tier)PERIDOT_ITEM_TIER, 1.5f, -3.0f));
        RUBY_HOE = ProjectRedExploration.ITEMS.register(ID_RUBY_HOE, () -> ExplorationItems.createHoeItem((Tier)RUBY_ITEM_TIER, -3, 0.0f));
        SAPPHIRE_HOE = ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_HOE, () -> ExplorationItems.createHoeItem((Tier)SAPPHIRE_ITEM_TIER, -3, 0.0f));
        PERIDOT_HOE = ProjectRedExploration.ITEMS.register(ID_PERIDOT_HOE, () -> ExplorationItems.createHoeItem((Tier)PERIDOT_ITEM_TIER, -3, 0.0f));
        RUBY_SWORD = ProjectRedExploration.ITEMS.register(ID_RUBY_SWORD, () -> ExplorationItems.createSwordItem((Tier)RUBY_ITEM_TIER, 3, -2.4f));
        SAPPHIRE_SWORD = ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_SWORD, () -> ExplorationItems.createSwordItem((Tier)SAPPHIRE_ITEM_TIER, 3, -2.4f));
        PERIDOT_SWORD = ProjectRedExploration.ITEMS.register(ID_PERIDOT_SWORD, () -> ExplorationItems.createSwordItem((Tier)PERIDOT_ITEM_TIER, 3, -2.4f));
        GOLD_SAW = ProjectRedExploration.ITEMS.register(ID_GOLD_SAW, () -> ExplorationItems.createSawItem((Tier)Tiers.GOLD));
        RUBY_SAW = ProjectRedExploration.ITEMS.register(ID_RUBY_SAW, () -> ExplorationItems.createSawItem((Tier)RUBY_ITEM_TIER));
        SAPPHIRE_SAW = ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_SAW, () -> ExplorationItems.createSawItem((Tier)SAPPHIRE_ITEM_TIER));
        PERIDOT_SAW = ProjectRedExploration.ITEMS.register(ID_PERIDOT_SAW, () -> ExplorationItems.createSawItem((Tier)PERIDOT_ITEM_TIER));
        WOOD_SICKLE = ProjectRedExploration.ITEMS.register(ID_WOOD_SICKLE, () -> ExplorationItems.createSickleItem((Tier)Tiers.WOOD, 1, -2.8f));
        STONE_SICKLE = ProjectRedExploration.ITEMS.register(ID_STONE_SICKLE, () -> ExplorationItems.createSickleItem((Tier)Tiers.STONE, 1, -2.8f));
        IRON_SICKLE = ProjectRedExploration.ITEMS.register(ID_IRON_SICKLE, () -> ExplorationItems.createSickleItem((Tier)Tiers.IRON, 1, -2.8f));
        GOLD_SICKLE = ProjectRedExploration.ITEMS.register(ID_GOLD_SICKLE, () -> ExplorationItems.createSickleItem((Tier)Tiers.GOLD, 1, -2.8f));
        DIAMOND_SICKLE = ProjectRedExploration.ITEMS.register(ID_DIAMOND_SICKLE, () -> ExplorationItems.createSickleItem((Tier)Tiers.DIAMOND, 1, -2.8f));
        RUBY_SICKLE = ProjectRedExploration.ITEMS.register(ID_RUBY_SICKLE, () -> ExplorationItems.createSickleItem((Tier)RUBY_ITEM_TIER, 1, -2.8f));
        SAPPHIRE_SICKLE = ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_SICKLE, () -> ExplorationItems.createSickleItem((Tier)SAPPHIRE_ITEM_TIER, 1, -2.8f));
        PERIDOT_SICKLE = ProjectRedExploration.ITEMS.register(ID_PERIDOT_SICKLE, () -> ExplorationItems.createSickleItem((Tier)PERIDOT_ITEM_TIER, 1, -2.8f));
        RUBY_HELMET = ProjectRedExploration.ITEMS.register(ID_RUBY_HELMET, () -> ExplorationItems.createArmorItem(RUBY_ARMOR_MATERIAL, EquipmentSlot.HEAD));
        SAPPHIRE_HELMET = ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_HELMET, () -> ExplorationItems.createArmorItem(SAPPHIRE_ARMOR_MATERIAL, EquipmentSlot.HEAD));
        PERIDOT_HELMET = ProjectRedExploration.ITEMS.register(ID_PERIDOT_HELMET, () -> ExplorationItems.createArmorItem(PERIDOT_ARMOR_MATERIAL, EquipmentSlot.HEAD));
        RUBY_CHESTPLATE = ProjectRedExploration.ITEMS.register(ID_RUBY_CHESTPLATE, () -> ExplorationItems.createArmorItem(RUBY_ARMOR_MATERIAL, EquipmentSlot.CHEST));
        SAPPHIRE_CHESTPLATE = ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_CHESTPLATE, () -> ExplorationItems.createArmorItem(SAPPHIRE_ARMOR_MATERIAL, EquipmentSlot.CHEST));
        PERIDOT_CHESTPLATE = ProjectRedExploration.ITEMS.register(ID_PERIDOT_CHESTPLATE, () -> ExplorationItems.createArmorItem(PERIDOT_ARMOR_MATERIAL, EquipmentSlot.CHEST));
        RUBY_LEGGINGS = ProjectRedExploration.ITEMS.register(ID_RUBY_LEGGINGS, () -> ExplorationItems.createArmorItem(RUBY_ARMOR_MATERIAL, EquipmentSlot.LEGS));
        SAPPHIRE_LEGGINGS = ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_LEGGINGS, () -> ExplorationItems.createArmorItem(SAPPHIRE_ARMOR_MATERIAL, EquipmentSlot.LEGS));
        PERIDOT_LEGGINGS = ProjectRedExploration.ITEMS.register(ID_PERIDOT_LEGGINGS, () -> ExplorationItems.createArmorItem(PERIDOT_ARMOR_MATERIAL, EquipmentSlot.LEGS));
        RUBY_BOOTS = ProjectRedExploration.ITEMS.register(ID_RUBY_BOOTS, () -> ExplorationItems.createArmorItem(RUBY_ARMOR_MATERIAL, EquipmentSlot.FEET));
        SAPPHIRE_BOOTS = ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_BOOTS, () -> ExplorationItems.createArmorItem(SAPPHIRE_ARMOR_MATERIAL, EquipmentSlot.FEET));
        PERIDOT_BOOTS = ProjectRedExploration.ITEMS.register(ID_PERIDOT_BOOTS, () -> ExplorationItems.createArmorItem(PERIDOT_ARMOR_MATERIAL, EquipmentSlot.FEET));
        WHITE_BACKPACK = ProjectRedExploration.ITEMS.register(ID_WHITE_BACKPACK, () -> new BackpackItem(0));
        ORANGE_BACKPACK = ProjectRedExploration.ITEMS.register(ID_ORANGE_BACKPACK, () -> new BackpackItem(1));
        MAGENTA_BACKPACK = ProjectRedExploration.ITEMS.register(ID_MAGENTA_BACKPACK, () -> new BackpackItem(2));
        LIGHT_BLUE_BACKPACK = ProjectRedExploration.ITEMS.register(ID_LIGHT_BLUE_BACKPACK, () -> new BackpackItem(3));
        YELLOW_BACKPACK = ProjectRedExploration.ITEMS.register(ID_YELLOW_BACKPACK, () -> new BackpackItem(4));
        LIME_BACKPACK = ProjectRedExploration.ITEMS.register(ID_LIME_BACKPACK, () -> new BackpackItem(5));
        PINK_BACKPACK = ProjectRedExploration.ITEMS.register(ID_PINK_BACKPACK, () -> new BackpackItem(6));
        GRAY_BACKPACK = ProjectRedExploration.ITEMS.register(ID_GRAY_BACKPACK, () -> new BackpackItem(7));
        LIGHT_GRAY_BACKPACK = ProjectRedExploration.ITEMS.register(ID_LIGHT_GRAY_BACKPACK, () -> new BackpackItem(8));
        CYAN_BACKPACK = ProjectRedExploration.ITEMS.register(ID_CYAN_BACKPACK, () -> new BackpackItem(9));
        PURPLE_BACKPACK = ProjectRedExploration.ITEMS.register(ID_PURPLE_BACKPACK, () -> new BackpackItem(10));
        BLUE_BACKPACK = ProjectRedExploration.ITEMS.register(ID_BLUE_BACKPACK, () -> new BackpackItem(11));
        BROWN_BACKPACK = ProjectRedExploration.ITEMS.register(ID_BROWN_BACKPACK, () -> new BackpackItem(12));
        GREEN_BACKPACK = ProjectRedExploration.ITEMS.register(ID_GREEN_BACKPACK, () -> new BackpackItem(13));
        RED_BACKPACK = ProjectRedExploration.ITEMS.register(ID_RED_BACKPACK, () -> new BackpackItem(14));
        BLACK_BACKPACK = ProjectRedExploration.ITEMS.register(ID_BLACK_BACKPACK, () -> new BackpackItem(15));
    }

    private static Supplier<Item> createSimpleItemSupplier() {
        return () -> new Item(new Item.Properties().m_41491_((CreativeModeTab)ProjectRedExploration.EXPLORATION_CREATIVE_TAB));
    }

    private static Item createAxeItem(Tier tier, float attackDamage, float attackSpeed) {
        return new AxeItem(tier, attackDamage, attackSpeed, new Item.Properties().m_41491_((CreativeModeTab)ProjectRedExploration.EXPLORATION_CREATIVE_TAB));
    }

    private static Item createPickaxeItem(Tier tier, int attackDamage, float attackSpeed) {
        return new PickaxeItem(tier, attackDamage, attackSpeed, new Item.Properties().m_41491_((CreativeModeTab)ProjectRedExploration.EXPLORATION_CREATIVE_TAB));
    }

    private static Item createShovelItem(Tier tier, float attackDamage, float attackSpeed) {
        return new ShovelItem(tier, attackDamage, attackSpeed, new Item.Properties().m_41491_((CreativeModeTab)ProjectRedExploration.EXPLORATION_CREATIVE_TAB));
    }

    private static Item createHoeItem(Tier tier, int attackDamage, float attackSpeed) {
        return new HoeItem(tier, attackDamage, attackSpeed, new Item.Properties().m_41491_((CreativeModeTab)ProjectRedExploration.EXPLORATION_CREATIVE_TAB));
    }

    private static Item createSwordItem(Tier tier, int attackDamage, float attackSpeed) {
        return new SwordItem(tier, attackDamage, attackSpeed, new Item.Properties().m_41491_((CreativeModeTab)ProjectRedExploration.EXPLORATION_CREATIVE_TAB));
    }

    private static Item createSawItem(Tier tier) {
        return new SawItem(tier, new Item.Properties().m_41491_((CreativeModeTab)ProjectRedExploration.EXPLORATION_CREATIVE_TAB));
    }

    private static Item createSickleItem(Tier tier, int attackDamage, float attackSpeed) {
        return new SickleItem(tier, attackDamage, attackSpeed, new Item.Properties().m_41491_((CreativeModeTab)ProjectRedExploration.EXPLORATION_CREATIVE_TAB));
    }

    private static Item createArmorItem(SimpleArmorMaterial material, EquipmentSlot slot) {
        return new ArmorItem((ArmorMaterial)material, slot, new Item.Properties().m_41491_((CreativeModeTab)ProjectRedExploration.EXPLORATION_CREATIVE_TAB));
    }

    private static void registerSubDiamondTeir(Tier tier, String id) {
        TierSortingRegistry.registerTier((Tier)tier, (ResourceLocation)new ResourceLocation("projectred_exploration", id), List.of(Tiers.WOOD, Tiers.STONE, Tiers.IRON, Tiers.GOLD), List.of(Tiers.DIAMOND, Tiers.NETHERITE));
    }

    public static Item getBackpackByColor(int color) {
        return switch (color) {
            case 0 -> (Item)WHITE_BACKPACK.get();
            case 1 -> (Item)ORANGE_BACKPACK.get();
            case 2 -> (Item)MAGENTA_BACKPACK.get();
            case 3 -> (Item)LIGHT_BLUE_BACKPACK.get();
            case 4 -> (Item)YELLOW_BACKPACK.get();
            case 5 -> (Item)LIME_BACKPACK.get();
            case 6 -> (Item)PINK_BACKPACK.get();
            case 7 -> (Item)GRAY_BACKPACK.get();
            case 8 -> (Item)LIGHT_GRAY_BACKPACK.get();
            case 9 -> (Item)CYAN_BACKPACK.get();
            case 10 -> (Item)PURPLE_BACKPACK.get();
            case 11 -> (Item)BLUE_BACKPACK.get();
            case 12 -> (Item)BROWN_BACKPACK.get();
            case 13 -> (Item)GREEN_BACKPACK.get();
            case 14 -> (Item)RED_BACKPACK.get();
            case 15 -> (Item)BLACK_BACKPACK.get();
            default -> throw new IllegalArgumentException("Invalid color: " + color);
        };
    }

    static {
        ATHAME_ITEM_TIER = SimpleItemTier.builder((Tier)Tiers.DIAMOND).maxUses(100).enchantability(30).repairMaterial(() -> Ingredient.m_204132_((TagKey)CoreTags.SILVER_INGOT_TAG)).build();
        RUBY_ITEM_TIER = SimpleItemTier.builder().maxUses(512).efficiency(8.0f).attackDamage(3.0f).harvestLevel(2).enchantability(10).repairMaterial(() -> Ingredient.m_204132_((TagKey)CoreTags.RUBY_GEM_TAG)).build();
        SAPPHIRE_ITEM_TIER = SimpleItemTier.builder().maxUses(512).efficiency(8.0f).attackDamage(3.0f).harvestLevel(2).enchantability(10).repairMaterial(() -> Ingredient.m_204132_((TagKey)CoreTags.SAPPHIRE_GEM_TAG)).build();
        PERIDOT_ITEM_TIER = SimpleItemTier.builder().maxUses(512).efficiency(7.75f).attackDamage(2.75f).harvestLevel(2).enchantability(14).repairMaterial(() -> Ingredient.m_204132_((TagKey)CoreTags.PERIDOT_GEM_TAG)).build();
        RUBY_ARMOR_MATERIAL = SimpleArmorMaterial.builder().durabilityFactor(16).damageReduction(new int[]{3, 6, 8, 3}).enchantability(10).soundEvent(SoundEvents.f_11673_).repairMaterial(() -> Ingredient.m_204132_((TagKey)CoreTags.RUBY_GEM_TAG)).textureName("projectred_exploration:ruby").toughness(1.25f).build();
        SAPPHIRE_ARMOR_MATERIAL = SimpleArmorMaterial.builder().durabilityFactor(16).damageReduction(new int[]{3, 6, 8, 3}).enchantability(10).soundEvent(SoundEvents.f_11673_).repairMaterial(() -> Ingredient.m_204132_((TagKey)CoreTags.SAPPHIRE_GEM_TAG)).textureName("projectred_exploration:sapphire").toughness(1.25f).build();
        PERIDOT_ARMOR_MATERIAL = SimpleArmorMaterial.builder().durabilityFactor(14).damageReduction(new int[]{3, 6, 8, 3}).enchantability(14).soundEvent(SoundEvents.f_11673_).repairMaterial(() -> Ingredient.m_204132_((TagKey)CoreTags.PERIDOT_GEM_TAG)).textureName("projectred_exploration:peridot").toughness(1.25f).build();
    }
}

