/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.init;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.exploration.ProjectRedExploration;
import mrtjp.projectred.exploration.init.ExplorationBlocks;
import mrtjp.projectred.exploration.world.gen.ConfigFileControlledAddCarversBiomeModifier;
import mrtjp.projectred.exploration.world.gen.ConfigFileControlledAddFeaturesBiomeModifier;
import mrtjp.projectred.exploration.world.gen.MarbleCaveWorldCarver;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ExplorationWorldFeatures {
    public static final String ID_MARBLE_CAVE_CARVER = "marble_cave";
    public static RegistryObject<WorldCarver<CaveCarverConfiguration>> MARBLE_CAVE_CARVER;
    public static RegistryObject<Codec<ConfigFileControlledAddCarversBiomeModifier>> ADD_CARVER_BIOME_MODIFIER_CODEC;
    public static RegistryObject<Codec<ConfigFileControlledAddFeaturesBiomeModifier>> ADD_FEATURES_BIOME_MODIFIER_CODEC;

    public static void register() {
        MARBLE_CAVE_CARVER = ProjectRedExploration.WORLD_CARVERS.register(ID_MARBLE_CAVE_CARVER, () -> new MarbleCaveWorldCarver((Codec<CaveCarverConfiguration>)CaveCarverConfiguration.f_159154_));
        ADD_CARVER_BIOME_MODIFIER_CODEC = ProjectRedExploration.BIOME_MODIFIER_SERIALIZERS.register("add_carver", ConfigFileControlledAddCarversBiomeModifier::createCodec);
        ADD_FEATURES_BIOME_MODIFIER_CODEC = ProjectRedExploration.BIOME_MODIFIER_SERIALIZERS.register("add_features", ConfigFileControlledAddFeaturesBiomeModifier::createCodec);
    }

    public static JsonCodecProvider<BiomeModifier> biomeModifiersProvider(DataGenerator dataGenerator, ExistingFileHelper existingFileHelper) {
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)RegistryAccess.m_206197_());
        HolderSet.Named isOverworldBiomes = new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_215817_);
        HolderSet.Named overworldCarverReplaceables = new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122901_).get(), BlockTags.f_215820_);
        ConfiguredWorldCarver marbleCaveConfiguredCarver = ((WorldCarver)MARBLE_CAVE_CARVER.get()).m_65063_((CarverConfiguration)new CaveCarverConfiguration(0.01f, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158922_((int)180)), (FloatProvider)UniformFloat.m_146605_((float)0.1f, (float)0.9f), VerticalAnchor.m_158930_((int)8), CarverDebugSettings.m_159136_((boolean)false, (BlockState)Blocks.f_50669_.m_49966_()), (HolderSet)overworldCarverReplaceables, (FloatProvider)UniformFloat.m_146605_((float)0.7f, (float)1.4f), (FloatProvider)UniformFloat.m_146605_((float)0.8f, (float)1.3f), (FloatProvider)UniformFloat.m_146605_((float)-1.0f, (float)-0.4f)));
        ConfiguredFeature<OreConfiguration, ?> rubyOreConfiguration = ExplorationWorldFeatures.createOreConfiguration(ExplorationBlocks.RUBY_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_RUBY_ORE_BLOCK, 8);
        ConfiguredFeature<OreConfiguration, ?> sapphireOreConfiguration = ExplorationWorldFeatures.createOreConfiguration(ExplorationBlocks.SAPPHIRE_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_SAPPHIRE_ORE_BLOCK, 8);
        ConfiguredFeature<OreConfiguration, ?> peridotOreConfiguration = ExplorationWorldFeatures.createOreConfiguration(ExplorationBlocks.PERIDOT_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_PERIDOT_ORE_BLOCK, 10);
        ConfiguredFeature<OreConfiguration, ?> electrotineOreConfiguration = ExplorationWorldFeatures.createOreConfiguration(ExplorationBlocks.ELECTROTINE_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_ELECTROTINE_ORE_BLOCK, 8);
        ConfiguredFeature<OreConfiguration, ?> tinOreConfiguration = ExplorationWorldFeatures.createOreConfiguration(ExplorationBlocks.TIN_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_TIN_ORE_BLOCK, 8);
        ConfiguredFeature<OreConfiguration, ?> silverOreConfiguration = ExplorationWorldFeatures.createOreConfiguration(ExplorationBlocks.SILVER_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_SILVER_ORE_BLOCK, 9);
        PlacedFeature rubyOrePlacedFeature = ExplorationWorldFeatures.createOrePlacement(rubyOreConfiguration, -80, 80, 1);
        PlacedFeature sapphireOrePlacedFeature = ExplorationWorldFeatures.createOrePlacement(sapphireOreConfiguration, -80, 80, 1);
        PlacedFeature peridotOrePlacedFeature = ExplorationWorldFeatures.createOrePlacement(peridotOreConfiguration, -80, 80, 1);
        PlacedFeature electrotineOrePlacedFeature = ExplorationWorldFeatures.createOrePlacement(electrotineOreConfiguration, -32, 32, 4);
        PlacedFeature tinOrePlacedFeature = ExplorationWorldFeatures.createOrePlacement(tinOreConfiguration, -24, 56, 8);
        PlacedFeature silverOrePlacedFeature = ExplorationWorldFeatures.createOrePlacement(silverOreConfiguration, -64, 32, 6);
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)dataGenerator, (ExistingFileHelper)existingFileHelper, (String)"projectred_exploration", (RegistryOps)ops, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, Map.of(new ResourceLocation("projectred_exploration", "add_ruby_ore_to_overworld"), new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)isOverworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)rubyOrePlacedFeature)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.rubyOreKey), new ResourceLocation("projectred_exploration", "add_sapphire_ore_to_overworld"), new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)isOverworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)sapphireOrePlacedFeature)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.sapphireOreKey), new ResourceLocation("projectred_exploration", "add_peridot_ore_to_overworld"), new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)isOverworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)peridotOrePlacedFeature)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.peridotOreKey), new ResourceLocation("projectred_exploration", "add_electrotine_ore_to_overworld"), new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)isOverworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)electrotineOrePlacedFeature)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.electrotineOreKey), new ResourceLocation("projectred_exploration", "add_tin_ore_to_overworld"), new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)isOverworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)tinOrePlacedFeature)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.tinOreKey), new ResourceLocation("projectred_exploration", "add_silver_ore_to_overworld"), new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)isOverworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)silverOrePlacedFeature)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.silverOreKey), new ResourceLocation("projectred_exploration", "add_marble_cave_to_overworld"), new ConfigFileControlledAddCarversBiomeModifier((HolderSet<Biome>)isOverworldBiomes, (HolderSet<ConfiguredWorldCarver<?>>)HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)marbleCaveConfiguredCarver)}), GenerationStep.Carving.AIR, Configurator.marbleCaveKey)));
    }

    private static ConfiguredFeature<OreConfiguration, ?> createOreConfiguration(Supplier<Block> standard, Supplier<Block> deepslate, int veinSize) {
        return new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)standard.get().m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)deepslate.get().m_49966_())), veinSize));
    }

    private static PlacedFeature createOrePlacement(ConfiguredFeature<OreConfiguration, ?> configuredFeature, int minY, int maxY, int count) {
        ImmutableList modifiers = ImmutableList.of((Object)CountPlacement.m_191628_((int)count), (Object)InSquarePlacement.m_191715_(), (Object)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)));
        return new PlacedFeature(Holder.m_205709_(configuredFeature), (List)modifiers);
    }
}

