/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.exploration.init.ExplorationMenus;
import mrtjp.projectred.exploration.inventory.BackpackInventory;
import mrtjp.projectred.exploration.item.BackpackItem;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackContainer
extends AbstractContainerMenu {
    public static final ICCLContainerFactory<BackpackContainer> FACTORY = (windowId, playerInv, packet) -> new BackpackContainer(windowId, playerInv);
    private final BackpackInventory inventory = new BackpackInventory(27);
    private final Inventory playerInventory;

    public BackpackContainer(int windowId, Inventory playerInventory) {
        super((MenuType)ExplorationMenus.BACKPACK_CONTAINER.get(), windowId);
        this.playerInventory = playerInventory;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)86, BackpackPlayerSlot::new, x$0 -> this.m_38897_((Slot)x$0));
        InventoryLib.addInventory((Container)this.inventory, (int)0, (int)8, (int)18, (int)9, (int)3, BackpackSlot::new, x$0 -> this.m_38897_((Slot)x$0));
        this.inventory.m_19164_(this::onBackpackInventoryChanged);
        this.inventory.loadInventoryFromMainHand(playerInventory);
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        int hotbarIndex;
        if (this.isHotbar(slotId) && (hotbarIndex = slotId - 27) == player.m_150109_().f_35977_) {
            return;
        }
        if (clickType == ClickType.SWAP && dragType == player.m_150109_().f_35977_) {
            return;
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.inventory.saveInventoryToMainHand(this.playerInventory);
    }

    public boolean m_6875_(Player player) {
        ItemStack stack = player.m_21205_();
        return BackpackItem.isBackpack(stack);
    }

    protected void onBackpackInventoryChanged(Container backpackInventory) {
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        if (this.isBag(slotIndex) ? !this.moveToEntireInventory(stack, true) : !this.moveToBag(stack, false)) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isBag(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 63;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 36, reverse);
    }

    private boolean moveToBag(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 36, 63, reverse);
    }

    private static class BackpackSlot
    extends Slot {
        public BackpackSlot(Container inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return BackpackItem.isItemAllowedInBackpack(stack);
        }
    }

    private static class BackpackPlayerSlot
    extends Slot {
        public BackpackPlayerSlot(Container inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean m_8010_(Player player) {
            return this.getSlotIndex() != player.m_150109_().f_35977_;
        }
    }
}

