/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.item.crafting;

import java.util.Objects;
import mrtjp.projectred.exploration.init.ExplorationItems;
import mrtjp.projectred.exploration.init.ExplorationRecipeSerializers;
import mrtjp.projectred.exploration.item.BackpackItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;

public class BackpackDyeRecipe
extends CustomRecipe {
    public BackpackDyeRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        ItemStack backpack = ItemStack.f_41583_;
        ItemStack dye = ItemStack.f_41583_;
        int itemCount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++itemCount;
            if (stack.m_41720_() instanceof BackpackItem) {
                if (!backpack.m_41619_()) {
                    return false;
                }
                backpack = stack;
                continue;
            }
            if (!stack.m_204117_(Tags.Items.DYES)) continue;
            if (!dye.m_41619_()) {
                return false;
            }
            dye = stack;
        }
        if (itemCount != 2 || backpack.m_41619_() || dye.m_41619_()) {
            return false;
        }
        DyeColor backpackColor = ((BackpackItem)backpack.m_41720_()).getDyeColor();
        DyeColor dyeColor = DyeColor.getColor((ItemStack)dye);
        if (dyeColor == null) {
            return false;
        }
        return backpackColor != dyeColor;
    }

    public ItemStack assemble(CraftingContainer inventory) {
        ItemStack backpack = ItemStack.f_41583_;
        ItemStack dye = ItemStack.f_41583_;
        int itemCount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++itemCount;
            if (stack.m_41720_() instanceof BackpackItem) {
                if (!backpack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                backpack = stack;
                continue;
            }
            if (!stack.m_204117_(Tags.Items.DYES)) continue;
            if (!dye.m_41619_()) {
                return ItemStack.f_41583_;
            }
            dye = stack;
        }
        if (itemCount != 2 || backpack.m_41619_() || dye.m_41619_()) {
            return ItemStack.f_41583_;
        }
        DyeColor backpackColor = ((BackpackItem)backpack.m_41720_()).getDyeColor();
        DyeColor dyeColor = DyeColor.getColor((ItemStack)dye);
        if (dyeColor == null || backpackColor == dyeColor) {
            return ItemStack.f_41583_;
        }
        ItemStack result = new ItemStack((ItemLike)ExplorationItems.getBackpackByColor(dyeColor.m_41060_()));
        if (backpack.m_41782_()) {
            result.m_41751_(Objects.requireNonNull(backpack.m_41783_()).m_6426_());
        }
        return result;
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ExplorationRecipeSerializers.BACKPACK_DYE_RECIPE_SERIALIZER.get();
    }
}

