/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.exploration.init.ExplorationWorldFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record ConfigFileControlledAddCarversBiomeModifier(HolderSet<Biome> biomes, HolderSet<ConfiguredWorldCarver<?>> carvers, GenerationStep.Carving step, String configKey) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (this.isEnabled() && phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome)) {
            BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
            this.carvers.forEach(holder -> generationSettings.m_204198_(this.step, holder));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ExplorationWorldFeatures.ADD_CARVER_BIOME_MODIFIER_CODEC.get();
    }

    private boolean isEnabled() {
        return Configurator.worldFeatures.getOrDefault(this.configKey, false);
    }

    public static Codec<ConfigFileControlledAddCarversBiomeModifier> createCodec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(m -> m.biomes), (App)ConfiguredWorldCarver.f_64848_.fieldOf("carvers").forGetter(m -> m.carvers), (App)GenerationStep.Carving.f_64194_.fieldOf("step").forGetter(m -> m.step), (App)Codec.STRING.fieldOf("configKey").forGetter(m -> m.configKey)).apply((Applicative)instance, ConfigFileControlledAddCarversBiomeModifier::new));
    }
}

