/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.electricity.network;

import earth.terrarium.botarium.api.energy.EnergyHooks;
import earth.terrarium.botarium.api.energy.PlatformEnergyManager;
import earth.terrarium.botarium.forge.energy.ForgeEnergyManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.newage.content.electricity.connector.ElectricalConnectorBlock;
import org.antarcticgardens.newage.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.newage.content.electricity.connector.ElectricalConnectorMode;
import org.antarcticgardens.newage.content.electricity.network.ElectricalNetworkPathManager;
import org.antarcticgardens.newage.content.electricity.network.ElectricalNetworkTicker;
import org.antarcticgardens.newage.content.electricity.network.EnergyStorageWrapper;
import org.antarcticgardens.newage.content.electricity.network.NetworkPath;
import org.antarcticgardens.newage.content.electricity.network.NetworkPathConductivityContext;

public class ElectricalNetwork {
    private final List<ElectricalConnectorBlockEntity> nodes = new ArrayList<ElectricalConnectorBlockEntity>();
    private final Map<ElectricalConnectorBlockEntity, EnergyStorageWrapper> consumers = new HashMap<ElectricalConnectorBlockEntity, EnergyStorageWrapper>();
    private final Map<ElectricalConnectorBlockEntity, EnergyStorageWrapper> pulledSources = new HashMap<ElectricalConnectorBlockEntity, EnergyStorageWrapper>();
    private final ElectricalNetworkPathManager pathManager = new ElectricalNetworkPathManager();

    public ElectricalNetwork(ElectricalConnectorBlockEntity base) {
        this.nodes.add(base);
    }

    public void addNode(ElectricalConnectorBlockEntity node) {
        this.addNode(node, new ArrayList<ElectricalConnectorBlockEntity>());
        this.updateConsumersAndSources();
    }

    private void addNode(ElectricalConnectorBlockEntity node, List<ElectricalConnectorBlockEntity> processedNodes) {
        if (!this.nodes.contains((Object)node)) {
            this.nodes.add(node);
        }
        processedNodes.add(node);
        if (node.getNetwork() != this) {
            if (node.getNetwork() != null) {
                node.getNetwork().destroy();
            }
            node.setNetwork(this);
            for (ElectricalConnectorBlockEntity connector : node.getConnectors().keySet()) {
                if (processedNodes.contains((Object)connector)) continue;
                this.addNode(connector, processedNodes);
            }
        }
        for (ElectricalConnectorBlockEntity connectedNode : node.getConnectors().keySet()) {
            this.pathManager.addConnection(node, connectedNode);
        }
    }

    public void updateConsumersAndSources() {
        this.consumers.clear();
        this.pulledSources.clear();
        for (ElectricalConnectorBlockEntity node : this.nodes) {
            PlatformEnergyManager storage;
            if (node.m_58904_() == null) continue;
            Direction dir = (Direction)node.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
            BlockEntity entity = node.m_58904_().m_7702_(node.getSupportingBlockPos());
            if (entity == null || entity instanceof ElectricalConnectorBlockEntity || !EnergyHooks.isEnergyContainer((BlockEntity)entity, (Direction)dir) || !((storage = EnergyHooks.getBlockEnergyManager((BlockEntity)entity, (Direction)dir)) instanceof ForgeEnergyManager)) continue;
            ForgeEnergyManager fem = (ForgeEnergyManager)storage;
            if (storage.supportsInsertion()) {
                this.consumers.put(node, new EnergyStorageWrapper(entity, fem.energy()));
            }
            if (!storage.supportsExtraction() || !((ElectricalConnectorMode)((Object)node.m_58900_().m_61143_(ElectricalConnectorBlock.MODE))).pull) continue;
            this.pulledSources.put(node, new EnergyStorageWrapper(entity, fem.energy()));
        }
        if (!this.getWorld().m_5776_()) {
            ElectricalNetworkTicker.addNetwork(this);
        }
    }

    public long insert(ElectricalConnectorBlockEntity from, long amount, boolean simulate) {
        if (this.consumers.isEmpty()) {
            return 0L;
        }
        AtomicLong inserted = new AtomicLong();
        long perConsumer = (long)Math.ceil((double)amount / (double)this.consumers.size());
        NetworkPathConductivityContext context = simulate ? new NetworkPathConductivityContext(this.pathManager.getConductivityContext()) : this.pathManager.getConductivityContext();
        this.consumers.entrySet().stream().sorted(Comparator.comparingDouble(e -> (double)((EnergyStorageWrapper)e.getValue()).storage().getEnergyStored() / (double)((EnergyStorageWrapper)e.getValue()).storage().getMaxEnergyStored())).takeWhile(e -> inserted.get() < amount).forEach(e -> inserted.addAndGet(this.insertInto(from, (Map.Entry<ElectricalConnectorBlockEntity, EnergyStorageWrapper>)e, context, Math.min(perConsumer, amount - inserted.get()), simulate)));
        return inserted.get();
    }

    private long insertInto(ElectricalConnectorBlockEntity from, Map.Entry<ElectricalConnectorBlockEntity, EnergyStorageWrapper> to, NetworkPathConductivityContext context, long amount, boolean simulate) {
        long inserted;
        NetworkPath path;
        long insertedThroughThisPath;
        for (inserted = 0L; (path = this.pathManager.findConductiblePath(from, to.getKey())) != null && inserted < amount; inserted += insertedThroughThisPath) {
            long pathConductivity = context.calculatePathConductivity(path);
            insertedThroughThisPath = to.getValue().insert(Math.min(pathConductivity, amount - inserted), simulate);
            if (insertedThroughThisPath == 0L) break;
            if (simulate || insertedThroughThisPath <= 0L) continue;
            BlockEntity be = to.getValue().entity();
            be.m_6596_();
            Level level = be.m_58904_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().m_8450_(be.m_58899_());
            if (pathConductivity == 0L) continue;
            context.decreasePathConductivity(path, insertedThroughThisPath);
        }
        return inserted;
    }

    public void destroy() {
        ElectricalNetworkTicker.removeNetwork(this);
        for (ElectricalConnectorBlockEntity node : this.nodes) {
            node.setNetwork(new ElectricalNetwork(node));
        }
    }

    protected void tick() {
        for (Map.Entry<ElectricalConnectorBlockEntity, EnergyStorageWrapper> e : this.pulledSources.entrySet()) {
            long maxExtracted = e.getValue().extract(Long.MAX_VALUE, true);
            long inserted = this.insert(e.getKey(), maxExtracted, false);
            e.getValue().extract(inserted, false);
        }
        this.pathManager.tick();
    }

    public Level getWorld() {
        return this.nodes.get(0).m_58904_();
    }

    public List<ElectricalConnectorBlockEntity> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public ElectricalNetworkPathManager getPathManager() {
        return this.pathManager;
    }
}

