/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.model.ModelUtil;
import team.chisel.ctm.client.state.CTMContext;
import team.chisel.ctm.client.util.ProfileUtil;

public abstract class AbstractCTMBakedModel
implements IDynamicBakedModel {
    private static Cache<ModelResourceLocation, AbstractCTMBakedModel> itemcache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static Cache<State, AbstractCTMBakedModel> modelcache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build();
    @Nonnull
    private final IModelCTM model;
    @Nonnull
    private final BakedModel parent;
    @Nonnull
    private final Overrides overrides = new Overrides();
    private final RenderType layer;
    protected final List<BakedQuad> genQuads = new ArrayList<BakedQuad>();
    protected final ListMultimap<Direction, BakedQuad> faceQuads = ArrayListMultimap.create();
    protected static final ModelProperty<CTMContext> CTM_CONTEXT = new ModelProperty();
    protected static final RenderType[] LAYERS = RenderType.m_110506_().toArray(new RenderType[0]);

    public static void invalidateCaches() {
        itemcache.invalidateAll();
        modelcache.invalidateAll();
    }

    public final List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType layer) {
        AbstractCTMBakedModel baked;
        block5: {
            ProfileUtil.start("ctm_models");
            BakedModel parent = this.getParent(rand);
            try {
                if (state == null) {
                    return this.quadLookup(side, layer);
                }
                if (Minecraft.m_91087_().f_91073_ != null && extraData.has(CTM_CONTEXT)) {
                    ProfileUtil.start("state_creation");
                    RenderContextList ctxList = ((CTMContext)extraData.get(CTM_CONTEXT)).getContextList(state, this);
                    Object2LongMap<ICTMTexture<?>> serialized = ctxList.serialized();
                    ProfileUtil.endAndStart("model_creation");
                    baked = (AbstractCTMBakedModel)modelcache.get((Object)new State(state, serialized, parent, layer), () -> this.createModel(state, this.model, parent, ctxList, rand, extraData, layer));
                    ProfileUtil.end();
                    break block5;
                }
                if (state != null) {
                    ProfileUtil.start("model_creation");
                    baked = (AbstractCTMBakedModel)modelcache.get((Object)new State(state, null, parent, layer), () -> this.createModel(state, this.model, parent, null, rand, extraData, layer));
                    ProfileUtil.end();
                    break block5;
                }
                throw new IllegalStateException("Unreachable? Block: " + Objects.toString(state) + "   layer: " + layer);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        ProfileUtil.end();
        List<BakedQuad> quads = baked.quadLookup(side, layer);
        return quads;
    }

    protected final List<BakedQuad> quadLookup(@Nullable Direction side, @Nullable RenderType layer) {
        ProfileUtil.start("quad_lookup");
        List<Object> ret = Collections.emptyList();
        if (layer == this.layer) {
            ret = side != null ? this.faceQuads.get((Object)side) : this.genQuads;
        }
        ProfileUtil.end();
        if (ret == null) {
            throw new IllegalStateException("getQuads called on a model that was not properly initialized - by using getOverrides and/or getModelData");
        }
        ProfileUtil.end();
        return ret;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        if (this.layer != null) {
            return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{ChunkRenderTypeSet.of((RenderType[])new RenderType[]{this.layer}), this.getParent(rand).getRenderTypes(state, rand, data)});
        }
        ArrayList<RenderType> ret = new ArrayList<RenderType>();
        for (RenderType type : ChunkRenderTypeSet.all()) {
            if (!this.getModel().canRenderInLayer(state, type)) continue;
            ret.add(type);
        }
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{ChunkRenderTypeSet.of(ret), this.getParent(rand).getRenderTypes(state, rand, data)});
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        ArrayList<RenderType> ret = new ArrayList<RenderType>();
        ret.addAll(this.getParent().getRenderTypes(itemStack, fabulous));
        if (this.layer != null) {
            if (!ret.contains(this.layer)) {
                ret.add(this.layer);
            }
        } else {
            RenderType type = ItemBlockRenderTypes.m_109279_((ItemStack)itemStack, (boolean)false);
            if (!ret.contains(type)) {
                ret.add(type);
            }
        }
        return ret;
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        return super.getRenderPasses(itemStack, fabulous);
    }

    public ModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData tileData) {
        if (!tileData.has(CTM_CONTEXT)) {
            tileData = tileData.derive().with(CTM_CONTEXT, (Object)new CTMContext((BlockGetter)world, pos)).build();
        }
        return tileData;
    }

    @Nonnull
    public BakedModel getParent(RandomSource rand) {
        BakedModel bakedModel = this.getParent();
        if (bakedModel instanceof WeightedBakedModel) {
            WeightedBakedModel weightedBakedModel = (WeightedBakedModel)bakedModel;
            Optional model = WeightedRandom.m_146314_((List)weightedBakedModel.f_119541_, (int)(Math.abs((int)rand.m_188505_()) % ((WeightedBakedModel)this.getParent()).f_119540_));
            if (model.isPresent()) {
                return (BakedModel)((WeightedEntry.Wrapper)model.get()).m_146310_();
            }
        }
        return this.getParent();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public boolean m_7541_() {
        return this.parent.m_7541_();
    }

    public boolean m_7539_() {
        return this.parent.m_7539_();
    }

    public boolean m_7521_() {
        return this.parent.m_7521_();
    }

    @Deprecated
    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.parent.m_6160_();
    }

    @Nonnull
    public ItemTransforms m_7442_() {
        return this.parent.m_7442_();
    }

    protected abstract AbstractCTMBakedModel createModel(BlockState var1, @Nonnull IModelCTM var2, BakedModel var3, RenderContextList var4, RandomSource var5, ModelData var6, @Nullable RenderType var7);

    public boolean m_7547_() {
        return this.getParent().m_7547_();
    }

    private <T> T applyToParent(RandomSource rand, Function<AbstractCTMBakedModel, T> func) {
        BakedModel parent = this.getParent(rand);
        if (parent instanceof AbstractCTMBakedModel) {
            AbstractCTMBakedModel ctmBakedModel = (AbstractCTMBakedModel)parent;
            return func.apply(ctmBakedModel);
        }
        return null;
    }

    protected ICTMTexture<?> getOverrideTexture(RandomSource rand, int tintIndex, ResourceLocation texture) {
        ICTMTexture ret = this.getModel().getOverrideTexture(tintIndex, texture);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getOverrideTexture(rand, tintIndex, texture));
        }
        return ret;
    }

    protected ICTMTexture<?> getTexture(RandomSource rand, ResourceLocation texture) {
        ICTMTexture ret = this.getModel().getTexture(texture);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getTexture(rand, texture));
        }
        return ret;
    }

    protected TextureAtlasSprite getOverrideSprite(RandomSource rand, int tintIndex) {
        TextureAtlasSprite ret = this.getModel().getOverrideSprite(tintIndex);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getOverrideSprite(rand, tintIndex));
        }
        return ret;
    }

    public Collection<ICTMTexture<?>> getCTMTextures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.getModel().getCTMTextures());
        if (this.getParent() instanceof AbstractCTMBakedModel) {
            builder.addAll(((AbstractCTMBakedModel)this.getParent()).getCTMTextures());
        }
        return builder.build();
    }

    public AbstractCTMBakedModel(@Nonnull IModelCTM model, @Nonnull BakedModel parent, RenderType layer) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        this.model = model;
        this.parent = parent;
        this.layer = layer;
    }

    @Nonnull
    public IModelCTM getModel() {
        return this.model;
    }

    @Nonnull
    public BakedModel getParent() {
        return this.parent;
    }

    private static class State {
        @Nonnull
        private final BlockState cleanState;
        @Nullable
        private final Object2LongMap<ICTMTexture<?>> serializedContext;
        @Nonnull
        private final BakedModel parent;
        @Nullable
        private final RenderType layer;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            if (this.cleanState != other.cleanState) {
                return false;
            }
            if (this.parent != other.parent) {
                return false;
            }
            if (this.layer != other.layer) {
                return false;
            }
            return !(this.serializedContext == null ? other.serializedContext != null : !this.serializedContext.equals(other.serializedContext));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + System.identityHashCode(this.cleanState);
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            result = 31 * result + (this.serializedContext == null ? 0 : this.serializedContext.hashCode());
            result = 31 * result + (this.layer == null ? 0 : this.layer.hashCode());
            return result;
        }

        @Nonnull
        public BlockState getCleanState() {
            return this.cleanState;
        }

        @Nullable
        public Object2LongMap<ICTMTexture<?>> getSerializedContext() {
            return this.serializedContext;
        }

        @Nonnull
        public BakedModel getParent() {
            return this.parent;
        }

        @Nullable
        public RenderType getLayer() {
            return this.layer;
        }

        public State(@Nonnull BlockState cleanState, @Nullable Object2LongMap<ICTMTexture<?>> serializedContext, @Nonnull BakedModel parent, @Nullable RenderType layer) {
            if (cleanState == null) {
                throw new NullPointerException("cleanState is marked non-null but is null");
            }
            if (parent == null) {
                throw new NullPointerException("parent is marked non-null but is null");
            }
            this.cleanState = cleanState;
            this.serializedContext = serializedContext;
            this.parent = parent;
            this.layer = layer;
        }

        public String toString() {
            return "AbstractCTMBakedModel.State(cleanState=" + this.getCleanState() + ", serializedContext=" + this.getSerializedContext() + ", parent=" + this.getParent() + ", layer=" + this.getLayer() + ")";
        }
    }

    @ParametersAreNonnullByDefault
    private class Overrides
    extends ItemOverrides {
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, ClientLevel world, LivingEntity entity, int unknown) {
            Block block = null;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.m_40614_();
            }
            BlockState state = block == null ? null : block.m_49966_();
            ModelResourceLocation mrl = ModelUtil.getMesh(stack);
            if (mrl == null) {
                return Minecraft.m_91087_().m_91289_().m_110907_().m_110881_().m_119409_();
            }
            RandomSource random = RandomSource.m_216327_();
            random.m_188584_(42L);
            return (BakedModel)itemcache.get((Object)mrl, () -> AbstractCTMBakedModel.this.createModel(state, AbstractCTMBakedModel.this.model, AbstractCTMBakedModel.this.getParent(random), null, random, ModelData.EMPTY, null));
        }
    }
}

