/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.minecolonies;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.costs.IResearchCost;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.core.research.BuildingResearchRequirement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.server.command.TextComponentHelper;

public class MineColonies {
    public static boolean hasAccess(Entity entity, IColony colony) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (colony != null) {
                return colony.getPermissions().hasPermission(player, Action.ACCESS_HUTS);
            }
        }
        return false;
    }

    public static Object citizenToObject(ICitizenData citizen) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", citizen.getId());
        map.put("name", citizen.getName());
        map.put("bedPos", LuaConverter.posToObject(citizen.getBedPos()));
        map.put("children", citizen.getChildren());
        map.put("location", LuaConverter.posToObject(citizen.getLastPosition()));
        map.put("state", citizen.getStatus() == null ? "Idle" : Component.m_237115_((String)citizen.getStatus().getTranslationKey()).getString());
        map.put("age", citizen.isChild() ? "child" : "adult");
        map.put("gender", citizen.isFemale() ? "female" : "male");
        map.put("saturation", citizen.getSaturation());
        map.put("happiness", citizen.getCitizenHappinessHandler().getHappiness(citizen.getColony(), citizen));
        map.put("skills", MineColonies.skillsToObject(citizen.getCitizenSkillHandler().getSkills()));
        map.put("work", citizen.getWorkBuilding() == null ? null : MineColonies.jobToObject(citizen.getWorkBuilding(), citizen.getJob()));
        map.put("home", citizen.getHomeBuilding() == null ? null : MineColonies.homeToObject(citizen.getHomeBuilding()));
        map.put("betterFood", citizen.needsBetterFood());
        map.put("isAsleep", map.get("state").toString().toLowerCase().contains("sleeping"));
        map.put("isIdle", map.get("state").toString().toLowerCase().contains("idle"));
        citizen.getEntity().ifPresent(entity -> {
            map.put("health", Float.valueOf(entity.m_21223_()));
            map.put("maxHealth", Float.valueOf(entity.m_21233_()));
            map.put("armor", entity.m_21133_(Attributes.f_22284_));
            map.put("toughness", entity.m_21133_(Attributes.f_22285_));
        });
        return map;
    }

    public static Object visitorToObject(IVisitorData visitor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", visitor.getId());
        map.put("name", visitor.getName());
        map.put("location", LuaConverter.posToObject(visitor.getSittingPosition()));
        map.put("age", visitor.isChild() ? "child" : "adult");
        map.put("gender", visitor.isFemale() ? "female" : "male");
        map.put("saturation", visitor.getSaturation());
        map.put("happiness", visitor.getCitizenHappinessHandler().getHappiness(visitor.getColony(), (ICitizenData)visitor));
        map.put("skills", MineColonies.skillsToObject(visitor.getCitizenSkillHandler().getSkills()));
        map.put("recruitCost", LuaConverter.stackToObject(visitor.getRecruitCost()));
        return map;
    }

    public static Object jobToObject(IBuilding work, IJob<?> job) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", LuaConverter.posToObject(work.getLocation().getInDimensionLocation()));
        map.put("type", work.getSchematicName());
        map.put("level", work.getBuildingLevel());
        map.put("name", work.getBuildingDisplayName());
        map.put("job", job.getJobRegistryEntry().getTranslationKey());
        return map;
    }

    public static Object homeToObject(IBuilding home) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", LuaConverter.posToObject(home.getLocation().getInDimensionLocation()));
        map.put("type", home.getSchematicName());
        map.put("level", home.getBuildingLevel());
        return map;
    }

    public static Object skillsToObject(Map<Skill, Tuple<Integer, Double>> skills) {
        HashMap map = new HashMap();
        for (Skill skill : skills.keySet()) {
            HashMap<String, Object> skillData = new HashMap<String, Object>();
            skillData.put("level", skills.get(skill).m_14418_());
            skillData.put("xp", skills.get(skill).m_14419_());
            map.put(skill.name(), skillData);
        }
        return map;
    }

    public static Object buildingToObject(IRegisteredStructureManager buildingManager, IBuilding building, BlockPos pos) {
        HashMap<String, Object> structureData = new HashMap<String, Object>();
        structureData.put("cornerA", LuaConverter.posToObject((BlockPos)building.getCorners().m_14418_()));
        structureData.put("cornerB", LuaConverter.posToObject((BlockPos)building.getCorners().m_14419_()));
        structureData.put("rotation", building.getRotation());
        structureData.put("mirror", building.isMirrored());
        ArrayList citizensData = new ArrayList();
        for (ICitizenData citizen : building.getAllAssignedCitizen()) {
            HashMap<String, Object> citizenData = new HashMap<String, Object>();
            citizenData.put("id", citizen.getId());
            citizenData.put("name", citizen.getName());
            citizensData.add(citizenData);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", LuaConverter.posToObject(pos));
        map.put("type", building.getSchematicName());
        map.put("style", building.getStructurePack());
        map.put("level", building.getBuildingLevel());
        map.put("maxLevel", building.getMaxBuildingLevel());
        map.put("name", building.getBuildingDisplayName());
        map.put("built", building.isBuilt());
        map.put("isWorkingOn", building.hasWorkOrder());
        map.put("priority", building.getPickUpPriority());
        map.put("structure", structureData);
        map.put("citizens", citizensData);
        map.put("storageBlocks", building.getContainers().size());
        map.put("storageSlots", MineColonies.getStorageSize(building));
        map.put("guarded", buildingManager.hasGuardBuildingNear(building));
        return map;
    }

    public static int getStorageSize(IBuilding building) {
        LazyOptional capability = building.getCapability(ForgeCapabilities.ITEM_HANDLER);
        IItemHandler handler = capability.resolve().orElse(null);
        if (handler != null) {
            return handler.getSlots();
        }
        return 0;
    }

    public static int getAmountOfConstructionSites(IColony colony) {
        int constructionSites = 0;
        for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
            if (!building.hasWorkOrder()) continue;
            ++constructionSites;
        }
        return constructionSites;
    }

    public static Object workOrderToObject(IWorkOrder workOrder) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("builder", LuaConverter.posToObject(workOrder.getClaimedBy()));
        map.put("changed", workOrder.isDirty());
        map.put("id", workOrder.getID());
        map.put("priority", workOrder.getPriority());
        map.put("isClaimed", workOrder.isClaimed());
        map.put("location", LuaConverter.posToObject(workOrder.getLocation()));
        map.put("type", workOrder.getClass().getSimpleName());
        map.put("buildingName", workOrder.getDisplayName().getString());
        map.put("targetLevel", workOrder.getTargetLevel());
        map.put("workOrderType", workOrder.getWorkOrderType().toString());
        return map;
    }

    public static List<Object> getResearch(ResourceLocation branch, List<ResourceLocation> researches, IColony colony) throws CommandSyntaxException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (researches != null) {
            for (ResourceLocation researchName : researches) {
                Object researchEffect2;
                IGlobalResearchTree globalTree = IGlobalResearchTree.getInstance();
                ILocalResearchTree colonyTree = colony.getResearchManager().getResearchTree();
                IGlobalResearch research = globalTree.getResearch(branch, researchName);
                if (research == null || research.isHidden()) continue;
                ILocalResearch colonyResearch = colonyTree.getResearch(branch, researchName);
                ArrayList<String> effects = new ArrayList<String>();
                for (Object researchEffect2 : research.getEffects()) {
                    effects.add(TextComponentHelper.createComponentTranslation(null, (String)researchEffect2.getDesc().m_237508_(), (Object[])researchEffect2.getDesc().m_237523_()).getString());
                }
                ArrayList cost = new ArrayList();
                researchEffect2 = research.getCostList().iterator();
                while (researchEffect2.hasNext()) {
                    IResearchCost item = (IResearchCost)researchEffect2.next();
                    HashMap<String, Object> researchCost = new HashMap<String, Object>();
                    ArrayList<Map<String, Object>> researchCostItems = new ArrayList<Map<String, Object>>();
                    for (Item costItem : item.getItems()) {
                        researchCostItems.add(LuaConverter.itemToObject(costItem));
                    }
                    researchCost.put("validItems", researchCostItems);
                    researchCost.put("count", item.getCount());
                    researchCost.put("", item.getType().getId().toString());
                    cost.add(researchCost);
                }
                ArrayList requirements = new ArrayList();
                for (IResearchRequirement requirement : research.getResearchRequirement()) {
                    HashMap<String, Object> requirementItem = new HashMap<String, Object>();
                    requirementItem.put("fulfilled", requirement.isFulfilled(colony));
                    if (requirement instanceof BuildingResearchRequirement) {
                        BuildingResearchRequirement buildingRequirement = (BuildingResearchRequirement)requirement;
                        requirementItem.put("type", "building");
                        requirementItem.put("building", buildingRequirement.getBuilding());
                        requirementItem.put("level", buildingRequirement.getBuildingLevel());
                    } else {
                        requirementItem.put("type", requirement.getClass().getCanonicalName());
                    }
                    requirementItem.put("desc", requirement.getDesc().getString());
                    requirements.add(requirementItem);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", researchName.toString());
                map.put("name", TextComponentHelper.createComponentTranslation(null, (String)research.getName().m_237508_(), (Object[])research.getName().m_237523_()).getString());
                map.put("requirements", requirements);
                map.put("cost", cost);
                map.put("researchEffects", effects);
                map.put("status", colonyResearch == null ? ResearchState.NOT_STARTED.toString() : colonyResearch.getState().toString());
                map.put("neededTime", colonyResearch == null ? 0 : IGlobalResearchTree.getInstance().getBranchData(colonyResearch.getBranch()).getBaseTime(colonyResearch.getDepth()));
                map.put("progress", colonyResearch == null ? 0 : colonyResearch.getProgress());
                List<Object> childrenResearch = MineColonies.getResearch(branch, research.getChildren(), colony);
                if (!childrenResearch.isEmpty()) {
                    map.put("children", childrenResearch);
                }
                result.add(map);
            }
        }
        return result;
    }

    public static Object builderResourcesToObject(IColony colony, BlockPos pos) {
        IBuilding building = colony.getBuildingManager().getBuilding(pos);
        if (!(building instanceof AbstractBuildingStructureBuilder)) {
            return null;
        }
        AbstractBuildingStructureBuilder builderBuilding = (AbstractBuildingStructureBuilder)building;
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        builderBuilding.serializeToView(buffer);
        buffer.release();
        ArrayList resources = new ArrayList(builderBuilding.getNeededResources().values());
        resources.sort(new BuildingBuilderResource.ResourceComparator(new BuildingBuilderResource.RessourceAvailability[0]));
        ArrayList result = new ArrayList();
        for (BuildingBuilderResource resource : resources) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ItemStack stack = resource.getItemStack().m_41777_();
            map.put("item", LuaConverter.stackToObject(stack));
            map.put("displayName", resource.getName());
            map.put("available", resource.getAvailable());
            map.put("delivering", resource.getAmountInDelivery());
            map.put("status", resource.getAvailabilityStatus().toString());
            map.put("needed", resource.getAmount());
            result.add(map);
        }
        return result;
    }
}

