/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.fakeplayer;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.util.WorldUtil;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public final class FakePlayerProviderTurtle {
    private static final WeakHashMap<ITurtleAccess, APFakePlayer> registeredPlayers = new WeakHashMap();

    private FakePlayerProviderTurtle() {
    }

    public static APFakePlayer getPlayer(ITurtleAccess turtle, GameProfile profile) {
        return registeredPlayers.computeIfAbsent(turtle, iTurtleAccess -> new APFakePlayer((ServerLevel)turtle.getLevel(), null, profile));
    }

    public static void load(APFakePlayer player, ITurtleAccess turtle) {
        int i;
        Direction direction = turtle.getDirection();
        player.m_143425_((ServerLevel)turtle.getLevel());
        BlockPos position = turtle.getPosition();
        player.m_7678_((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5, direction.m_122435_(), 0.0f);
        Inventory playerInventory = player.m_150109_();
        playerInventory.f_35977_ = 0;
        IItemHandlerModifiable turtleInventory = turtle.getItemHandler();
        int size = turtleInventory.getSlots();
        int largerSize = playerInventory.m_6643_();
        playerInventory.f_35977_ = turtle.getSelectedSlot();
        for (i = 0; i < size; ++i) {
            playerInventory.m_6836_(i, turtleInventory.getStackInSlot(i));
        }
        for (i = size; i < largerSize; ++i) {
            playerInventory.m_6836_(i, ItemStack.f_41583_);
        }
        ItemStack activeStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!activeStack.m_41619_()) {
            player.m_21204_().m_22178_(activeStack.m_41638_(EquipmentSlot.MAINHAND));
        }
    }

    public static void unload(APFakePlayer player, ITurtleAccess turtle) {
        int i;
        Inventory playerInventory = player.m_150109_();
        playerInventory.f_35977_ = 0;
        ItemStack activeStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!activeStack.m_41619_()) {
            player.m_21204_().m_22161_(activeStack.m_41638_(EquipmentSlot.MAINHAND));
        }
        IItemHandlerModifiable turtleInventory = turtle.getItemHandler();
        int size = turtleInventory.getSlots();
        int largerSize = playerInventory.m_6643_();
        playerInventory.f_35977_ = turtle.getSelectedSlot();
        for (i = 0; i < size; ++i) {
            turtleInventory.setStackInSlot(i, playerInventory.m_8020_(i));
            playerInventory.m_6836_(i, ItemStack.f_41583_);
        }
        for (i = size; i < largerSize; ++i) {
            ItemStack remaining = playerInventory.m_8020_(i);
            if (!remaining.m_41619_() && !(remaining = ItemHandlerHelper.insertItem((IItemHandler)turtleInventory, (ItemStack)remaining, (boolean)false)).m_41619_()) {
                BlockPos position = turtle.getPosition();
                WorldUtil.dropItemStack((ItemStack)remaining, (Level)turtle.getLevel(), (BlockPos)position, (Direction)turtle.getDirection().m_122424_());
            }
            playerInventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public static <T> T withPlayer(ITurtleAccess turtle, Function<APFakePlayer, T> function) {
        APFakePlayer player = FakePlayerProviderTurtle.getPlayer(turtle, turtle.getOwningPlayer());
        FakePlayerProviderTurtle.load(player, turtle);
        T result = function.apply(player);
        FakePlayerProviderTurtle.unload(player, turtle);
        return result;
    }
}

