/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.client;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.api.MovingBlockEntityRenderCallback;
import mrtjp.projectred.api.ProjectRedAPI;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.client.HaloBloomPostChain;
import mrtjp.projectred.core.init.CoreClientInit;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.Nullable;

public class HaloRenderer {
    @Nullable
    private static HaloBloomPostChain HALO_POST_CHAIN;
    private static final RenderType HALO_GLOW_RENDER_TYPE;
    private static final RenderType HALO_FABULOUS_DEPTH_RENDER_TYPE;
    private static final RenderType HALO_FABULOUS_BLOOM_RENDER_TYPE;
    private static final RenderType HALO_FABULOUS_ITEM_ENTITY_RENDER_TYPE;
    private static boolean postChainFlushPending;
    private static final LinkedList<HaloRenderData> levelHalos;
    private static final LinkedList<HaloRenderData> entityHalos;
    private static final Vector3 offset;

    public static void init() {
        if (ProjectRedAPI.expansionAPI != null) {
            ProjectRedAPI.expansionAPI.registerBlockEntityRenderCallback(new MovingBlockEntityRenderCallback(){

                @Override
                public void onMovingPreRender(double offsetX, double offsetY, double offsetZ) {
                    offset.set(offsetX, offsetY, offsetZ);
                }

                @Override
                public void onMovingPostRender() {
                    offset.set(0.0, 0.0, 0.0);
                }
            });
        }
    }

    public static void onRenderLevelStageEvent(RenderLevelStageEvent event) {
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            HaloRenderer.onRenderStageAfterParticles(event);
        }
    }

    public static void onRenderLevelLastEvent(RenderLevelLastEvent event) {
        HaloRenderer.onRenderStageAfterLevel(event);
    }

    public static void onResourceManagerReload(ResourceManager manager) {
        HaloRenderer.loadPostChain();
    }

    public static void addLight(BlockPos pos, Cuboid6 box, int colourIndex) {
        HaloRenderer.addLight((Transformation)new Translation((Vec3i)pos), box, colourIndex);
    }

    public static void addLight(Transformation t, Cuboid6 box, int colourIndex) {
        TransformationList t2 = new TransformationList(new Transformation[]{t, new Translation(offset)});
        HaloRenderer.addHalo(levelHalos, new HaloRenderData(box, (Transformation)t2).setColourIndex(colourIndex));
    }

    public static void addMultiLight(BlockPos pos, Cuboid6 box, byte[] alphas) {
        HaloRenderer.addMultiLight((Transformation)new Translation((Vec3i)pos), box, alphas);
    }

    public static void addMultiLight(Transformation t, Cuboid6 box, byte[] alphas) {
        TransformationList t2 = new TransformationList(new Transformation[]{t, new Translation(offset)});
        HaloRenderer.addHalo(levelHalos, new HaloRenderData(box, (Transformation)t2).setMultiColourAlphas(alphas));
    }

    private static void addHalo(LinkedList<HaloRenderData> list, HaloRenderData data) {
        list.add(data);
        if (Configurator.lightHaloMax > -1 && list.size() > Configurator.lightHaloMax) {
            list.poll();
        }
    }

    public static void onRenderStageAfterParticles(RenderLevelStageEvent event) {
        if (levelHalos.isEmpty() && entityHalos.isEmpty()) {
            return;
        }
        if (!HaloRenderer.isFabulous()) {
            return;
        }
        HaloRenderer.preparePostChain();
        assert (HALO_POST_CHAIN != null);
        HALO_POST_CHAIN.getInputTarget().m_83954_(Minecraft.f_91002_);
        HALO_POST_CHAIN.getInputTarget().m_83945_(Minecraft.m_91087_().m_91385_());
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 cam = event.getCamera().m_90583_();
        PoseStack stack = event.getPoseStack();
        stack.m_85836_();
        stack.m_85837_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_);
        List<HaloRenderData> lightList = HaloRenderer.pollHalos(levelHalos);
        ccrs.bind(HALO_GLOW_RENDER_TYPE, (MultiBufferSource)buffers, stack);
        for (HaloRenderData light : lightList) {
            HaloRenderer.renderToCCRS(ccrs, light.box, light.t, light.levelGlowRgba);
        }
        ccrs.bind(HALO_FABULOUS_DEPTH_RENDER_TYPE, (MultiBufferSource)buffers, stack);
        for (HaloRenderData light : lightList) {
            HaloRenderer.renderToCCRS(ccrs, light.box, light.t, -1);
        }
        ccrs.bind(HALO_FABULOUS_BLOOM_RENDER_TYPE, (MultiBufferSource)buffers, stack);
        for (HaloRenderData light : lightList) {
            HaloRenderer.renderToCCRS(ccrs, light.box, light.t, light.bloomRgba);
        }
        stack.m_85849_();
        List<HaloRenderData> entityLightList = HaloRenderer.pollHalos(entityHalos);
        ccrs.bind(HALO_FABULOUS_BLOOM_RENDER_TYPE, (MultiBufferSource)buffers);
        for (HaloRenderData light : entityLightList) {
            HaloRenderer.renderToCCRS(ccrs, light.box, light.t, light.bloomRgba);
        }
        buffers.m_109911_();
        postChainFlushPending = true;
    }

    public static void onRenderStageAfterLevel(RenderLevelLastEvent event) {
        if (!HaloRenderer.isFabulous()) {
            if (levelHalos.isEmpty()) {
                return;
            }
            List<HaloRenderData> lightList = HaloRenderer.pollHalos(levelHalos);
            Vec3 cam = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_();
            PoseStack stack = event.getPoseStack();
            stack.m_85836_();
            stack.m_85837_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
            ccrs.bind(HALO_GLOW_RENDER_TYPE, (MultiBufferSource)buffers, stack);
            for (HaloRenderData light : lightList) {
                HaloRenderer.renderToCCRS(ccrs, light.box, light.t, light.levelGlowRgba);
            }
            buffers.m_109911_();
            stack.m_85849_();
        }
        if (HaloRenderer.isFabulous() && postChainFlushPending) {
            postChainFlushPending = false;
            assert (HALO_POST_CHAIN != null);
            HALO_POST_CHAIN.m_110023_(event.getPartialTick());
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
    }

    private static List<HaloRenderData> pollHalos(LinkedList<HaloRenderData> src) {
        HaloRenderData l;
        LinkedList<HaloRenderData> dest = new LinkedList<HaloRenderData>();
        while ((l = src.poll()) != null) {
            dest.add(l);
        }
        return dest;
    }

    private static void preparePostChain() {
        if (HALO_POST_CHAIN == null) {
            HaloRenderer.loadPostChain();
        }
        HALO_POST_CHAIN.resizeIfNeeded();
    }

    private static void loadPostChain() {
        HaloRenderer.unloadPostChain();
        try {
            HALO_POST_CHAIN = new HaloBloomPostChain();
            HALO_POST_CHAIN.m_110025_(Minecraft.m_91087_().m_91268_().m_85441_(), Minecraft.m_91087_().m_91268_().m_85442_());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load halo post chain", e);
        }
    }

    private static void unloadPostChain() {
        if (HALO_POST_CHAIN != null) {
            HALO_POST_CHAIN.close();
            HALO_POST_CHAIN = null;
        }
    }

    private static boolean isFabulous() {
        return Configurator.fabulousLights && ((GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_()).m_35965_() >= GraphicsStatus.FABULOUS.m_35965_();
    }

    private static void renderToCCRS(CCRenderState ccrs, Cuboid6 cuboid, Transformation t, int rgba) {
        ccrs.setPipeline(new IVertexOperation[]{t});
        ccrs.baseColour = rgba;
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)cuboid, (int)0);
    }

    public static void renderInventoryHalo(CCRenderState ccrs, PoseStack mStack, MultiBufferSource buffers, Cuboid6 cuboid, Vector3 pos, int colourIndex) {
        int rgba = HaloRenderer.getBaseColour(colourIndex, HaloContext.ITEM_GLOW);
        HaloRenderer.renderInventoryHaloRgba(ccrs, mStack, buffers, cuboid, pos, rgba);
    }

    public static void renderInventoryMultiHalo(CCRenderState ccrs, PoseStack mStack, MultiBufferSource buffers, Cuboid6 cuboid, Vector3 pos, byte[] alphas) {
        int rgba = HaloRenderer.getBlendedColour(alphas, HaloContext.ITEM_GLOW);
        HaloRenderer.renderInventoryHaloRgba(ccrs, mStack, buffers, cuboid, pos, rgba);
    }

    private static void renderInventoryHaloRgba(CCRenderState ccrs, PoseStack mStack, MultiBufferSource buffers, Cuboid6 cuboid, Vector3 pos, int rgba) {
        RenderType type = HaloRenderer.isFabulous() ? HALO_FABULOUS_ITEM_ENTITY_RENDER_TYPE : HALO_GLOW_RENDER_TYPE;
        ccrs.reset();
        ccrs.bind(type, buffers, mStack);
        HaloRenderer.renderToCCRS(ccrs, cuboid, (Transformation)pos.translation(), rgba);
    }

    public static void addItemRendererBloom(ItemTransforms.TransformType transformType, PoseStack stack, Vector3 pos, Cuboid6 box, int colourIndex) {
        if (HaloRenderer.isEntityItemRenderType(transformType)) {
            HaloRenderer.addItemRendererBloom(stack, pos, box, colourIndex);
        }
    }

    public static void addItemRendererBloom(PoseStack stack, Vector3 pos, Cuboid6 box, int colourIndex) {
        TransformationList t = new Matrix4(stack.m_85850_().m_85861_()).with((Transformation)pos.translation());
        HaloRenderer.addHalo(entityHalos, new HaloRenderData(box, (Transformation)t).setColourIndex(colourIndex));
    }

    public static void addItemRendererMultiBloom(ItemTransforms.TransformType transformType, PoseStack stack, Vector3 pos, Cuboid6 box, byte[] alphas) {
        if (HaloRenderer.isEntityItemRenderType(transformType)) {
            HaloRenderer.addItemRendererMultiBloom(stack, pos, box, alphas);
        }
    }

    public static void addItemRendererMultiBloom(PoseStack stack, Vector3 pos, Cuboid6 box, byte[] alphas) {
        TransformationList t = new Matrix4(stack.m_85850_().m_85861_()).with((Transformation)pos.translation());
        HaloRenderer.addHalo(entityHalos, new HaloRenderData(box, (Transformation)t).setMultiColourAlphas(alphas));
    }

    private static boolean isEntityItemRenderType(ItemTransforms.TransformType transformType) {
        return switch (transformType) {
            case ItemTransforms.TransformType.GROUND, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND -> true;
            default -> false;
        };
    }

    private static int getBaseColour(int colorIndex, HaloContext context) {
        return LightColours.byIndex(colorIndex).rgbaByContext(context);
    }

    private static int getBlendedColour(byte[] alphas, HaloContext context) {
        int aTotal = 0;
        int aMax = 0;
        for (int i = 0; i < 16; ++i) {
            aTotal += alphas[i] & 0xFF;
            aMax = Math.max(aMax, alphas[i] & 0xFF);
        }
        if (aTotal == 0) {
            return 0;
        }
        float[] aNorm = new float[16];
        for (int i = 0; i < 16; ++i) {
            aNorm[i] = (float)(alphas[i] & 0xFF) / (float)aTotal * (float)aMax / 255.0f;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 0.0f;
        for (int i = 0; i < 16; ++i) {
            if (alphas[i] == 0) continue;
            int colour = HaloRenderer.getBaseColour(i, context);
            float rsrc = (float)(colour >> 24 & 0xFF) / 255.0f;
            float gsrc = (float)(colour >> 16 & 0xFF) / 255.0f;
            float bsrc = (float)(colour >> 8 & 0xFF) / 255.0f;
            float asrc = aNorm[i];
            r = rsrc * asrc + r * (1.0f - asrc);
            g = gsrc * asrc + g * (1.0f - asrc);
            b = bsrc * asrc + b * (1.0f - asrc);
            a = asrc * asrc + a * (1.0f - asrc);
        }
        return (int)(r * 255.0f) << 24 | (int)(g * 255.0f) << 16 | (int)(b * 255.0f) << 8 | 0xA0;
    }

    static {
        HALO_GLOW_RENDER_TYPE = RenderType.m_173215_((String)"projectred_core:halo", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)2048, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110136_).m_173292_(new RenderStateShard.ShaderStateShard(() -> CoreClientInit.HALO_SHADER)).m_110661_(RenderStateShard.f_110158_).m_110675_(RenderStateShard.f_110126_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
        HALO_FABULOUS_DEPTH_RENDER_TYPE = RenderType.m_173215_((String)"projectred_core:halo_depth", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)2048, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110134_).m_173292_(new RenderStateShard.ShaderStateShard(() -> CoreClientInit.HALO_SHADER)).m_110661_(RenderStateShard.f_110158_).m_110675_(RenderStateShard.f_110126_).m_110687_(RenderStateShard.f_110116_).m_110691_(false));
        HALO_FABULOUS_BLOOM_RENDER_TYPE = RenderType.m_173215_((String)"projectred_core:halo_bloom", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)2048, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110134_).m_173292_(new RenderStateShard.ShaderStateShard(() -> CoreClientInit.HALO_SHADER)).m_110661_(RenderStateShard.f_110158_).m_110675_(new RenderStateShard.OutputStateShard("halo_post", () -> HALO_POST_CHAIN.getInputTarget().m_83947_(false), () -> Minecraft.m_91087_().m_91385_().m_83947_(false))).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
        HALO_FABULOUS_ITEM_ENTITY_RENDER_TYPE = RenderType.m_173215_((String)"projectred_core:halo_item_entity", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110136_).m_173292_(new RenderStateShard.ShaderStateShard(() -> CoreClientInit.HALO_SHADER)).m_110661_(RenderStateShard.f_110158_).m_110675_(RenderStateShard.f_110123_).m_110687_(RenderStateShard.f_110114_).m_110691_(false));
        postChainFlushPending = false;
        levelHalos = new LinkedList();
        entityHalos = new LinkedList();
        offset = Vector3.ZERO.copy();
    }

    private static class HaloRenderData {
        public final Cuboid6 box;
        public final Transformation t;
        public int levelGlowRgba;
        public int inventoryGlowRgba;
        public int bloomRgba;

        public HaloRenderData(Cuboid6 box, Transformation t) {
            this.box = box;
            this.t = t;
        }

        public HaloRenderData setColourIndex(int colourIndex) {
            this.levelGlowRgba = HaloRenderer.getBaseColour(colourIndex, HaloContext.LEVEL_GLOW);
            this.inventoryGlowRgba = HaloRenderer.getBaseColour(colourIndex, HaloContext.ITEM_GLOW);
            this.bloomRgba = HaloRenderer.getBaseColour(colourIndex, HaloContext.BLOOM);
            return this;
        }

        public HaloRenderData setMultiColourAlphas(byte[] alphas) {
            this.levelGlowRgba = HaloRenderer.getBlendedColour(alphas, HaloContext.LEVEL_GLOW);
            this.inventoryGlowRgba = HaloRenderer.getBlendedColour(alphas, HaloContext.ITEM_GLOW);
            this.bloomRgba = HaloRenderer.getBlendedColour(alphas, HaloContext.BLOOM);
            return this;
        }
    }

    private static enum HaloContext {
        ITEM_GLOW,
        LEVEL_GLOW,
        BLOOM;

    }

    private static enum LightColours {
        WHITE(-96, 0.9f, 0.8f, 0.8f),
        ORANGE(-1067253600, 0.8f, 0.8f, 0.8f),
        MAGENTA(-1256540768, 0.8f, 0.8f, 0.8f),
        LIGHT_BLUE(1870983584, 0.9f, 0.9f, 0.9f),
        YELLOW(-1078001504, 0.8f, 0.8f, 0.8f),
        LIME(1810956448, 0.9f, 0.9f, 0.9f),
        PINK(-247040608, 0.9f, 0.9f, 0.9f),
        GRAY(1397969824, 0.5f, 0.5f, 0.5f),
        LIGHT_GRAY(-1819044960, 0.6f, 0.6f, 0.6f),
        CYAN(8882080, 0.8f, 0.8f, 0.8f),
        PURPLE(1577107616, 0.8f, 0.8f, 0.8f),
        BLUE(320061600, 0.8f, 0.8f, 0.8f),
        BROWN(1327956128, 0.5f, 0.5f, 0.5f),
        GREEN(143065248, 0.7f, 0.7f, 0.7f),
        RED(-1576073568, 0.8f, 0.8f, 0.8f),
        BLACK(522133408, 0.4f, 0.4f, 0.4f);

        public final int blockGlowRgba;
        public final int itemGlowRgba;
        public final int bloomRgba;

        private LightColours(int rgba, float glowBrightness, float itemGlowBrightness, float bloomBrightness) {
            this.blockGlowRgba = LightColours.scaleBrightness(rgba, glowBrightness);
            this.itemGlowRgba = LightColours.scaleBrightness(rgba, itemGlowBrightness);
            this.bloomRgba = LightColours.scaleBrightness(rgba, bloomBrightness);
        }

        public int rgbaByContext(HaloContext context) {
            return switch (context) {
                default -> throw new IncompatibleClassChangeError();
                case HaloContext.ITEM_GLOW -> this.itemGlowRgba;
                case HaloContext.LEVEL_GLOW -> this.blockGlowRgba;
                case HaloContext.BLOOM -> this.bloomRgba;
            };
        }

        private static int scaleBrightness(int baseRgba, float brightness) {
            int r = baseRgba >> 24 & 0xFF;
            int g = baseRgba >> 16 & 0xFF;
            int b = baseRgba >> 8 & 0xFF;
            int a = baseRgba & 0xFF;
            float[] hsb = new float[3];
            Color.RGBtoHSB(r, g, b, hsb);
            return Color.HSBtoRGB(hsb[0], hsb[1], brightness) << 8 | a;
        }

        public static LightColours byIndex(int index) {
            return LightColours.values()[index];
        }
    }
}

