/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IBlockEventTile {
    public Level getBlockLevel();

    public BlockPos getBlockPosition();

    default public void onBlockPlaced(@Nullable LivingEntity player, ItemStack item) {
    }

    default public void onBlockStateReplaced(BlockState newState) {
    }

    default public void onBlockRemoved() {
    }

    default public BlockState storeBlockState(BlockState defaultState) {
        return defaultState;
    }

    default public void tick() {
    }

    default public VoxelShape getOutlineShape() {
        return VoxelShapeCache.getShape((Cuboid6)Cuboid6.full);
    }

    default public VoxelShape getCollisionShape() {
        return this.getOutlineShape();
    }

    default public VoxelShape getCullingShape() {
        return this.getOutlineShape();
    }

    default public VoxelShape getRayTraceShape() {
        return this.getOutlineShape();
    }

    default public float getExplosionResistance(Entity exploder, Explosion explosion) {
        return 0.0f;
    }

    default public float getPlayerRelativeBlockHardness(Player player) {
        return 0.033333335f;
    }

    default public int getLightValue() {
        return 0;
    }

    default public boolean isFireSource(int side) {
        return false;
    }

    default public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    default public void onBlockClicked(Player player) {
    }

    default public void onEntityCollision(Entity entity) {
    }

    default public void onEntityWalk(Entity entity) {
    }

    default public void onNeighborBlockChanged(BlockPos neighborPos) {
    }

    default public void onNeighborTileChanged(BlockPos neighborPos) {
    }

    default public boolean getWeakChanges() {
        return false;
    }

    default public boolean canRedstoneConnect(int side) {
        return false;
    }

    default public int getStrongPower(int side) {
        return 0;
    }

    default public int getWeakPower(int side) {
        return 0;
    }

    public void saveToNBT(CompoundTag var1);

    public void loadFromNBT(CompoundTag var1);

    public void writeDesc(MCDataOutput var1);

    public void readDesc(MCDataInput var1);
}

