/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.lib;

import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class InventoryLib {
    public static void injectItemStack(Container inventory, ItemStack stack, boolean reverse) {
        InventoryLib.injectItemStack(inventory, stack, 0, inventory.m_6643_(), reverse);
    }

    public static void injectItemStack(Container inventory, ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        InventoryLib.injectItemStack(inventory, stack, startIndex, endIndex, reverse, true);
        if (!stack.m_41619_()) {
            InventoryLib.injectItemStack(inventory, stack, startIndex, endIndex, reverse, false);
        }
    }

    public static boolean injectAllItemStacks(Container inventory, NonNullList<ItemStack> stacks, boolean reverse) {
        return InventoryLib.injectAllItemStacks(inventory, stacks, 0, inventory.m_6643_(), reverse);
    }

    public static boolean injectAllItemStacks(Container inventory, NonNullList<ItemStack> stacks, int startIndex, int endIndex, boolean reverse) {
        boolean allInjected = true;
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            InventoryLib.injectItemStack(inventory, stack, startIndex, endIndex, reverse);
            if (stack.m_41619_()) {
                stacks.set(i, (Object)ItemStack.f_41583_);
                continue;
            }
            allInjected = false;
        }
        return allInjected;
    }

    private static void injectItemStack(Container inventory, ItemStack stack, int startIndex, int endIndex, boolean reverse, boolean mergeOnly) {
        for (int i = startIndex; i < endIndex; ++i) {
            int index = reverse ? endIndex - i - 1 : i;
            ItemStack stackInSlot = inventory.m_8020_(index);
            if (stackInSlot.m_41619_()) {
                if (mergeOnly) continue;
                inventory.m_6836_(index, stack.m_41777_());
                stack.m_41764_(0);
            } else if (InventoryLib.areStackable(stack, stackInSlot)) {
                int maxStackSize = Math.min(inventory.m_6893_(), stackInSlot.m_41741_());
                int spaceRemaining = Math.max(0, maxStackSize - stackInSlot.m_41613_());
                int amountToInsert = Math.min(spaceRemaining, stack.m_41613_());
                stack.m_41774_(amountToInsert);
                stackInSlot.m_41769_(amountToInsert);
                inventory.m_6836_(index, stackInSlot);
            }
            if (stack.m_41619_()) break;
        }
    }

    public static boolean areStackable(ItemStack a, ItemStack b) {
        return ItemStack.m_41746_((ItemStack)a, (ItemStack)b) && ItemStack.m_41658_((ItemStack)a, (ItemStack)b) && a.m_41741_() > 1 && b.m_41741_() > 1;
    }

    public static void addPlayerInventory(Inventory playerInventory, int x, int y, Consumer<Slot> slotConsumer) {
        InventoryLib.addInventory((Container)playerInventory, 9, x, y, 9, 3, slotConsumer);
        InventoryLib.addInventory((Container)playerInventory, 0, x, y + 58, 9, 1, slotConsumer);
    }

    public static void addPlayerInventory(Inventory playerInventory, int x, int y, SlotFactory slotFactory, Consumer<Slot> slotConsumer) {
        InventoryLib.addInventory((Container)playerInventory, 9, x, y, 9, 3, slotFactory, slotConsumer);
        InventoryLib.addInventory((Container)playerInventory, 0, x, y + 58, 9, 1, slotFactory, slotConsumer);
    }

    public static void addInventory(Container inventory, int i, int x, int y, int columns, int rows, Consumer<Slot> slotConsumer) {
        InventoryLib.addInventory(inventory, i, x, y, columns, rows, Slot::new, slotConsumer);
    }

    public static void addInventory(Container inventory, int i, int x, int y, int columns, int rows, SlotFactory slotFactory, Consumer<Slot> slotConsumer) {
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                slotConsumer.accept(slotFactory.createSlot(inventory, i + (r * columns + c), x + c * 18, y + r * 18));
            }
        }
    }

    @FunctionalInterface
    public static interface SlotFactory {
        public Slot createSlot(Container var1, int var2, int var3, int var4);
    }
}

