/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.lib.Size;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUIRootNode;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RedUIContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements RedUIRootNode {
    private final List<RedUINode> children = new LinkedList<RedUINode>();
    private Rect frame;
    private Rect screenFrame;
    private double zPos = 0.0;
    private long lastClickTime = 0L;

    public RedUIContainerScreen(int backgroundWidth, int backgroundHeight, T container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.f_97726_ = backgroundWidth;
        this.f_97727_ = backgroundHeight;
        this.frame = new Rect(Point.ZERO, new Size(backgroundWidth, backgroundHeight));
        this.screenFrame = Rect.ZERO;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.screenFrame = new Rect(Point.ZERO, new Size(this.f_96543_, this.f_96544_));
        Point framePos = new Point((this.screenFrame.width() - this.frame.width()) / 2, (this.screenFrame.height() - this.frame.height()) / 2);
        this.frame = new Rect(framePos, this.frame.size);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialFrame) {
        Point mousePoint = new Point(mouseX, mouseY);
        this.operateOnSubtree(mousePoint, (n, p, c) -> {
            n.frameUpdate(p, partialFrame);
            return false;
        }, false);
        RenderSystem.m_69482_();
        int x = this.getScreenFrame().x();
        int y = this.getScreenFrame().y();
        this.m_93179_(stack, x, y, x + this.getScreenFrame().width(), y + this.getScreenFrame().height(), -1072689136, -804253680);
        this.drawBackForSubtree(stack, new Point(mouseX, mouseY), partialFrame);
        super.m_6305_(stack, mouseX, mouseY, partialFrame);
        this.m_7025_(stack, mouseX, mouseY);
        this.drawFrontForSubtree(stack, new Point(mouseX, mouseY), partialFrame);
    }

    protected void m_7286_(PoseStack stack, float partialFrame, int mouseX, int mouseY) {
    }

    @Override
    public void renderTooltipScreenSpace(PoseStack stack, Point screenSpacePoint, List<Component> tooltip) {
        this.m_96597_(stack, tooltip, screenSpacePoint.x, screenSpacePoint.y);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.getSubTree(n -> true).forEach(RedUINode::update);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double x, double y, int glfwMouseButton) {
        this.lastClickTime = System.currentTimeMillis();
        super.m_6375_(x, y, glfwMouseButton);
        boolean consumed = false;
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseClicked(p, glfwMouseButton, c), consumed);
    }

    public boolean m_6348_(double x, double y, int button) {
        boolean consumed = super.m_6348_(x, y, button);
        long timeSinceLastClick = System.currentTimeMillis() - this.lastClickTime;
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseReleased(p, button, timeSinceLastClick, c), consumed);
    }

    public boolean m_7979_(double x, double y, int button, double dragX, double dragY) {
        boolean consumed = super.m_7979_(x, y, button, dragX, dragY);
        long timeSinceLastClick = System.currentTimeMillis() - this.lastClickTime;
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseDragged(p, button, timeSinceLastClick, c), consumed);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        boolean consumed = super.m_6050_(x, y, scroll);
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseScrolled(p, scroll, c), consumed);
    }

    public boolean m_5534_(char keyPressed, int glfwFlags) {
        boolean consumed = super.m_5534_(keyPressed, glfwFlags);
        return this.operateOnZOrderedSubtree(Point.ZERO, (n, p, c) -> n.onCharTyped(keyPressed, glfwFlags, c), consumed);
    }

    public boolean m_7933_(int glfwKeyCode, int glfwScanCode, int glfwFlags) {
        boolean consumed = super.m_7933_(glfwKeyCode, glfwScanCode, glfwFlags);
        return this.operateOnZOrderedSubtree(Point.ZERO, (n, p, c) -> n.onKeyPressed(glfwKeyCode, glfwScanCode, glfwFlags, c), consumed);
    }

    public boolean m_7920_(int glfwKeyCode, int glfwScanCode, int glfwFlags) {
        boolean consumed = super.m_7920_(glfwKeyCode, glfwScanCode, glfwFlags);
        return this.operateOnZOrderedSubtree(Point.ZERO, (n, p, c) -> n.onKeyReleased(glfwKeyCode, glfwScanCode, glfwFlags, c), consumed);
    }

    @Override
    public Rect getScreenFrame() {
        return this.screenFrame;
    }

    @Override
    public List<RedUINode> getOurChildren() {
        return this.children;
    }

    @Override
    public Rect getFrame() {
        return this.frame;
    }

    @Override
    public Point getPosition() {
        return this.frame.origin;
    }

    @Override
    public double getZPosition() {
        return this.zPos;
    }

    @Override
    public void setZPosition(double zPosition) {
        this.zPos = zPosition;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public ItemRenderer getItemRenderer() {
        return this.f_96542_;
    }

    @Override
    public Font getFontRenderer() {
        return this.f_96547_;
    }
}

