/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import codechicken.lib.colour.EnumColour;
import com.mojang.blaze3d.vertex.PoseStack;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.lib.Size;
import mrtjp.projectred.redui.AbstractGuiNode;
import net.minecraft.client.gui.GuiComponent;

public abstract class ScrollBarNode
extends AbstractGuiNode {
    private final ScrollAxis axis;
    private Point initialClickPosition = Point.ZERO;
    private Rect initialSliderFrame = new Rect(0, 0, 0, 0);
    private boolean isDraggingSlider = false;
    private Rect sliderFrame = new Rect(0, 0, 0, 0);
    private double scrollPercentage = 0.0;

    public ScrollBarNode(ScrollAxis axis) {
        this.axis = axis;
    }

    public void setSliderSize(int w, int h) {
        this.sliderFrame = new Rect(this.sliderFrame.origin, new Size(w, h));
        this.setScrollPercentage(0.0);
    }

    @Override
    public void drawBack(PoseStack stack, Point mouse, float partialFrame) {
        int x = this.getFrame().x();
        int y = this.getFrame().y();
        GuiComponent.m_168740_((PoseStack)stack, (int)x, (int)y, (int)(x + this.getFrame().width()), (int)(y + this.getFrame().height()), (int)EnumColour.BLACK.argb(127), (int)EnumColour.BLACK.argb(127), (int)0);
        this.drawSlider(stack, this.sliderFrame);
    }

    @Override
    public boolean mouseClicked(Point p, int glfwMouseButton, boolean consumed) {
        if (this.isFirstHit(p)) {
            if (this.sliderFrame.contains(p)) {
                this.isDraggingSlider = true;
                this.initialClickPosition = p;
                this.initialSliderFrame = this.sliderFrame;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(Point p, int glfwMouseButton, long timeHeld, boolean consumed) {
        if (this.isDraggingSlider) {
            this.isDraggingSlider = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(Point p, int glfwMouseButton, long timeHeld, boolean consumed) {
        if (!this.isDraggingSlider) {
            return false;
        }
        Point delta = p.subtract(this.initialClickPosition).multiply(this.axis.vec);
        Rect targetSliderFrame = new Rect(this.initialSliderFrame.origin.add(delta), this.sliderFrame.size);
        this.sliderFrame = this.getFrame().trap(targetSliderFrame);
        this.recalcScrollPercentage();
        return true;
    }

    private void recalcScrollPercentage() {
        if (this.axis == ScrollAxis.VERTICAL) {
            int minY = this.getFrame().y();
            int maxY = this.getFrame().maxY() - this.sliderFrame.height();
            int sliderY = this.sliderFrame.y();
            this.scrollPercentage = (double)(sliderY - minY) / (double)(maxY - minY);
        } else {
            int minX = this.getFrame().x();
            int maxX = this.getFrame().maxX() - this.sliderFrame.width();
            int sliderX = this.sliderFrame.x();
            this.scrollPercentage = (double)(sliderX - minX) / (double)(maxX - minX);
        }
        this.adjustContent(this.scrollPercentage);
    }

    public double getScrollPercentage() {
        return this.scrollPercentage;
    }

    public void setScrollPercentage(double percentage) {
        this.scrollPercentage = Math.min(1.0, Math.max(0.0, percentage));
        int sliderX = this.getFrame().x();
        int sliderY = this.getFrame().y();
        if (this.axis == ScrollAxis.VERTICAL) {
            int minY = this.getFrame().y();
            int maxY = this.getFrame().maxY() - this.sliderFrame.height();
            sliderY = (int)((double)minY + (double)(maxY - minY) * percentage);
        } else {
            int minX = this.getFrame().x();
            int maxX = this.getFrame().maxX() - this.sliderFrame.width();
            sliderX = (int)((double)minX + (double)(maxX - minX) * percentage);
        }
        this.sliderFrame = new Rect(new Point(sliderX, sliderY), this.sliderFrame.size);
    }

    protected abstract void drawSlider(PoseStack var1, Rect var2);

    protected abstract void adjustContent(double var1);

    public static enum ScrollAxis {
        HORIZONTAL(1, 0),
        VERTICAL(0, 1);

        public final Point vec;

        private ScrollAxis(int x, int y) {
            this.vec = new Point(x, y);
        }
    }
}

