/*
 * Decompiled with CFR 0.152.
 */
package com.newjumper.densemekanism;

import com.newjumper.densemekanism.content.DenseBlocks;
import com.newjumper.densemekanism.datagen.assets.DenseMekBlockStateProvider;
import com.newjumper.densemekanism.datagen.assets.DenseMekItemModelProvider;
import com.newjumper.densemekanism.datagen.assets.ENLanguageProvider;
import com.newjumper.densemekanism.datagen.data.DenseMekBlockTagsProvider;
import com.newjumper.densemekanism.datagen.data.DenseMekItemTagsProvider;
import com.newjumper.densemekanism.datagen.data.DenseMekLootTableProvider;
import com.newjumper.densemekanism.datagen.data.SmeltingRecipesProvider;
import com.newjumper.densemekanism.world.DenseConfiguredFeatures;
import com.newjumper.densemekanism.world.DensePlacedFeatures;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="densemekanism")
public class DenseMekanism {
    public static final String MOD_ID = "densemekanism";

    public DenseMekanism() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DenseBlocks.BLOCKS.register(eventBus);
        DenseConfiguredFeatures.CONFIGURED_FEATURES.register(eventBus);
        DensePlacedFeatures.PLACED_FEATURES.register(eventBus);
        DenseBlocks.ITEMS.register(eventBus);
        eventBus.addListener(this::generateData);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void generateData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.m_236039_(event.includeClient(), (DataProvider)new DenseMekBlockStateProvider(generator, fileHelper));
        generator.m_236039_(event.includeClient(), (DataProvider)new DenseMekItemModelProvider(generator, fileHelper));
        generator.m_236039_(event.includeClient(), (DataProvider)new ENLanguageProvider(generator));
        DenseMekBlockTagsProvider blockTags = new DenseMekBlockTagsProvider(generator, fileHelper);
        generator.m_236039_(event.includeServer(), (DataProvider)blockTags);
        generator.m_236039_(event.includeServer(), (DataProvider)new DenseMekItemTagsProvider(generator, blockTags, fileHelper));
        generator.m_236039_(event.includeServer(), (DataProvider)new DenseMekLootTableProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new SmeltingRecipesProvider(generator));
    }
}

