/*
 * Decompiled with CFR 0.152.
 */
package com.newjumper.densemekanism.datagen.data;

import com.google.common.collect.ImmutableList;
import com.newjumper.densemekanism.content.DenseBlocks;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SmeltingRecipesProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final ImmutableList<ItemLike> DENSE_FLUORITE_ORES = ImmutableList.of((Object)((ItemLike)DenseBlocks.DENSE_FLUORITE_ORE.get()), (Object)((ItemLike)DenseBlocks.DENSE_DEEPSLATE_FLUORITE_ORE.get()));
    private static final ImmutableList<ItemLike> DENSE_LEAD_ORES = ImmutableList.of((Object)((ItemLike)DenseBlocks.DENSE_LEAD_ORE.get()), (Object)((ItemLike)DenseBlocks.DENSE_DEEPSLATE_LEAD_ORE.get()));
    private static final ImmutableList<ItemLike> DENSE_OSMIUM_ORES = ImmutableList.of((Object)((ItemLike)DenseBlocks.DENSE_OSMIUM_ORE.get()), (Object)((ItemLike)DenseBlocks.DENSE_DEEPSLATE_OSMIUM_ORE.get()));
    private static final ImmutableList<ItemLike> DENSE_TIN_ORES = ImmutableList.of((Object)((ItemLike)DenseBlocks.DENSE_TIN_ORE.get()), (Object)((ItemLike)DenseBlocks.DENSE_DEEPSLATE_TIN_ORE.get()));
    private static final ImmutableList<ItemLike> DENSE_URANIUM_ORES = ImmutableList.of((Object)((ItemLike)DenseBlocks.DENSE_URANIUM_ORE.get()), (Object)((ItemLike)DenseBlocks.DENSE_DEEPSLATE_URANIUM_ORE.get()));

    public SmeltingRecipesProvider(DataGenerator gen) {
        super(gen);
    }

    protected void m_176531_(@NotNull Consumer<FinishedRecipe> consumer) {
        Item fluoriteGem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism", "fluorite_gem"));
        Item rawLead = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism", "raw_lead"));
        Item rawOsmium = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism", "raw_osmium"));
        Item rawTin = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism", "raw_tin"));
        Item rawUranium = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism", "raw_uranium"));
        this.oreSmelting((List<ItemLike>)DENSE_FLUORITE_ORES, (ItemLike)fluoriteGem, "fluorite_gem", consumer);
        this.oreSmelting((List<ItemLike>)DENSE_LEAD_ORES, (ItemLike)rawLead, "lead_ingot", consumer);
        this.oreSmelting((List<ItemLike>)DENSE_OSMIUM_ORES, (ItemLike)rawOsmium, "osmium_ingot", consumer);
        this.oreSmelting((List<ItemLike>)DENSE_TIN_ORES, (ItemLike)rawTin, "tin_ingot", consumer);
        this.oreSmelting((List<ItemLike>)DENSE_URANIUM_ORES, (ItemLike)rawUranium, "uranium_ingot", consumer);
        this.oreBlasting((List<ItemLike>)DENSE_FLUORITE_ORES, (ItemLike)fluoriteGem, "fluorite_gem", consumer);
        this.oreBlasting((List<ItemLike>)DENSE_LEAD_ORES, (ItemLike)rawLead, "lead_ingot", consumer);
        this.oreBlasting((List<ItemLike>)DENSE_OSMIUM_ORES, (ItemLike)rawOsmium, "osmium_ingot", consumer);
        this.oreBlasting((List<ItemLike>)DENSE_TIN_ORES, (ItemLike)rawTin, "tin_ingot", consumer);
        this.oreBlasting((List<ItemLike>)DENSE_URANIUM_ORES, (ItemLike)rawUranium, "uranium_ingot", consumer);
    }

    private void oreSmelting(List<ItemLike> ingredients, ItemLike result, String group, Consumer<FinishedRecipe> consumer) {
        for (ItemLike item : ingredients) {
            SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), (ItemLike)result, (float)1.6f, (int)200).m_126145_(group).m_126132_(SmeltingRecipesProvider.m_176602_((ItemLike)item), (CriterionTriggerInstance)SmeltingRecipesProvider.m_125977_((ItemLike)item)).m_126140_(consumer, new ResourceLocation("densemekanism", SmeltingRecipesProvider.m_176632_((ItemLike)result) + "_from_smelting_" + SmeltingRecipesProvider.m_176632_((ItemLike)item)));
        }
    }

    private void oreBlasting(List<ItemLike> ingredients, ItemLike result, String group, Consumer<FinishedRecipe> consumer) {
        for (ItemLike item : ingredients) {
            SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), (ItemLike)result, (float)1.6f, (int)100).m_126145_(group).m_126132_(SmeltingRecipesProvider.m_176602_((ItemLike)item), (CriterionTriggerInstance)SmeltingRecipesProvider.m_125977_((ItemLike)item)).m_126140_(consumer, new ResourceLocation("densemekanism", SmeltingRecipesProvider.m_176632_((ItemLike)result) + "_from_blasting_" + SmeltingRecipesProvider.m_176632_((ItemLike)item)));
        }
    }
}

