/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid.base;

import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.impl.fluid.PlatformBlockFluidHandler;
import earth.terrarium.botarium.impl.fluid.PlatformFluidItemHandler;
import earth.terrarium.botarium.util.Serializable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Clearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public interface FluidContainer
extends Serializable,
Clearable {
    @Nullable
    public static FluidContainer of(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        PlatformBlockFluidHandler platformBlockFluidHandler = PlatformBlockFluidHandler.of(level, pos, state, entity, direction);
        return platformBlockFluidHandler == null ? FluidApi.getAPIFluidContainer(level, pos, state, entity, direction) : platformBlockFluidHandler;
    }

    @Nullable
    public static FluidContainer of(Level level, BlockPos pos, @Nullable Direction direction) {
        return FluidContainer.of(level, pos, null, null, direction);
    }

    @Nullable
    public static FluidContainer of(BlockEntity block, @Nullable Direction direction) {
        return FluidContainer.of(block.m_58904_(), block.m_58899_(), block.m_58900_(), block, direction);
    }

    @Nullable
    public static ItemFluidContainer of(ItemStackHolder holder) {
        return PlatformFluidItemHandler.of(holder);
    }

    public static boolean holdsFluid(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    public static boolean holdsFluid(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        return entity != null && entity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).isPresent() || FluidApi.getAPIFluidContainer(level, pos, state, entity, direction) != null;
    }

    public static boolean holdsFluid(Level level, BlockPos pos, @Nullable Direction direction) {
        return FluidContainer.holdsFluid(level, pos, null, null, direction);
    }

    public static boolean holdsFluid(BlockEntity block, @Nullable Direction direction) {
        return FluidContainer.holdsFluid(block.m_58904_(), block.m_58899_(), block.m_58900_(), block, direction);
    }

    public long insertFluid(FluidHolder var1, boolean var2);

    default public long internalInsert(FluidHolder fluids, boolean simulate) {
        return this.insertFluid(fluids, simulate);
    }

    public FluidHolder extractFluid(FluidHolder var1, boolean var2);

    default public FluidHolder internalExtract(FluidHolder fluid, boolean simulate) {
        return this.extractFluid(fluid, simulate);
    }

    public void setFluid(int var1, FluidHolder var2);

    public List<FluidHolder> getFluids();

    public int getSize();

    public boolean isEmpty();

    public FluidContainer copy();

    public long getTankCapacity(int var1);

    public void fromContainer(FluidContainer var1);

    public long extractFromSlot(FluidHolder var1, FluidHolder var2, Runnable var3);

    default public long extractFromSlot(int slot, FluidHolder toExtract, boolean simulate) {
        return this.extractFromSlot(this.getFluids().get(slot), toExtract, () -> {});
    }

    public boolean allowsInsertion();

    public boolean allowsExtraction();

    default public boolean isFluidValid(int slot, FluidHolder fluidHolder) {
        return this.allowsInsertion();
    }

    public FluidSnapshot createSnapshot();

    default public void readSnapshot(FluidSnapshot snapshot) {
        snapshot.loadSnapshot(this);
    }

    default public FluidHolder getFirstFluid() {
        return this.getFluids().get(0);
    }
}

