/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.impl.fluid;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidSnapshot;
import earth.terrarium.botarium.impl.fluid.ForgeFluidHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public record PlatformBlockFluidHandler(IFluidHandler handler) implements FluidContainer
{
    @Nullable
    public static PlatformBlockFluidHandler of(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        BlockEntity provider;
        BlockEntity blockEntity = provider = entity != null ? entity : level.m_7702_(pos);
        if (provider == null) {
            return null;
        }
        LazyOptional handler = provider.getCapability(ForgeCapabilities.FLUID_HANDLER, direction);
        return handler.map(PlatformBlockFluidHandler::new).orElse(null);
    }

    @Override
    public long insertFluid(FluidHolder fluid, boolean simulate) {
        return this.handler.fill(new ForgeFluidHolder(fluid).getFluidStack(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        return new ForgeFluidHolder(this.handler.drain(new ForgeFluidHolder(fluid).getFluidStack(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
    }

    @Override
    public void setFluid(int slot, FluidHolder fluid) {
        FluidStack fluidInTank = this.handler.getFluidInTank(slot);
        this.handler.drain(fluidInTank, IFluidHandler.FluidAction.EXECUTE);
        this.handler.fill(new ForgeFluidHolder(fluid).getFluidStack(), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public List<FluidHolder> getFluids() {
        ArrayList<FluidHolder> fluids = new ArrayList<FluidHolder>();
        for (int i = 0; i < this.handler.getTanks(); ++i) {
            fluids.add(new ForgeFluidHolder(this.handler.getFluidInTank(i)));
        }
        return fluids;
    }

    @Override
    public int getSize() {
        return this.handler.getTanks();
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.handler.getTanks(); ++i) {
            if (this.handler.getFluidInTank(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public FluidContainer copy() {
        throw new UnsupportedOperationException("Copying is not supported on PlatformFluidContainers");
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.handler.getTankCapacity(tank);
    }

    @Override
    public void fromContainer(FluidContainer container) {
        throw new UnsupportedOperationException("Copying is not supported on PlatformFluidContainers");
    }

    @Override
    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        return 0L;
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return new SimpleFluidSnapshot(this);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
    }

    @Override
    public boolean isFluidValid(int slot, FluidHolder fluidHolder) {
        return this.handler.isFluidValid(slot, new ForgeFluidHolder(fluidHolder).getFluidStack());
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        return nbt;
    }

    public void m_6211_() {
        for (int i = 0; i < this.handler.getTanks(); ++i) {
            this.handler.drain(this.handler.getFluidInTank(i), IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

