/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils;

import com.teamresourceful.resourcefullib.common.lib.Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class FileUtils {
    private static String failedToLoadSourceError(Path path) {
        return String.format("Failed to load source: %s!", path);
    }

    private static boolean isZip(@NotNull Path f) {
        return f.toString().endsWith(".zip");
    }

    private static boolean isJson(@NotNull Path f) {
        return f.toString().endsWith(".json");
    }

    public static void streamFilesAndParse(Path source, BiConsumer<Reader, String> parser) {
        FileUtils.streamFiles(source, FileUtils::isJson, path -> FileUtils.readFileAndParse(path, parser));
        FileUtils.streamFiles(source, FileUtils::isZip, path -> FileUtils.openZipAndParse(path, parser));
    }

    private static void streamFiles(Path source, Predicate<Path> filter, Consumer<Path> handler) {
        try (Stream<Path> pathStream = Files.walk(source, new FileVisitOption[0]);){
            pathStream.filter(filter).forEach(handler);
        }
        catch (IOException e) {
            Constants.LOGGER.error(FileUtils.failedToLoadSourceError(source), (Throwable)e);
        }
    }

    private static void openZipAndParse(Path source, BiConsumer<Reader, String> parser) {
        try (FileSystem zip = FileSystems.newFileSystem(source);){
            zip.getRootDirectories().forEach(rootPath -> FileUtils.streamFiles(rootPath, FileUtils::isJson, path -> FileUtils.readFileAndParse(path, parser)));
        }
        catch (IOException e) {
            Constants.LOGGER.error(FileUtils.failedToLoadSourceError(source), (Throwable)e);
        }
    }

    private static void readFileAndParse(@NotNull Path filePath, @NotNull BiConsumer<Reader, String> parser) {
        try (BufferedReader r = Files.newBufferedReader(filePath);){
            String name = filePath.getFileName().toString();
            name = name.substring(0, name.indexOf(46));
            parser.accept(r, name);
        }
        catch (IOException e) {
            Constants.LOGGER.error("Could not read file: {}", (Object)filePath, (Object)e);
        }
    }

    public static void copyDefaultFiles(String dataPath, Path targetPath, Path modRoot) {
        if (Files.isRegularFile(modRoot, new LinkOption[0])) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(modRoot);){
                FileUtils.streamFiles(fileSystem.getPath(dataPath, new String[0]), FileUtils::isJson, path -> FileUtils.copyFile(targetPath, path));
            }
            catch (IOException e) {
                Constants.LOGGER.error(FileUtils.failedToLoadSourceError(modRoot), (Throwable)e);
            }
        } else if (Files.isDirectory(modRoot, new LinkOption[0])) {
            FileUtils.streamFiles(Paths.get(modRoot.toString(), dataPath), FileUtils::isJson, path1 -> FileUtils.copyFile(targetPath, path1));
        }
    }

    private static void copyFile(@NotNull Path targetPath, Path source) {
        try {
            Files.copy(source, Paths.get(targetPath.toString(), source.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Constants.LOGGER.error("Could not copy file: {}, Target: {}", (Object)source, (Object)targetPath);
        }
    }

    public static void setupDevResources(@NotNull String devPath, @NotNull BiConsumer<Reader, String> parser, Path modRoot) {
        if (Files.isRegularFile(modRoot, new LinkOption[0])) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(modRoot);){
                FileUtils.streamFilesAndParse(fileSystem.getPath(devPath, new String[0]), parser);
            }
            catch (IOException e) {
                Constants.LOGGER.error(FileUtils.failedToLoadSourceError(modRoot), (Throwable)e);
            }
        } else if (Files.isDirectory(modRoot, new LinkOption[0])) {
            FileUtils.streamFilesAndParse(Paths.get(modRoot.toString(), devPath), parser);
        }
    }
}

