/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlacedBlockTrigger;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.CountRequirementsStrategy;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.json.predicate.tool.HasMaterialPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.HasModifierPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.StatInRangePredicate;
import slimeknights.tconstruct.library.json.predicate.tool.StatInSetPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolStackItemPredicate;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.item.armor.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.shared.inventory.BlockContainerOpenedTrigger;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.SearedLanternBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.item.TankItem;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.FoliageType;

public class AdvancementsProvider
extends GenericDataProvider {
    protected Consumer<Advancement> advancementConsumer;
    protected BiConsumer<ResourceLocation, ConditionalAdvancement.Builder> conditionalConsumer;

    public AdvancementsProvider(DataGenerator generatorIn) {
        super(generatorIn, PackType.SERVER_DATA, "advancements");
    }

    public String m_6055_() {
        return "Tinkers' Construct Advancements";
    }

    protected void generate() {
        Advancement materialsAndYou = this.builder((ItemLike)TinkerCommons.materialsAndYou, this.resource("tools/materials_and_you"), this.resource("textures/gui/advancement_background.png"), FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_book", this.hasItem((ItemLike)TinkerCommons.materialsAndYou)));
        Advancement partBuilder = this.builder((ItemLike)TinkerTables.partBuilder, this.resource("tools/part_builder"), materialsAndYou, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_block", this.hasItem((ItemLike)TinkerTables.partBuilder)));
        this.builder(((ToolPartItem)TinkerToolParts.pickHead.get()).withMaterialForDisplay(MaterialIds.wood), this.resource("tools/make_part"), partBuilder, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_part", this.hasTag(TinkerTags.Items.TOOL_PARTS)));
        Advancement tinkerStation = this.builder((ItemLike)TinkerTables.tinkerStation, this.resource("tools/tinker_station"), partBuilder, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_block", this.hasItem((ItemLike)TinkerTables.tinkerStation)));
        Advancement tinkerTool = this.builder(((ModifiableItem)TinkerTools.pickaxe.get()).getRenderTool(), this.resource("tools/tinker_tool"), tinkerStation, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_tool", this.hasTag(TinkerTags.Items.MULTIPART_TOOL)));
        Advancement harvestLevel = this.builder((ItemLike)Items.f_42418_, this.resource("tools/netherite_tier"), tinkerTool, FrameType.GOAL, (Advancement.Builder builder) -> builder.m_138386_("harvest_level", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ToolStackItemPredicate.ofTool(new StatInSetPredicate<Tiers>(ToolStats.HARVEST_TIER, Tiers.NETHERITE))})));
        this.builder((ItemLike)Items.f_42793_, this.resource("tools/perfect_aim"), tinkerTool, FrameType.GOAL, (Advancement.Builder builder) -> builder.m_138386_("accuracy", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ToolStackItemPredicate.ofTool(StatInRangePredicate.match(ToolStats.ACCURACY, 1.0f))})));
        this.builder((ItemLike)Items.f_42681_, this.resource("tools/one_shot"), tinkerTool, FrameType.GOAL, (Advancement.Builder builder) -> builder.m_138386_("damage", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ToolStackItemPredicate.ofTool(StatInRangePredicate.min(ToolStats.ATTACK_DAMAGE, 20.0f))})));
        this.builder((ItemLike)TinkerMaterials.manyullyn.getIngot(), this.resource("tools/material_master"), harvestLevel, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Consumer<MaterialId> with = id -> builder.m_138386_(id.m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ToolStackItemPredicate.ofContext(new HasMaterialPredicate((MaterialVariantId)id))}));
            with.accept(MaterialIds.wood);
            with.accept(MaterialIds.flint);
            with.accept(MaterialIds.rock);
            with.accept(MaterialIds.bone);
            with.accept(MaterialIds.necroticBone);
            with.accept(MaterialIds.leather);
            with.accept(MaterialIds.string);
            with.accept(MaterialIds.vine);
            with.accept(MaterialIds.bamboo);
            with.accept(MaterialIds.chorus);
            with.accept(MaterialIds.iron);
            with.accept(MaterialIds.searedStone);
            with.accept(MaterialIds.scorchedStone);
            with.accept(MaterialIds.copper);
            with.accept(MaterialIds.slimewood);
            with.accept(MaterialIds.skyslimeVine);
            with.accept(MaterialIds.whitestone);
            with.accept(MaterialIds.roseGold);
            with.accept(MaterialIds.slimesteel);
            with.accept(MaterialIds.nahuatl);
            with.accept(MaterialIds.amethystBronze);
            with.accept(MaterialIds.pigIron);
            with.accept(MaterialIds.cobalt);
            with.accept(MaterialIds.darkthread);
            with.accept(MaterialIds.manyullyn);
            with.accept(MaterialIds.hepatizon);
            with.accept(MaterialIds.queensSlime);
            with.accept(MaterialIds.blazingBone);
            with.accept(MaterialIds.blazewood);
            with.accept(MaterialIds.ancientHide);
            with.accept(MaterialIds.enderslimeVine);
        });
        this.builder(((ModifiableArmorItem)TinkerTools.travelersGear.get((Enum)ArmorSlotType.HELMET)).getRenderTool(), this.resource("tools/travelers_gear"), tinkerStation, FrameType.TASK, (Advancement.Builder builder) -> TinkerTools.travelersGear.forEach((type, armor) -> builder.m_138386_("crafted_" + type.m_7912_(), this.hasItem((ItemLike)armor))));
        this.builder(((ModifiableItem)TinkerTools.pickaxe.get()).getRenderTool(), this.resource("tools/tool_smith"), tinkerTool, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Consumer<Item> with = item -> builder.m_138386_(Registry.f_122827_.m_7981_(item).m_135815_(), this.hasItem((ItemLike)item));
            with.accept((Item)TinkerTools.pickaxe.get());
            with.accept((Item)TinkerTools.mattock.get());
            with.accept((Item)TinkerTools.pickadze.get());
            with.accept((Item)TinkerTools.handAxe.get());
            with.accept((Item)TinkerTools.kama.get());
            with.accept((Item)TinkerTools.dagger.get());
            with.accept((Item)TinkerTools.sword.get());
        });
        Advancement modified = this.builder((ItemLike)Items.f_42451_, this.resource("tools/modified"), tinkerTool, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_tool", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ToolStackItemPredicate.ofContext(ToolContextPredicate.HAS_UPGRADES)})));
        this.builder((ItemLike)Items.f_42614_, this.resource("tools/upgrade_slots"), modified, FrameType.CHALLENGE, (Advancement.Builder builder) -> builder.m_138386_("has_modified", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ToolStackItemPredicate.ofContext(ToolContextPredicate.and(HasModifierPredicate.hasUpgrade(ModifierIds.writable, 1), HasModifierPredicate.hasUpgrade(ModifierIds.recapitated, 1), HasModifierPredicate.hasUpgrade(ModifierIds.harmonious, 1), HasModifierPredicate.hasUpgrade(ModifierIds.resurrected, 1), HasModifierPredicate.hasUpgrade(ModifierIds.gilded, 1)))})));
        Advancement punySmelting = this.builder((ItemLike)TinkerCommons.punySmelting, this.resource("smeltery/puny_smelting"), materialsAndYou, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_book", this.hasItem((ItemLike)TinkerCommons.punySmelting)));
        Advancement melter = this.builder((ItemLike)TinkerSmeltery.searedMelter, this.resource("smeltery/melter"), punySmelting, FrameType.TASK, (Advancement.Builder builder) -> {
            Consumer<Block> with = block -> builder.m_138386_(Registry.f_122824_.m_7981_(block).m_135815_(), (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)block));
            with.accept((Block)TinkerSmeltery.searedMelter.get());
            with.accept((Block)TinkerSmeltery.searedTable.get());
            with.accept((Block)TinkerSmeltery.searedBasin.get());
            with.accept((Block)TinkerSmeltery.searedFaucet.get());
            with.accept((Block)TinkerSmeltery.searedHeater.get());
            TinkerSmeltery.searedTank.forEach(with);
            builder.m_138360_((RequirementsStrategy)new CountRequirementsStrategy(1, 1, 1, 1, 1 + SearedTankBlock.TankType.values().length));
        });
        this.builder((ItemLike)TinkerSmeltery.toolHandleCast.getSand(), this.resource("smeltery/sand_casting"), melter, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_cast", this.hasTag(TinkerTags.Items.BLANK_SINGLE_USE_CASTS)));
        Advancement goldCasting = this.builder((ItemLike)TinkerSmeltery.pickHeadCast, this.resource("smeltery/gold_casting"), melter, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_cast", this.hasTag(TinkerTags.Items.GOLD_CASTS)));
        this.builder((ItemLike)TinkerSmeltery.hammerHeadCast, this.resource("smeltery/cast_collector"), goldCasting, FrameType.GOAL, (Advancement.Builder builder) -> {
            Consumer<CastItemObject> with = cast -> builder.m_138386_(cast.getName().m_135815_(), this.hasItem(cast.get()));
            with.accept(TinkerSmeltery.ingotCast);
            with.accept(TinkerSmeltery.nuggetCast);
            with.accept(TinkerSmeltery.gemCast);
            with.accept(TinkerSmeltery.rodCast);
            with.accept(TinkerSmeltery.repairKitCast);
            with.accept(TinkerSmeltery.pickHeadCast);
            with.accept(TinkerSmeltery.smallAxeHeadCast);
            with.accept(TinkerSmeltery.smallBladeCast);
            with.accept(TinkerSmeltery.hammerHeadCast);
            with.accept(TinkerSmeltery.broadBladeCast);
            with.accept(TinkerSmeltery.broadAxeHeadCast);
            with.accept(TinkerSmeltery.toolBindingCast);
            with.accept(TinkerSmeltery.roundPlateCast);
            with.accept(TinkerSmeltery.largePlateCast);
            with.accept(TinkerSmeltery.toolHandleCast);
            with.accept(TinkerSmeltery.toughHandleCast);
            with.accept(TinkerSmeltery.bowLimbCast);
            with.accept(TinkerSmeltery.bowGripCast);
            with.accept(TinkerSmeltery.helmetPlatingCast);
            with.accept(TinkerSmeltery.chestplatePlatingCast);
            with.accept(TinkerSmeltery.leggingsPlatingCast);
            with.accept(TinkerSmeltery.bootsPlatingCast);
            with.accept(TinkerSmeltery.mailleCast);
        });
        Advancement mightySmelting = this.builder((ItemLike)TinkerCommons.mightySmelting, this.resource("smeltery/mighty_smelting"), melter, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_book", this.hasItem((ItemLike)TinkerCommons.mightySmelting)));
        Advancement smeltery = this.builder((ItemLike)TinkerSmeltery.smelteryController, this.resource("smeltery/structure"), mightySmelting, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("open_smeltery", (CriterionTriggerInstance)BlockContainerOpenedTrigger.Instance.container((BlockEntityType)TinkerSmeltery.smeltery.get())));
        Advancement anvil = this.builder((ItemLike)TinkerTables.tinkersAnvil, this.resource("smeltery/tinkers_anvil"), smeltery, FrameType.GOAL, (Advancement.Builder builder) -> {
            builder.m_138386_("crafted_overworld", this.hasItem((ItemLike)TinkerTables.tinkersAnvil));
            builder.m_138386_("crafted_nether", this.hasItem((ItemLike)TinkerTables.scorchedAnvil));
            builder.m_138360_(RequirementsStrategy.f_15979_);
        });
        this.builder(((ModifiableItem)TinkerTools.veinHammer.get()).getRenderTool(), this.resource("smeltery/tool_forge"), anvil, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Consumer<Item> with = item -> builder.m_138386_(Registry.f_122827_.m_7981_(item).m_135815_(), this.hasItem((ItemLike)item));
            with.accept((Item)TinkerTools.sledgeHammer.get());
            with.accept((Item)TinkerTools.veinHammer.get());
            with.accept((Item)TinkerTools.excavator.get());
            with.accept((Item)TinkerTools.broadAxe.get());
            with.accept((Item)TinkerTools.scythe.get());
            with.accept((Item)TinkerTools.cleaver.get());
            with.accept((Item)TinkerTools.longbow.get());
        });
        this.builder((ItemLike)TinkerModifiers.silkyCloth, this.resource("smeltery/abilities"), anvil, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Consumer<ModifierId> with = modifier -> builder.m_138386_(modifier.m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ToolStackItemPredicate.ofContext(HasModifierPredicate.hasUpgrade(modifier, 1))}));
            Consumer<LazyModifier> withL = modifier -> with.accept(modifier.getId());
            with.accept(ModifierIds.gilded);
            with.accept(ModifierIds.luck);
            withL.accept(TinkerModifiers.unbreakable);
            with.accept(ModifierIds.protection);
            with.accept(ModifierIds.aquaAffinity);
            withL.accept(TinkerModifiers.slurping);
            withL.accept(TinkerModifiers.zoom);
            withL.accept(TinkerModifiers.ambidextrous);
            with.accept(ModifierIds.reach);
            with.accept(ModifierIds.strength);
            with.accept(ModifierIds.pockets);
            with.accept(ModifierIds.toolBelt);
            withL.accept(TinkerModifiers.wetting);
            withL.accept(TinkerModifiers.bouncy);
            withL.accept(TinkerModifiers.doubleJump);
            withL.accept(TinkerModifiers.flamewake);
            with.accept(ModifierIds.frostWalker);
            with.accept(ModifierIds.longFall);
            with.accept(ModifierIds.pathMaker);
            with.accept(ModifierIds.plowing);
            with.accept(ModifierIds.snowdrift);
            with.accept(ModifierIds.boundless);
            withL.accept(TinkerModifiers.reflecting);
            withL.accept(TinkerModifiers.autosmelt);
            withL.accept(TinkerModifiers.exchanging);
            withL.accept(TinkerModifiers.expanded);
            withL.accept(TinkerModifiers.silky);
            withL.accept(TinkerModifiers.bucketing);
            withL.accept(TinkerModifiers.firestarter);
            withL.accept(TinkerModifiers.glowing);
            with.accept(ModifierIds.pathing);
            with.accept(ModifierIds.stripping);
            with.accept(ModifierIds.tilling);
            withL.accept(TinkerModifiers.bonking);
            withL.accept(TinkerModifiers.flinging);
            withL.accept(TinkerModifiers.springing);
            withL.accept(TinkerModifiers.warping);
            withL.accept(TinkerModifiers.dualWielding);
            withL.accept(TinkerModifiers.melting);
            withL.accept(TinkerModifiers.blocking);
            withL.accept(TinkerModifiers.parrying);
            withL.accept(TinkerModifiers.crystalshot);
            withL.accept(TinkerModifiers.multishot);
            withL.accept(TinkerModifiers.bulkQuiver);
            withL.accept(TinkerModifiers.trickQuiver);
            withL.accept(TinkerModifiers.spitting);
            withL.accept(TinkerModifiers.spilling);
            withL.accept(TinkerModifiers.splashing);
            withL.accept(TinkerModifiers.bursting);
        });
        Advancement fantasticFoundry = this.builder((ItemLike)TinkerCommons.fantasticFoundry, this.resource("foundry/fantastic_foundry"), materialsAndYou, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_book", this.hasItem((ItemLike)TinkerCommons.fantasticFoundry)));
        this.builder((ItemLike)TinkerCommons.encyclopedia, this.resource("foundry/encyclopedia"), fantasticFoundry, FrameType.GOAL, (Advancement.Builder builder) -> builder.m_138386_("crafted_book", this.hasItem((ItemLike)TinkerCommons.encyclopedia)));
        Advancement alloyer = this.builder((ItemLike)TinkerSmeltery.scorchedAlloyer, this.resource("foundry/alloyer"), fantasticFoundry, FrameType.TASK, (Advancement.Builder builder) -> {
            Consumer<Block> with = block -> builder.m_138386_(Registry.f_122824_.m_7981_(block).m_135815_(), (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)block));
            with.accept((Block)TinkerSmeltery.scorchedAlloyer.get());
            with.accept((Block)TinkerSmeltery.scorchedFaucet.get());
            with.accept((Block)TinkerSmeltery.scorchedTable.get());
            with.accept((Block)TinkerSmeltery.scorchedBasin.get());
            for (SearedTankBlock.TankType type : SearedTankBlock.TankType.values()) {
                with.accept((Block)TinkerSmeltery.scorchedTank.get((Enum)type));
            }
            builder.m_138360_((RequirementsStrategy)new CountRequirementsStrategy(1, 1, 1, 1, 2, 2));
        });
        Advancement foundry = this.builder((ItemLike)TinkerSmeltery.foundryController, this.resource("foundry/structure"), alloyer, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("open_foundry", (CriterionTriggerInstance)BlockContainerOpenedTrigger.Instance.container((BlockEntityType)TinkerSmeltery.foundry.get())));
        Advancement blazingBlood = this.builder(TankItem.setTank(new ItemStack((ItemLike)TinkerSmeltery.scorchedTank.get((Enum)SearedTankBlock.TankType.FUEL_GAUGE)), AdvancementsProvider.getTankWith(TinkerFluids.blazingBlood.get(), SearedTankBlock.TankType.FUEL_GAUGE.getCapacity())), this.resource("foundry/blaze"), foundry, FrameType.GOAL, (Advancement.Builder builder) -> {
            Consumer<SearedTankBlock> with = block -> {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("tank", (Tag)AdvancementsProvider.getTankWith(TinkerFluids.blazingBlood.get(), block.getCapacity()).writeToNBT(new CompoundTag()));
                builder.m_138386_(Registry.f_122824_.m_7981_(block).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{block}).m_45075_(nbt).m_45077_()}));
                builder.m_138360_(RequirementsStrategy.f_15979_);
            };
            TinkerSmeltery.searedTank.forEach(with);
            TinkerSmeltery.scorchedTank.forEach(with);
        });
        this.builder(((ModifiableArmorItem)TinkerTools.plateArmor.get((Enum)ArmorSlotType.CHESTPLATE)).getRenderTool(), this.resource("foundry/plate_armor"), blazingBlood, FrameType.GOAL, (Advancement.Builder builder) -> TinkerTools.plateArmor.forEach((type, armor) -> builder.m_138386_("crafted_" + type.m_7912_(), this.hasItem((ItemLike)armor))));
        this.builder(TankItem.setTank(new ItemStack(TinkerSmeltery.scorchedLantern), AdvancementsProvider.getTankWith(TinkerFluids.moltenManyullyn.get(), ((SearedLanternBlock)TinkerSmeltery.scorchedLantern.get()).getCapacity())), this.resource("foundry/manyullyn_lanterns"), foundry, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Consumer<SearedLanternBlock> with = block -> {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("tank", (Tag)AdvancementsProvider.getTankWith(TinkerFluids.moltenManyullyn.get(), block.getCapacity()).writeToNBT(new CompoundTag()));
                builder.m_138386_(Registry.f_122824_.m_7981_(block).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(null, Collections.singleton(block.m_5456_()), MinMaxBounds.Ints.m_55386_((int)64), MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, new NbtPredicate(nbt))}));
                builder.m_138360_(RequirementsStrategy.f_15979_);
            };
            with.accept((SearedLanternBlock)TinkerSmeltery.searedLantern.get());
            with.accept((SearedLanternBlock)TinkerSmeltery.scorchedLantern.get());
        });
        Advancement tinkersGadgetry = this.builder((ItemLike)TinkerCommons.tinkersGadgetry, this.resource("world/tinkers_gadgetry"), materialsAndYou, FrameType.TASK, (Advancement.Builder builder) -> builder.m_138386_("crafted_book", this.hasItem((ItemLike)TinkerCommons.tinkersGadgetry)));
        this.builder((ItemLike)TinkerWorld.slimeSapling.get((Enum)FoliageType.EARTH), this.resource("world/earth_island"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.m_138386_("found_island", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_220589_(Objects.requireNonNull(TinkerStructures.earthSlimeIsland)))));
        this.builder((ItemLike)TinkerWorld.slimeSapling.get((Enum)FoliageType.SKY), this.resource("world/sky_island"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.m_138386_("found_island", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_220589_(Objects.requireNonNull(TinkerStructures.skySlimeIsland)))));
        this.builder((ItemLike)TinkerWorld.slimeSapling.get((Enum)FoliageType.BLOOD), this.resource("world/blood_island"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.m_138386_("found_island", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_220589_(Objects.requireNonNull(TinkerStructures.bloodIsland)))));
        Advancement enderslimeIsland = this.builder((ItemLike)TinkerWorld.slimeSapling.get((Enum)FoliageType.ENDER), this.resource("world/ender_island"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.m_138386_("found_island", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_220589_(Objects.requireNonNull(TinkerStructures.endSlimeIsland)))));
        this.builder((ItemLike)Items.f_42461_, this.resource("world/clay_island"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.m_138386_("found_island", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_220589_(Objects.requireNonNull(TinkerStructures.clayIsland)))));
        Advancement slimes = this.builder((ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.ICHOR), this.resource("world/slime_collector"), tinkersGadgetry, FrameType.TASK, (Advancement.Builder builder) -> {
            for (SlimeType type : SlimeType.values()) {
                builder.m_138386_(type.m_7912_(), this.hasTag(type.getSlimeballTag()));
            }
            builder.m_138386_("magma_cream", this.hasItem((ItemLike)Items.f_42542_));
        });
        this.builder((ItemLike)TinkerGadgets.piggyBackpack, this.resource("world/piggybackpack"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.m_138386_("used_pack", (CriterionTriggerInstance)PlayerInteractTrigger.TriggerInstance.m_61517_((EntityPredicate.Composite)EntityPredicate.Composite.f_36667_, (ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TinkerGadgets.piggyBackpack}), (EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20510_).m_36662_()))));
        Advancement slimesuit = this.builder(((ModifiableArmorItem)TinkerTools.slimesuit.get((Enum)ArmorSlotType.CHESTPLATE)).getRenderTool(), this.resource("world/slimesuit"), enderslimeIsland, FrameType.GOAL, (Advancement.Builder builder) -> TinkerTools.slimesuit.forEach((type, armor) -> builder.m_138386_("crafted_" + type.m_7912_(), this.hasItem((ItemLike)armor))));
        this.builder(new MaterialIdNBT(Collections.singletonList(MaterialIds.glass)).updateStack(new ItemStack((ItemLike)TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET))), this.resource("world/slimeskull"), slimesuit, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Item helmet = (Item)TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET);
            Consumer<MaterialId> with = mat -> builder.m_138386_(mat.m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ToolStackItemPredicate.ofContext(ToolContextPredicate.and(ToolContextPredicate.set(helmet), new HasMaterialPredicate((MaterialVariantId)mat, 0)))}));
            with.accept(MaterialIds.glass);
            with.accept(MaterialIds.bone);
            with.accept(MaterialIds.necroticBone);
            with.accept(MaterialIds.rottenFlesh);
            with.accept(MaterialIds.enderPearl);
            with.accept(MaterialIds.venombone);
            with.accept(MaterialIds.string);
            with.accept(MaterialIds.darkthread);
            with.accept(MaterialIds.iron);
            with.accept(MaterialIds.copper);
            with.accept(MaterialIds.blazingBone);
            with.accept(MaterialIds.gold);
            with.accept(MaterialIds.roseGold);
            with.accept(MaterialIds.pigIron);
        });
        this.hiddenBuilder(this.resource("internal/starting_book"), ConfigEnabledCondition.SPAWN_WITH_BOOK, builder -> {
            builder.m_138386_("tick", (CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(CriteriaTriggers.f_10589_.m_7295_(), EntityPredicate.Composite.f_36667_));
            builder.m_138354_(AdvancementRewards.Builder.m_144822_((ResourceLocation)TConstruct.getResource("gameplay/starting_book")));
        });
    }

    private static FluidTank getTankWith(Fluid fluid, int capacity) {
        FluidTank tank = new FluidTank(capacity);
        tank.fill(new FluidStack(fluid, capacity), IFluidHandler.FluidAction.EXECUTE);
        return tank;
    }

    private CriterionTriggerInstance hasTag(TagKey<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_()});
    }

    private CriterionTriggerInstance hasItem(ItemLike item) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_()});
    }

    public void m_213708_(CachedOutput cache) {
        HashSet set = Sets.newHashSet();
        this.advancementConsumer = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            this.saveJson(cache, advancement.m_138327_(), advancement.m_138313_().m_138400_());
        };
        this.conditionalConsumer = (id, advancement) -> {
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate advancement " + id);
            }
            this.saveJson(cache, (ResourceLocation)id, advancement.write());
        };
        this.generate();
    }

    protected ResourceLocation resource(String name) {
        return TConstruct.getResource(name);
    }

    protected Advancement builder(ItemLike display, ResourceLocation name, Advancement parent, FrameType frame, Consumer<Advancement.Builder> consumer) {
        return this.builder(new ItemStack(display), name, parent, frame, consumer);
    }

    protected Advancement builder(ItemStack display, ResourceLocation name, Advancement parent, FrameType frame, Consumer<Advancement.Builder> consumer) {
        return this.builder(display, name, (ResourceLocation)null, frame, (Advancement.Builder builder) -> {
            builder.m_138398_(parent);
            consumer.accept((Advancement.Builder)builder);
        });
    }

    protected Advancement builder(ItemLike display, ResourceLocation name, @Nullable ResourceLocation background, FrameType frame, Consumer<Advancement.Builder> consumer) {
        return this.builder(new ItemStack(display), name, background, frame, consumer);
    }

    private static String makeTranslationKey(ResourceLocation advancement) {
        return "advancements." + advancement.m_135827_() + "." + advancement.m_135815_().replace('/', '.');
    }

    protected Advancement builder(ItemStack display, ResourceLocation name, @Nullable ResourceLocation background, FrameType frame, Consumer<Advancement.Builder> consumer) {
        Advancement.Builder builder = Advancement.Builder.m_138353_().m_138362_(display, (Component)Component.m_237115_((String)(AdvancementsProvider.makeTranslationKey(name) + ".title")), (Component)Component.m_237115_((String)(AdvancementsProvider.makeTranslationKey(name) + ".description")), background, frame, true, frame != FrameType.TASK, false);
        consumer.accept(builder);
        return builder.m_138389_(this.advancementConsumer, name.toString());
    }

    protected void hiddenBuilder(ResourceLocation name, ICondition condition, Consumer<Advancement.Builder> consumer) {
        Advancement.Builder builder = Advancement.Builder.m_138353_();
        consumer.accept(builder);
        ConditionalAdvancement.Builder conditionalBuilder = new ConditionalAdvancement.Builder();
        conditionalBuilder.addCondition(condition);
        conditionalBuilder.addAdvancement(builder);
        conditionalBuilder.write();
        this.conditionalConsumer.accept(name, conditionalBuilder);
    }
}

