/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public abstract class AbstractPartSpriteProvider {
    private final List<PartSpriteInfo> sprites = new ArrayList<PartSpriteInfo>();
    private final List<ToolSpriteBuilder> toolSprites = new ArrayList<ToolSpriteBuilder>();
    private boolean added = false;
    private final String modID;

    public abstract String getName();

    protected abstract void addAllSpites();

    protected void addTexture(ResourceLocation sprite, MaterialStatsId requiredStats, boolean allowAnimated) {
        this.sprites.add(new PartSpriteInfo(sprite, requiredStats, allowAnimated));
    }

    protected void addTexture(ResourceLocation sprite, MaterialStatsId requiredStats) {
        this.addTexture(sprite, requiredStats, true);
    }

    protected void addTexture(String name, MaterialStatsId requiredStats, boolean allowAnimated) {
        this.addTexture(new ResourceLocation(this.modID, name), requiredStats, allowAnimated);
    }

    protected void addTexture(String name, MaterialStatsId requiredStats) {
        this.addTexture(new ResourceLocation(this.modID, name), requiredStats);
    }

    protected void addSprite(String name, MaterialStatsId requiredStats) {
        this.addTexture(new ResourceLocation(this.modID, "item/tool/" + name), requiredStats);
    }

    protected void addPart(String name, MaterialStatsId requiredStats) {
        this.addSprite("parts/" + name, requiredStats);
    }

    protected void addHead(String name) {
        this.addPart(name, HeadMaterialStats.ID);
    }

    protected void addHandle(String name) {
        this.addPart(name, HandleMaterialStats.ID);
    }

    protected void addBinding(String name) {
        this.addPart(name, StatlessMaterialStats.BINDING.getIdentifier());
    }

    protected void addLimb(String name) {
        this.addPart(name, LimbMaterialStats.ID);
    }

    protected void addBowstring(String name) {
        this.addPart(name, StatlessMaterialStats.BOWSTRING.getIdentifier());
    }

    protected ToolSpriteBuilder buildTool(ResourceLocation name) {
        ToolSpriteBuilder builder = new ToolSpriteBuilder(name);
        this.toolSprites.add(builder);
        return builder;
    }

    protected ToolSpriteBuilder buildTool(String name) {
        return this.buildTool(new ResourceLocation(this.modID, name));
    }

    private void ensureSpritesAdded() {
        if (!this.added) {
            this.addAllSpites();
            this.toolSprites.forEach(ToolSpriteBuilder::build);
            this.toolSprites.clear();
            this.added = true;
        }
    }

    public List<PartSpriteInfo> getSprites() {
        this.ensureSpritesAdded();
        return this.sprites;
    }

    public void cleanCache() {
        this.sprites.clear();
        this.added = false;
    }

    public AbstractPartSpriteProvider(String modID) {
        this.modID = modID;
    }

    public static class PartSpriteInfo {
        public static final RecordLoadable<PartSpriteInfo> LOADABLE = RecordLoadable.create((RecordField)Loadables.RESOURCE_LOCATION.requiredField("path", i -> i.path), (RecordField)MaterialStatsId.PARSER.requiredField("stat_type", i -> i.statType), (RecordField)BooleanLoadable.INSTANCE.defaultField("allow_animated", (Object)true, false, i -> i.allowAnimated), PartSpriteInfo::new);
        public static final Loadable<List<PartSpriteInfo>> LIST_LOADABLE = LOADABLE.list(1);
        private final ResourceLocation path;
        private final MaterialStatsId statType;
        private final boolean allowAnimated;
        private final transient Map<String, NativeImage> sprites = new HashMap<String, NativeImage>();

        @Nullable
        public NativeImage getTexture(AbstractSpriteReader spriteReader, String name) {
            if (this.sprites.containsKey(name)) {
                return this.sprites.get(name);
            }
            ResourceLocation fallbackPath = this.path;
            if (!name.isEmpty()) {
                fallbackPath = new ResourceLocation(this.path.m_135827_(), this.path.m_135815_() + "_" + name);
            }
            NativeImage image = spriteReader.readIfExists(fallbackPath);
            this.sprites.put(name, image);
            return image;
        }

        public PartSpriteInfo(ResourceLocation path, MaterialStatsId statType, boolean allowAnimated) {
            this.path = path;
            this.statType = statType;
            this.allowAnimated = allowAnimated;
        }

        public ResourceLocation getPath() {
            return this.path;
        }

        public MaterialStatsId getStatType() {
            return this.statType;
        }

        public boolean isAllowAnimated() {
            return this.allowAnimated;
        }
    }

    protected class ToolSpriteBuilder {
        private final ResourceLocation name;
        private final Map<String, MaterialStatsId> parts = new LinkedHashMap<String, MaterialStatsId>();
        private boolean hasLarge = false;

        public ToolSpriteBuilder addPart(String name, MaterialStatsId statTypes) {
            this.parts.put(name, statTypes);
            return this;
        }

        public ToolSpriteBuilder addBreakablePart(String name, MaterialStatsId statTypes) {
            this.addPart(name, statTypes);
            this.addPart(name + "_broken", statTypes);
            return this;
        }

        public ToolSpriteBuilder addHead(String name) {
            return this.addPart(name, HeadMaterialStats.ID);
        }

        public ToolSpriteBuilder addBreakableHead(String name) {
            return this.addBreakablePart(name, HeadMaterialStats.ID);
        }

        public ToolSpriteBuilder addHandle(String name) {
            return this.addPart(name, HandleMaterialStats.ID);
        }

        public ToolSpriteBuilder addBinding(String name) {
            return this.addPart(name, StatlessMaterialStats.BINDING.getIdentifier());
        }

        public ToolSpriteBuilder addLimb(String name) {
            return this.addPart(name, LimbMaterialStats.ID);
        }

        public ToolSpriteBuilder addGrip(String name) {
            return this.addPart(name, GripMaterialStats.ID);
        }

        public ToolSpriteBuilder addBowstring(String name) {
            return this.addPart(name, StatlessMaterialStats.BOWSTRING.getIdentifier());
        }

        public ToolSpriteBuilder addBreakableBowstring(String name) {
            return this.addBreakablePart(name, StatlessMaterialStats.BOWSTRING.getIdentifier());
        }

        public ToolSpriteBuilder withLarge() {
            this.hasLarge = true;
            return this;
        }

        private void addParts(String path) {
            for (Map.Entry<String, MaterialStatsId> entry : this.parts.entrySet()) {
                AbstractPartSpriteProvider.this.addTexture(new ResourceLocation(this.name.m_135827_(), "item/tool/" + path + "/" + entry.getKey()), entry.getValue());
            }
        }

        private void build() {
            this.addParts(this.name.m_135815_());
            if (this.hasLarge) {
                this.addParts(this.name.m_135815_() + "/large");
            }
        }

        private ToolSpriteBuilder(ResourceLocation name) {
            this.name = name;
        }
    }
}

