/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.client.data.GenericTextureGenerator;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.RecolorSpriteTransformer;

public class MaterialPaletteDebugGenerator
extends GenericTextureGenerator {
    private final String name;
    private final AbstractMaterialSpriteProvider[] materialProviders;

    public MaterialPaletteDebugGenerator(DataGenerator generator, String name, AbstractMaterialSpriteProvider ... materialProviders) {
        super(generator, "debug/material_palettes");
        this.name = name;
        this.materialProviders = materialProviders;
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        for (AbstractMaterialSpriteProvider materialProvider : this.materialProviders) {
            for (Map.Entry<ResourceLocation, AbstractMaterialSpriteProvider.MaterialSpriteInfo> entry : materialProvider.getMaterials().entrySet()) {
                ISpriteTransformer iSpriteTransformer = entry.getValue().getTransformer();
                if (!(iSpriteTransformer instanceof RecolorSpriteTransformer)) continue;
                RecolorSpriteTransformer recolor = (RecolorSpriteTransformer)iSpriteTransformer;
                IColorMapping colorMapping = recolor.getColorMapping();
                NativeImage palette = new NativeImage(256, 16, true);
                for (int grey = 0; grey < 256; ++grey) {
                    int color = colorMapping.mapColor(grey | grey << 8 | grey << 16 | 0xFF000000);
                    for (int height = 0; height < 16; ++height) {
                        palette.m_84988_(grey, height, color);
                    }
                }
                this.saveImage(cache, entry.getKey(), palette);
                palette.close();
            }
        }
    }

    public String m_6055_() {
        return this.name + " Material Palette Debug";
    }
}

