/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.spritetransformer;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToSpriteTransformer;

public class AnimatedGreyToSpriteTransformer
extends GreyToSpriteTransformer {
    private final ResourceLocation metaPath;
    private final int frames;
    private JsonObject meta;

    protected AnimatedGreyToSpriteTransformer(List<GreyToSpriteTransformer.SpriteMapping> sprites, ResourceLocation metaPath, int frames) {
        super(sprites);
        this.metaPath = metaPath;
        this.frames = frames;
    }

    private int getNewColor(int color, int x, int y, int frame) {
        if (NativeImage.m_84983_((int)color) == 0) {
            return 0;
        }
        int grey = GreyToColorMapping.getGrey(color);
        int newColor = this.getSpriteRange(grey).getColor(x, y, frame, grey);
        return GreyToColorMapping.scaleColor(color, newColor, grey);
    }

    @Override
    public void transform(NativeImage image, boolean allowAnimated) {
        int width = image.m_84982_();
        int frames = allowAnimated ? this.frames : 1;
        int height = image.m_85084_() / frames;
        for (int f = frames - 1; f >= 0; --f) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.m_84988_(x, y + f * height, this.getNewColor(image.m_84985_(x, y), x, y, f));
                }
            }
        }
    }

    @Override
    public NativeImage transformCopy(NativeImage image, boolean allowAnimated) {
        int frames = allowAnimated ? this.frames : 1;
        NativeImage copy = new NativeImage(image.m_84982_(), image.m_85084_() * frames, true);
        copy.m_85054_(image);
        this.transform(copy, allowAnimated);
        return copy;
    }

    @Override
    @Nullable
    public JsonObject animationMeta(NativeImage image) {
        if (this.meta == null) {
            if (READER == null) {
                throw new IllegalStateException("Cannot get image for a sprite without reader");
            }
            try {
                this.meta = READER.readMetadata(this.metaPath);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to load required image", ex);
            }
        }
        return this.meta;
    }
}

