/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.model.FluidContainerModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.NormalModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class FluidModifierModel
extends NormalModifierModel {
    private static final ResourceLocation BAKE_LOCATION = TConstruct.getResource("dynamic_fluid_model");
    private static final Vector3f ORIGIN = new Vector3f(-0.5f, -0.5f, -0.5f);
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = new Unbaked(ToolTankHelper.TANK_HELPER);
    protected final ToolTankHelper helper;
    protected final Material[] fluidTextures;

    protected FluidModifierModel(ToolTankHelper helper, @Nullable Material smallTexture, @Nullable Material largeTexture, Material[] fluidTextures) {
        super(smallTexture, largeTexture);
        this.helper = helper;
        this.fluidTextures = fluidTextures;
    }

    public FluidModifierModel(ToolTankHelper helper, @Nullable Material smallTexture, @Nullable Material largeTexture, @Nullable Material smallFull, @Nullable Material largeFull) {
        this(helper, smallTexture, largeTexture, new Material[]{smallFull, largeFull});
    }

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        FluidStack fluid = this.helper.getFluid(tool);
        if (!fluid.isEmpty()) {
            return new FluidModifierCacheKey(entry.getModifier(), fluid.getFluid());
        }
        return entry.getId();
    }

    @Nullable
    protected Material getTemplate(IToolStackView tool, ModifierEntry entry, FluidStack fluid, boolean isLarge) {
        return this.fluidTextures[isLarge ? 1 : 0];
    }

    @Override
    public void addQuads(IToolStackView tool, ModifierEntry entry, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, Consumer<Collection<BakedQuad>> quadConsumer, @Nullable ItemLayerPixels pixels) {
        Material template;
        FluidStack fluid = this.helper.getFluid(tool);
        if (!fluid.isEmpty() && (template = this.getTemplate(tool, entry, fluid, isLarge)) != null) {
            int color;
            IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
            TextureAtlasSprite fluidSprite = spriteGetter.apply(new Material(InventoryMenu.f_39692_, attributes.getStillTexture(fluid)));
            List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)-1, (TextureAtlasSprite)spriteGetter.apply(template));
            List fluidQuads = UnbakedGeometryHelper.bakeElements((List)unbaked, mat -> fluidSprite, (ModelState)new SimpleModelState(transforms.applyOrigin(ORIGIN).m_121096_(FluidContainerModel.FLUID_TRANSFORM), false), (ResourceLocation)BAKE_LOCATION);
            int luminosity = fluid.getFluid().getFluidType().getLightLevel(fluid);
            if (luminosity > 0) {
                QuadTransformers.settingEmissivity((int)luminosity).processInPlace(fluidQuads);
            }
            if ((color = attributes.getTintColor(fluid)) != -1) {
                ColoredBlockModel.applyColorQuadTransformer((int)color).processInPlace(fluidQuads);
            }
            quadConsumer.accept(fluidQuads);
        }
        super.addQuads(tool, entry, spriteGetter, transforms, isLarge, startTintIndex, quadConsumer, pixels);
    }

    private record FluidModifierCacheKey(Modifier modifier, Fluid fluid) {
    }

    public record Unbaked(ToolTankHelper helper) implements IUnbakedModifierModel
    {
        @Override
        @Nullable
        public IBakedModifierModel forTool(Function<String, Material> smallGetter, Function<String, Material> largeGetter) {
            Material smallTexture = smallGetter.apply("");
            Material largeTexture = largeGetter.apply("");
            if (smallTexture != null || largeTexture != null) {
                return new FluidModifierModel(this.helper, smallTexture, largeTexture, smallGetter.apply("_full"), largeGetter.apply("_full"));
            }
            return null;
        }
    }
}

