/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.event.IModBusEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.listener.IEarlySafeManagerReloadListener;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.DynamicTextureLoader;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public class ModifierModelManager
implements IEarlySafeManagerReloadListener {
    private static final Logger log = LogManager.getLogger(ModifierModelManager.class);
    private static final String VISIBLE_MODIFIERS = "tinkering/modifiers.json";
    public static final ModifierModelManager INSTANCE = new ModifierModelManager();
    private static boolean eventFired = false;
    private static final Map<ResourceLocation, IUnbakedModifierModel> MODIFIER_MODEL_OPTIONS = new HashMap<ResourceLocation, IUnbakedModifierModel>();
    private static Map<ModifierId, IUnbakedModifierModel> modifierModels = Collections.emptyMap();

    public static void init(RegisterClientReloadListenersEvent manager) {
        manager.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    @Nullable
    private static IUnbakedModifierModel getLoader(String key, String name) {
        ResourceLocation loader = ResourceLocation.m_135820_((String)name);
        if (loader == null) {
            log.error("Skipping modifier " + key + " as " + name + " is an invalid loader name");
        } else {
            IUnbakedModifierModel model = MODIFIER_MODEL_OPTIONS.get(loader);
            if (model == null) {
                log.error("Skipping modifier " + key + " as the loader " + loader + " is unknown");
            } else {
                return model;
            }
        }
        return null;
    }

    public void onReloadSafe(ResourceManager manager) {
        if (!eventFired) {
            ModLoader.get().postEvent((Event)new ModifierModelRegistrationEvent());
            eventFired = true;
        }
        HashMap<ModifierId, IUnbakedModifierModel> models = new HashMap<ModifierId, IUnbakedModifierModel>();
        List jsonFiles = JsonHelper.getFileInAllDomainsAndPacks((ResourceManager)manager, (String)VISIBLE_MODIFIERS, null);
        for (int i = jsonFiles.size() - 1; i >= 0; --i) {
            JsonObject json = (JsonObject)jsonFiles.get(i);
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                ModifierId name = ModifierId.tryParse(key);
                if (name == null) {
                    log.error("Skipping invalid modifier key " + key + " as it is not a valid resource location");
                    continue;
                }
                if (models.containsKey((Object)name)) continue;
                JsonElement element = (JsonElement)entry.getValue();
                if (element.isJsonNull()) {
                    models.remove((Object)name);
                    continue;
                }
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    IUnbakedModifierModel model = ModifierModelManager.getLoader(key, GsonHelper.m_13906_((JsonObject)object, (String)"type"));
                    if (model == null) continue;
                    models.put(name, model.configure(object));
                    continue;
                }
                if (element.isJsonPrimitive()) {
                    IUnbakedModifierModel model = ModifierModelManager.getLoader(key, element.getAsString());
                    if (model == null) continue;
                    models.put(name, model);
                    continue;
                }
                log.error("Skipping key " + key + " as the value is not a string or object");
            }
        }
        modifierModels = models;
    }

    private static Material getModifierTexture(ResourceLocation modifierRoot, ResourceLocation modifierId, String suffix) {
        return ForgeHooksClient.getBlockMaterial((ResourceLocation)new ResourceLocation(modifierRoot.m_135827_(), modifierRoot.m_135815_() + modifierId.m_135827_() + "_" + modifierId.m_135815_() + suffix));
    }

    @Nullable
    private static Material getTexture(List<ResourceLocation> modifierRoots, Predicate<Material> textureAdder, ResourceLocation modifier, String suffix) {
        if (modifierModels.isEmpty()) {
            return null;
        }
        for (ResourceLocation root : modifierRoots) {
            Material texture = ModifierModelManager.getModifierTexture(root, modifier, suffix);
            if (!textureAdder.test(texture)) continue;
            return texture;
        }
        return null;
    }

    public static Map<ModifierId, IBakedModifierModel> getModelsForTool(List<ResourceLocation> smallModifierRoots, List<ResourceLocation> largeModifierRoots, Collection<Material> textures) {
        if (modifierModels.isEmpty() || smallModifierRoots.isEmpty() && largeModifierRoots.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder modelMap = ImmutableMap.builder();
        Predicate<Material> textureAdder = DynamicTextureLoader.getTextureAdder(textures, (Boolean)Config.CLIENT.logMissingModifierTextures.get());
        for (Map.Entry<ModifierId, IUnbakedModifierModel> entry : modifierModels.entrySet()) {
            ModifierId id = entry.getKey();
            IUnbakedModifierModel model = entry.getValue();
            IBakedModifierModel toolModel = model.forTool(name -> ModifierModelManager.getTexture(smallModifierRoots, textureAdder, id, name), name -> ModifierModelManager.getTexture(largeModifierRoots, textureAdder, id, name));
            if (toolModel == null) continue;
            modelMap.put((Object)id, (Object)toolModel);
        }
        return modelMap.build();
    }

    private ModifierModelManager() {
    }

    public static class ModifierModelRegistrationEvent
    extends Event
    implements IModBusEvent {
        public void registerModel(ResourceLocation name, IUnbakedModifierModel model) {
            MODIFIER_MODEL_OPTIONS.put(name, model);
        }
    }
}

