/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CompoundIngredient;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.data.recipe.ICastCreationHelper;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.partbuilder.PartRecipeBuilder;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipeBuilder;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public interface IToolRecipeHelper
extends ICastCreationHelper {
    default public void toolBuilding(Consumer<FinishedRecipe> consumer, IModifiable tool, String folder) {
        ToolBuildingRecipeBuilder.toolBuildingRecipe(tool).save(consumer, this.prefix(this.id(tool), folder));
    }

    default public void toolBuilding(Consumer<FinishedRecipe> consumer, Supplier<? extends IModifiable> tool, String folder) {
        this.toolBuilding(consumer, tool.get(), folder);
    }

    default public void partCasting(Consumer<FinishedRecipe> consumer, IMaterialItem part, CastItemObject cast, int cost, String partFolder, String castFolder) {
        String name = this.id(part).m_135815_();
        String castingFolder = partFolder + "casting/";
        MaterialCastingRecipeBuilder.tableRecipe(part).setItemCost(cost).setCast(cast.getMultiUseTag(), false).save(consumer, this.location(castingFolder + name + "_gold_cast"));
        MaterialCastingRecipeBuilder.tableRecipe(part).setItemCost(cost).setCast(cast.getSingleUseTag(), true).save(consumer, this.location(castingFolder + name + "_sand_cast"));
        CompositeCastingRecipeBuilder.table(part, cost).save(consumer, this.location(castingFolder + name + "_composite"));
        MaterialIngredient ingredient = MaterialIngredient.of(part);
        this.castCreation(consumer, (Ingredient)ingredient, cast, castFolder, name);
    }

    default public void uncastablePart(Consumer<FinishedRecipe> consumer, IMaterialItem part, int cost, @Nullable MaterialStatsId castingStatConflict, String partFolder) {
        ResourceLocation id = this.id(part);
        PartRecipeBuilder.partRecipe(part).setPattern(id).setPatternItem(Ingredient.m_204132_(TinkerTags.Items.DEFAULT_PATTERNS)).setCost(cost).save(consumer, this.location(partFolder + "builder/" + id.m_135815_()));
        CompositeCastingRecipeBuilder.table(part, cost).castingStatConflict(castingStatConflict).save(consumer, this.location(partFolder + "casting/" + id.m_135815_() + "_composite"));
    }

    default public void partRecipes(Consumer<FinishedRecipe> consumer, IMaterialItem part, CastItemObject cast, int cost, String partFolder, String castFolder) {
        ResourceLocation id = this.id(part);
        PartRecipeBuilder.partRecipe(part).setPattern(id).setPatternItem(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.DEFAULT_PATTERNS), Ingredient.m_43929_((ItemLike[])new ItemLike[]{cast.get()})})).setCost(cost).save(consumer, this.location(partFolder + "builder/" + id.m_135815_()));
        this.partCasting(consumer, part, cast, cost, partFolder, castFolder);
    }

    default public void partRecipes(Consumer<FinishedRecipe> consumer, Supplier<? extends IMaterialItem> part, CastItemObject cast, int cost, String partFolder, String castFolder) {
        this.partRecipes(consumer, part.get(), cast, cost, partFolder, castFolder);
    }
}

