/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;

public interface IMaterialRegistry {
    default public MaterialId resolve(MaterialId id) {
        return id;
    }

    public IMaterial getMaterial(MaterialId var1);

    public Collection<IMaterial> getVisibleMaterials();

    public Collection<IMaterial> getAllMaterials();

    public boolean isInTag(MaterialId var1, TagKey<IMaterial> var2);

    public List<IMaterial> getTagValues(TagKey<IMaterial> var1);

    public <T extends IMaterialStats> Optional<T> getMaterialStats(MaterialId var1, MaterialStatsId var2);

    public Collection<IMaterialStats> getAllStats(MaterialId var1);

    public Loadable<MaterialStatType<?>> getStatTypeLoader();

    @Nullable
    public <T extends IMaterialStats> MaterialStatType<T> getStatType(MaterialStatsId var1);

    @Nullable
    default public <T extends IMaterialStats> T getDefaultStats(MaterialStatsId statsId) {
        MaterialStatType<T> type = this.getStatType(statsId);
        return type != null ? (T)type.getDefaultStats() : null;
    }

    @Nullable
    default public <T extends IMaterialStats> RecordLoadable<T> getStatLoadable(MaterialStatsId statsId) {
        MaterialStatType<T> type = this.getStatType(statsId);
        return type != null ? type.getLoadable() : null;
    }

    default public boolean canRepair(MaterialStatsId statsId) {
        MaterialStatType type = this.getStatType(statsId);
        return type != null && type.canRepair();
    }

    public void registerStatType(MaterialStatType<?> var1);

    default public void registerStatType(MaterialStatType<?> type, @Nullable MaterialStatsId traitFallback) {
        this.registerStatType(type);
    }

    public List<ModifierEntry> getDefaultTraits(MaterialId var1);

    public boolean hasUniqueTraits(MaterialId var1, MaterialStatsId var2);

    public List<ModifierEntry> getTraits(MaterialId var1, MaterialStatsId var2);
}

