/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid;

import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;

public abstract class FluidEffectContext {
    protected final Level level;
    @Nullable
    protected final LivingEntity entity;
    @Nullable
    protected final Player player;
    @Nullable
    protected final Projectile projectile;

    public DamageSource createDamageSource() {
        if (this.projectile != null) {
            return DamageSource.m_19340_((net.minecraft.world.entity.Entity)this.projectile, (LivingEntity)this.entity).m_19366_();
        }
        if (this.player != null) {
            return DamageSource.m_19344_((Player)this.player);
        }
        if (this.entity != null) {
            return DamageSource.m_19370_((LivingEntity)this.entity);
        }
        return new DamageSource("generic");
    }

    public Level getLevel() {
        return this.level;
    }

    @Nullable
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public Projectile getProjectile() {
        return this.projectile;
    }

    public FluidEffectContext(Level level, @Nullable LivingEntity entity, @Nullable Player player, @Nullable Projectile projectile) {
        this.level = level;
        this.entity = entity;
        this.player = player;
        this.projectile = projectile;
    }

    public static class Block
    extends FluidEffectContext {
        private final BlockHitResult hitResult;
        private BlockState state;

        public Block(Level level, @Nullable LivingEntity holder, @Nullable Player player, @Nullable Projectile projectile, BlockHitResult hitResult) {
            super(level, holder, player, projectile);
            this.hitResult = hitResult;
        }

        public Block(Level level, @Nullable LivingEntity holder, @Nullable Projectile projectile, BlockHitResult hitResult) {
            this(level, holder, ModifierUtil.asPlayer((net.minecraft.world.entity.Entity)holder), projectile, hitResult);
        }

        public Block(Level level, @Nullable Player player, @Nullable Projectile projectile, BlockHitResult hitResult) {
            this(level, (LivingEntity)player, player, projectile, hitResult);
        }

        public BlockState getBlockState() {
            if (this.state == null) {
                this.state = this.level.m_8055_(this.hitResult.m_82425_());
            }
            return this.state;
        }

        public boolean isOffsetReplaceable() {
            return this.level.m_8055_(this.hitResult.m_82425_().m_121945_(this.hitResult.m_82434_())).m_60767_().m_76336_();
        }

        public BlockHitResult getHitResult() {
            return this.hitResult;
        }
    }

    public static class Entity
    extends FluidEffectContext {
        private final net.minecraft.world.entity.Entity target;
        @Nullable
        private final LivingEntity livingTarget;

        public Entity(Level level, @Nullable LivingEntity holder, @Nullable Player player, @Nullable Projectile projectile, net.minecraft.world.entity.Entity target, @Nullable LivingEntity livingTarget) {
            super(level, holder, player, projectile);
            this.target = target;
            this.livingTarget = livingTarget;
        }

        public Entity(Level level, @Nullable LivingEntity holder, @Nullable Projectile projectile, net.minecraft.world.entity.Entity target) {
            this(level, holder, ModifierUtil.asPlayer((net.minecraft.world.entity.Entity)holder), projectile, target, ModifierUtil.asLiving(target));
        }

        public Entity(Level level, Player player, @Nullable Projectile projectile, LivingEntity target) {
            this(level, (LivingEntity)player, player, projectile, (net.minecraft.world.entity.Entity)target, target);
        }

        public net.minecraft.world.entity.Entity getTarget() {
            return this.target;
        }

        @Nullable
        public LivingEntity getLivingTarget() {
            return this.livingTarget;
        }
    }
}

