/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;

public class MaterialFluidRecipeBuilder
extends AbstractRecipeBuilder<MaterialFluidRecipeBuilder> {
    private final MaterialVariantId outputId;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int temperature = -1;
    @Nullable
    private MaterialVariantId inputId;

    public MaterialFluidRecipeBuilder setFluidAndTemp(FluidStack fluidStack) {
        this.fluid = FluidIngredient.of((FluidStack)fluidStack);
        if (this.temperature == -1) {
            this.temperature = fluidStack.getFluid().getFluidType().getTemperature(fluidStack) - 300;
        }
        return this;
    }

    public MaterialFluidRecipeBuilder setFluid(TagKey<Fluid> tagIn, int amount) {
        this.setFluid((FluidIngredient)FluidIngredient.of(tagIn, (int)amount));
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, this.outputId.getId());
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Material fluid recipes require a fluid input");
        }
        if (this.temperature < 0) {
            throw new IllegalStateException("Temperature is too low, must be at least 0");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "materials");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new MaterialFluidRecipe(id, this.fluid, this.temperature, this.inputId, this.outputId), MaterialFluidRecipe.LOADER, advancementId));
    }

    private MaterialFluidRecipeBuilder(MaterialVariantId outputId) {
        this.outputId = outputId;
    }

    public static MaterialFluidRecipeBuilder material(MaterialVariantId outputId) {
        return new MaterialFluidRecipeBuilder(outputId);
    }

    public MaterialFluidRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public MaterialFluidRecipeBuilder setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public MaterialFluidRecipeBuilder setInputId(@Nullable MaterialVariantId inputId) {
        this.inputId = inputId;
        return this;
    }
}

