/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.entitymelting;

import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.common.FluidStackLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.container.IEmptyContainer;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class EntityMeltingRecipe
implements ICustomOutputRecipe<IEmptyContainer> {
    public static final RecordLoadable<EntityMeltingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)EntityIngredient.LOADABLE.requiredField("entity", r -> r.ingredient), (RecordField)FluidStackLoadable.REQUIRED_STACK.requiredField("result", r -> r.output), (RecordField)IntLoadable.FROM_ONE.defaultField("damage", (Object)2, true, r -> r.damage), EntityMeltingRecipe::new);
    private final ResourceLocation id;
    private final EntityIngredient ingredient;
    private final FluidStack output;
    private final int damage;

    public boolean matches(EntityType<?> type) {
        return this.ingredient.test(type);
    }

    public FluidStack getOutput(LivingEntity entity) {
        return this.output.copy();
    }

    public Collection<EntityType<?>> getInputs() {
        return this.ingredient.getTypes();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.entityMeltingSerializer.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.ENTITY_MELTING.get();
    }

    @Deprecated
    public boolean matches(IEmptyContainer inv, Level worldIn) {
        return false;
    }

    public EntityMeltingRecipe(ResourceLocation id, EntityIngredient ingredient, FluidStack output, int damage) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
        this.damage = damage;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public EntityIngredient getIngredient() {
        return this.ingredient;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public int getDamage() {
        return this.damage;
    }
}

