/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRecipe
extends AbstractModifierRecipe {
    protected static final LoadableField<List<SizedIngredient>, ModifierRecipe> INPUTS_FIELD = SizedIngredient.LOADABLE.list(1).requiredField("inputs", r -> r.inputs);
    public static final RecordLoadable<ModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), INPUTS_FIELD, (RecordField)TOOLS_FIELD, (RecordField)MAX_TOOL_SIZE_FIELD, (RecordField)RESULT_FIELD, (RecordField)LEVEL_FIELD, (RecordField)SLOTS_FIELD, (RecordField)ALLOW_CRYSTAL_FIELD, (RecordField)CHECK_TRAIT_LEVEL_FIELD, ModifierRecipe::new);
    protected final List<SizedIngredient> inputs;

    public ModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierId result, IntRange level, @Nullable SlotType.SlotCount slots, boolean allowCrystal, boolean checkTraitLevel) {
        super(id, toolRequirement, maxToolSize, result, level, slots, allowCrystal, checkTraitLevel);
        this.inputs = inputs;
    }

    protected static BitSet makeBitset(ITinkerableContainer inv) {
        int inputs = inv.getInputCount();
        BitSet used = new BitSet(inputs);
        for (int i = 0; i < inputs; ++i) {
            if (!inv.getInput(i).m_41619_()) continue;
            used.set(i);
        }
        return used;
    }

    protected static int findMatch(SizedIngredient ingredient, ITinkerableContainer inv, BitSet used) {
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack;
            if (used.get(i) || !ingredient.test(stack = inv.getInput(i))) continue;
            used.set(i);
            return i;
        }
        return -1;
    }

    public static boolean checkMatch(ITinkerableContainer inv, List<SizedIngredient> inputs) {
        if (inputs.isEmpty()) {
            return false;
        }
        BitSet used = ModifierRecipe.makeBitset(inv);
        for (SizedIngredient ingredient : inputs) {
            int index = ModifierRecipe.findMatch(ingredient, inv, used);
            if (index != -1) continue;
            return false;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            if (used.get(i) || inv.getInput(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!this.result.isBound() || !this.toolRequirement.test(inv.getTinkerableStack())) {
            return false;
        }
        return this.matchesCrystal(inv) || ModifierRecipe.checkMatch(inv, this.inputs);
    }

    @Override
    public RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer inv) {
        ItemStack tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        Component commonError = this.validatePrerequisites(tool);
        if (commonError != null) {
            return RecipeResult.failure(commonError);
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        SlotType.SlotCount slots = this.getSlots();
        if (slots != null) {
            persistentData.addSlots(slots.type(), -slots.count());
        }
        tool.addModifier(this.result.getId(), 1);
        Component toolValidation = tool.tryValidate();
        if (toolValidation != null) {
            return RecipeResult.failure(toolValidation);
        }
        return RecipeResult.success(tool.createStack(Math.min(tinkerable.m_41613_(), this.shrinkToolSlotBy())));
    }

    public static void updateInputs(ITinkerableContainer.Mutable inv, List<SizedIngredient> inputs) {
        BitSet used = ModifierRecipe.makeBitset(inv);
        for (SizedIngredient ingredient : inputs) {
            int index = ModifierRecipe.findMatch(ingredient, inv, used);
            if (index != -1) {
                inv.shrinkInput(index, ingredient.getAmountNeeded());
                continue;
            }
            TConstruct.LOG.warn("Missing ingredient in modifier recipe input consume");
        }
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        if (this.matchesCrystal(inv)) {
            super.updateInputs(result, inv, isServer);
        } else {
            ModifierRecipe.updateInputs(inv, this.inputs);
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierSerializer.get();
    }

    @Override
    public int getInputCount() {
        return this.inputs.size();
    }

    @Override
    public List<ItemStack> getDisplayItems(int slot) {
        if (slot >= 0 && slot < this.inputs.size()) {
            return this.inputs.get(slot).getMatchingStacks();
        }
        return Collections.emptyList();
    }
}

