/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class OverslimeModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    private static final RecipeResult<ItemStack> AT_CAPACITY = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "overslime.at_capacity"), new Object[0]);
    public static final RecordLoadable<OverslimeModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("ingredient", r -> r.ingredient), (RecordField)IntLoadable.FROM_ONE.requiredField("restore_amount", r -> r.restoreAmount), OverslimeModifierRecipe::new);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final int restoreAmount;
    private static final ModifierEntry RESULT = new ModifierEntry(TinkerModifiers.overslime, 1);
    private List<ItemStack> toolWithoutModifier;
    private List<ItemStack> toolWithModifier = null;

    public OverslimeModifierRecipe(ResourceLocation id, Ingredient ingredient, int restoreAmount) {
        this.id = id;
        this.ingredient = ingredient;
        this.restoreAmount = restoreAmount;
        ModifierRecipeLookup.addRecipeModifier(null, TinkerModifiers.overslime);
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!inv.getTinkerableStack().m_204117_(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer inv) {
        ItemStack tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        ModifierId overslimeId = TinkerModifiers.overslime.getId();
        ModifierEntry entry = tool.getModifier(overslimeId);
        if (tool.getUpgrades().getLevel(overslimeId) == 0) {
            if (entry.getLevel() > 0 && overslime.getShield(tool) >= overslime.getShieldCapacity(tool, entry)) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
            tool.addModifier(TinkerModifiers.overslime.getId(), 1);
        } else {
            if (overslime.getShield(tool) >= overslime.getShieldCapacity(tool, entry)) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, this.restoreAmount);
        overslime.addOverslime(tool, entry, available);
        return RecipeResult.success(tool.createStack(Math.min(tinkerable.m_41613_(), this.shrinkToolSlotBy())));
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        int current = 0;
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        if (tool.getModifierLevel(overslime) != 0) {
            current = overslime.getShield(tool);
        }
        int maxNeeded = overslime.getShield(ToolStack.from(result)) - current;
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, maxNeeded, this.restoreAmount, ItemStack.f_41583_);
    }

    @Deprecated
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.overslimeSerializer.get();
    }

    @Override
    public int getInputCount() {
        return 1;
    }

    @Override
    public List<ItemStack> getDisplayItems(int slot) {
        if (slot == 0) {
            return Arrays.asList(this.ingredient.m_43908_());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ItemStack> getToolWithoutModifier() {
        if (this.toolWithoutModifier == null) {
            this.toolWithoutModifier = RegistryHelper.getTagValueStream((Registry)Registry.f_122827_, TinkerTags.Items.DURABILITY).map(MAP_TOOL_FOR_RENDERING).toList();
        }
        return this.toolWithoutModifier;
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
            List<ModifierEntry> result = List.of(RESULT);
            this.toolWithModifier = RegistryHelper.getTagValueStream((Registry)Registry.f_122827_, TinkerTags.Items.DURABILITY).map(MAP_TOOL_FOR_RENDERING).map(stack -> IDisplayModifierRecipe.withModifiers(stack, result, data -> overslime.setShield((ModDataNBT)data, this.restoreAmount))).toList();
        }
        return this.toolWithModifier;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        return RESULT;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

