/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.worktable;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSetWorktableRecipe
extends AbstractWorktableRecipe {
    private static final Component NO_MATCHES = TConstruct.makeTranslation("recipe", "modifier_set_worktable.empty");
    private static final BiFunction<CompoundTag, String, ListTag> LIST_GETTER = (tag, name) -> tag.m_128437_(name, 8);
    public static final RecordLoadable<ModifierSetWorktableRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)Loadables.RESOURCE_LOCATION.requiredField("data_key", r -> r.dataKey), (RecordField)INPUTS_FIELD, (RecordField)TOOL_FIELD, (RecordField)ModifierPredicate.LOADER.defaultField("modifier_predicate", false, r -> r.modifierPredicate), (RecordField)BooleanLoadable.INSTANCE.requiredField("add_to_set", r -> r.addToSet), (RecordField)BooleanLoadable.INSTANCE.defaultField("allow_traits", Boolean.valueOf(false), r -> r.allowTraits), ModifierSetWorktableRecipe::new);
    private final Component title;
    private final Component description;
    private final ResourceLocation dataKey;
    private final IJsonPredicate<ModifierId> modifierPredicate;
    private final Predicate<ModifierEntry> entryFilter;
    private final boolean addToSet;
    private final boolean allowTraits;
    private List<ModifierEntry> filteredModifiers = null;

    public ModifierSetWorktableRecipe(ResourceLocation id, ResourceLocation dataKey, List<SizedIngredient> inputs, Ingredient toolRequirement, IJsonPredicate<ModifierId> modifierPredicate, boolean addToSet, boolean allowTraits) {
        super(id, toolRequirement, inputs);
        this.dataKey = dataKey;
        this.addToSet = addToSet;
        String rootKey = Util.makeTranslationKey("recipe", dataKey) + (addToSet ? ".adding" : ".removing");
        this.title = Component.m_237115_((String)(rootKey + ".title"));
        this.description = Component.m_237115_((String)(rootKey + ".description"));
        this.modifierPredicate = modifierPredicate;
        this.entryFilter = entry -> modifierPredicate.matches((Object)entry.getId());
        this.allowTraits = allowTraits;
    }

    private List<ModifierEntry> getModifiers(ITinkerableContainer inv) {
        if (this.allowTraits) {
            return inv.getTinkerable().getModifiers().getModifiers();
        }
        return inv.getTinkerable().getUpgrades().getModifiers();
    }

    @Override
    public Component getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null && this.getModifiers(inv).stream().noneMatch(this.entryFilter)) {
            return NO_MATCHES;
        }
        return this.description;
    }

    @Override
    public List<ModifierEntry> getModifierOptions(@Nullable ITinkerableContainer inv) {
        if (inv == null) {
            if (this.filteredModifiers == null) {
                this.filteredModifiers = ModifierRecipeLookup.getRecipeModifierList().stream().filter(this.entryFilter).toList();
            }
            return this.filteredModifiers;
        }
        ToolStack tool = inv.getTinkerable();
        Set<ModifierId> existing = ModifierSetWorktableRecipe.getModifierSet(tool.getPersistentData(), this.dataKey);
        Predicate<ModifierEntry> applicable = entry -> existing.contains((Object)entry.getId()) != this.addToSet;
        return this.getModifiers(inv).stream().filter(this.entryFilter).filter(applicable).toList();
    }

    @Override
    public RecipeResult<ToolStack> getResult(ITinkerableContainer inv, ModifierEntry modifier) {
        ListTag tagList;
        ToolStack tool = inv.getTinkerable().copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.dataKey, 9)) {
            tagList = persistentData.get(this.dataKey, LIST_GETTER);
        } else {
            tagList = new ListTag();
            persistentData.put(this.dataKey, (Tag)tagList);
        }
        String value = modifier.getId().toString();
        boolean found = false;
        for (int i = 0; i < tagList.size(); ++i) {
            if (!tagList.m_128778_(i).equals(value)) continue;
            if (!this.addToSet) {
                tagList.remove(i);
            }
            found = true;
            break;
        }
        if (!found && this.addToSet) {
            tagList.add((Object)StringTag.m_129297_((String)value));
        }
        return RecipeResult.success(tool);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierSetWorktableSerializer.get();
    }

    public static Set<ModifierId> getModifierSet(IModDataView modData, ResourceLocation key) {
        return modData.get(key, LIST_GETTER).stream().map(tag -> ModifierId.tryParse(tag.m_7916_())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static boolean isInSet(IModDataView modData, ResourceLocation key, ModifierId modifier) {
        if (!modData.contains(key, 9)) {
            return false;
        }
        String modifierStr = modifier.toString();
        for (Tag tag : modData.get(key, LIST_GETTER)) {
            if (!modifierStr.equals(tag.m_7916_())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }
}

