/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.material;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.util.RandomSource;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.RandomMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.material.MissingMaterialsToolHook;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;

public record DefaultMaterialsModule(List<RandomMaterial> materials) implements MissingMaterialsToolHook,
ToolModule
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.MISSING_MATERIALS);
    public static final RecordLoadable<DefaultMaterialsModule> LOADER = RecordLoadable.create((RecordField)RandomMaterial.LOADER.list(1).requiredField("materials", m -> m.materials), DefaultMaterialsModule::new);

    public RecordLoadable<DefaultMaterialsModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public MaterialNBT fillMaterials(ToolDefinition definition, RandomSource random) {
        return RandomMaterial.build(ToolMaterialHook.stats(definition), this.materials, random);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<RandomMaterial> materials = ImmutableList.builder();

        private Builder() {
        }

        public Builder material(RandomMaterial material) {
            this.materials.add((Object)material);
            return this;
        }

        public Builder material(RandomMaterial ... materials) {
            for (RandomMaterial material : materials) {
                this.material(material);
            }
            return this;
        }

        public Builder material(MaterialId material) {
            return this.material(RandomMaterial.fixed(material));
        }

        public Builder firstWithStat() {
            return this.material(RandomMaterial.firstWithStat());
        }

        public DefaultMaterialsModule build() {
            ImmutableList materials = this.materials.build();
            if (materials.isEmpty()) {
                throw new IllegalArgumentException("Must have at least 1 material");
            }
            return new DefaultMaterialsModule((List<RandomMaterial>)materials);
        }
    }
}

