/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jsonthings;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.serializers.FlexItemType;
import dev.gigaherz.jsonthings.things.serializers.IItemSerializer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.armor.DummyArmorMaterial;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexModifiableBowItem;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexModifiableCrossbowItem;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexModifiableItem;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexRepairKitItem;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexToolPartItem;
import slimeknights.tconstruct.plugin.jsonthings.item.armor.FlexModifiableArmorItem;
import slimeknights.tconstruct.plugin.jsonthings.item.armor.FlexMultilayerArmorModel;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class FlexItemTypes {
    static final List<Item> TOOL_ITEMS = new ArrayList<Item>();
    static final List<Item> CROSSBOW_ITEMS = new ArrayList<Item>();
    static final List<Item> ARMOR_ITEMS = new ArrayList<Item>();

    private static <T> T add(List<? super T> list, T item) {
        list.add(item);
        return item;
    }

    public static void init() {
        FlexItemTypes.register("tool_part", data -> {
            MaterialStatsId statType = new MaterialStatsId(JsonHelper.getResourceLocation((JsonObject)data, (String)"stat_type"));
            return (props, builder) -> new FlexToolPartItem(props, statType);
        });
        FlexItemTypes.register("repair_kit", data -> {
            float repairAmount = GsonHelper.m_13915_((JsonObject)data, (String)"repair_amount");
            return (props, builder) -> new FlexRepairKitItem(props, repairAmount);
        });
        FlexItemTypes.register("tool", data -> {
            boolean breakBlocksInCreative = GsonHelper.m_13855_((JsonObject)data, (String)"break_blocks_in_creative", (boolean)true);
            return (props, builder) -> FlexItemTypes.add(TOOL_ITEMS, new FlexModifiableItem(props, ToolDefinition.create(builder.getRegistryName()), breakBlocksInCreative));
        });
        FlexItemTypes.register("bow", data -> (props, builder) -> FlexItemTypes.add(TOOL_ITEMS, new FlexModifiableBowItem(props, ToolDefinition.create(builder.getRegistryName()))));
        FlexItemTypes.register("crossbow", data -> {
            boolean allowFireworks = GsonHelper.m_13912_((JsonObject)data, (String)"allow_fireworks");
            return (props, builder) -> FlexItemTypes.add(CROSSBOW_ITEMS, new FlexModifiableCrossbowItem(props, ToolDefinition.create(builder.getRegistryName()), allowFireworks));
        });
        FlexItemTypes.register("basic_armor", data -> {
            ResourceLocation name = JsonHelper.getResourceLocation((JsonObject)data, (String)"texture_name");
            SoundEvent sound = (SoundEvent)Loadables.SOUND_EVENT.getOrDefault(data, "equip_sound", (Object)SoundEvents.f_11675_);
            ArmorSlotType slot = (ArmorSlotType)JsonHelper.getAsEnum((JsonObject)data, (String)"slot", ArmorSlotType.class);
            return (props, builder) -> FlexItemTypes.add(ARMOR_ITEMS, new FlexModifiableArmorItem(new DummyArmorMaterial(name, sound), slot.getEquipmentSlot(), props, ToolDefinition.create(builder.getRegistryName())));
        });
        Loadable ARMOR_TEXTURES = ArmorTextureSupplier.LOADER.list(1);
        FlexItemTypes.register("multilayer_armor", data -> {
            ResourceLocation name = JsonHelper.getResourceLocation((JsonObject)data, (String)"model_name");
            SoundEvent sound = (SoundEvent)Loadables.SOUND_EVENT.getOrDefault(data, "equip_sound", (Object)SoundEvents.f_11675_);
            ArmorSlotType slot = (ArmorSlotType)JsonHelper.getAsEnum((JsonObject)data, (String)"slot", ArmorSlotType.class);
            return (props, builder) -> FlexItemTypes.add(ARMOR_ITEMS, new FlexMultilayerArmorModel(new DummyArmorMaterial(name, sound), slot.getEquipmentSlot(), props, ToolDefinition.create(builder.getRegistryName())));
        });
    }

    private static <T extends Item> void register(String name, IItemSerializer<T> factory) {
        FlexItemType.register((String)TConstruct.resourceString(name), factory);
    }
}

