/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.client;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.GeneratorPartTextureJsonGenerator;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.client.data.util.ResourceManagerSpriteReader;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoJson;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.DynamicTextureLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.shared.network.GeneratePartTexturesPacket;

public class ClientGeneratePartTexturesCommand {
    private static final Logger log = LogManager.getLogger(ClientGeneratePartTexturesCommand.class);
    private static final String SUCCESS_KEY = TConstruct.makeTranslationKey("command", "generate_part_textures.finish");
    private static final Component NO_PARTS = TConstruct.makeTranslation("command", "generate_part_textures.no_parts");
    private static final Component NO_MATERIALS = TConstruct.makeTranslation("command", "generate_part_textures.no_materials");
    private static final String PACK_NAME = "TinkersConstructGeneratedPartTextures";
    private static final String GENERATOR_PART_TEXTURES = "tinkering/generator_part_textures.json";

    protected static Component getOutputComponent(File file) {
        return Component.m_237113_((String)file.getAbsolutePath()).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
    }

    public static void generateTextures(GeneratePartTexturesPacket.Operation operation, String modId, String materialPath) {
        long time = System.nanoTime();
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        MaterialPartTextureGenerator.runCallbacks(null, manager);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        GeneratorConfiguration generatorConfig = ClientGeneratePartTexturesCommand.loadGeneratorConfig(manager);
        if (generatorConfig.sprites.isEmpty()) {
            if (player != null) {
                player.m_5661_(NO_PARTS, false);
            }
            return;
        }
        Predicate<MaterialVariantId> validMaterialId = loc -> !(!modId.isEmpty() && !modId.equals(loc.getId().m_135827_()) || !materialPath.isEmpty() && !materialPath.equals(loc.getId().m_135815_()));
        List<AbstractMaterialSpriteProvider.MaterialSpriteInfo> materialSprites = ClientGeneratePartTexturesCommand.loadMaterialRenderInfoGenerators(manager, validMaterialId);
        if (materialSprites.isEmpty()) {
            if (player != null) {
                player.m_5661_(NO_MATERIALS, false);
            }
            return;
        }
        Path path = Minecraft.m_91087_().m_91101_().toPath().resolve(PACK_NAME);
        BiConsumer<ResourceLocation, NativeImage> saver = (outputPath, image) -> ClientGeneratePartTexturesCommand.saveImage(path, outputPath, image);
        BiConsumer<ResourceLocation, JsonObject> metaSaver = (outputPath, image) -> ClientGeneratePartTexturesCommand.saveMetadata(path, outputPath, image);
        ClientGeneratePartTexturesCommand.savePackMcmeta(path);
        ResourceManagerSpriteReader spriteReader = new ResourceManagerSpriteReader(manager, "textures");
        MutableInt generated = new MutableInt(0);
        Predicate<ResourceLocation> shouldGenerate = operation == GeneratePartTexturesPacket.Operation.ALL ? exists -> {
            generated.add(1);
            return true;
        } : loc -> {
            if (!spriteReader.exists((ResourceLocation)loc)) {
                generated.add(1);
                return true;
            }
            return false;
        };
        for (AbstractMaterialSpriteProvider.MaterialSpriteInfo material : materialSprites) {
            for (AbstractPartSpriteProvider.PartSpriteInfo part : generatorConfig.sprites) {
                if (!material.supportStatType(part.getStatType()) && !generatorConfig.statOverrides.hasOverride(part.getStatType(), material.getTexture())) continue;
                MaterialPartTextureGenerator.generateSprite(spriteReader, material, part, shouldGenerate, saver, metaSaver);
            }
        }
        spriteReader.closeAll();
        DynamicTextureLoader.clearCache();
        long deltaTime = System.nanoTime() - time;
        int count = generated.getValue();
        MaterialPartTextureGenerator.runCallbacks(null, null);
        log.info("Finished generating {} textures in {} ms", (Object)count, (Object)Float.valueOf((float)deltaTime / 1000000.0f));
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)SUCCESS_KEY, (Object[])new Object[]{count, Float.valueOf((float)(deltaTime / 1000000L) / 1000.0f), ClientGeneratePartTexturesCommand.getOutputComponent(path.toFile())}), false);
        }
    }

    private static void savePackMcmeta(Path folder) {
        Path path = folder.resolve("pack.mcmeta");
        JsonObject meta = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "Generated Resources from the Tinkers' Construct Part Texture Generator");
        pack.addProperty("pack_format", (Number)8);
        meta.add("pack", (JsonElement)pack);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String json = MaterialRenderInfoLoader.GSON.toJson((JsonElement)meta);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                bufferedwriter.write(json);
            }
        }
        catch (IOException e) {
            log.error("Couldn't create pack.mcmeta for part textures", (Throwable)e);
        }
    }

    private static void saveImage(Path folder, ResourceLocation location, NativeImage image) {
        Path path = folder.resolve(Paths.get(PackType.CLIENT_RESOURCES.m_10305_(), location.m_135827_(), "textures", location.m_135815_() + ".png"));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            image.m_85066_(path);
        }
        catch (IOException e) {
            log.error("Couldn't create image for {}", (Object)location, (Object)e);
        }
    }

    private static void saveMetadata(Path folder, ResourceLocation location, JsonObject meta) {
        Path path = folder.resolve(Paths.get(PackType.CLIENT_RESOURCES.m_10305_(), location.m_135827_(), "textures", location.m_135815_() + ".png.mcmeta"));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String json = MaterialRenderInfoLoader.GSON.toJson((JsonElement)meta);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                bufferedwriter.write(json);
            }
        }
        catch (IOException e) {
            log.error("Couldn't create metadata for {}", (Object)location, (Object)e);
        }
    }

    private static GeneratorConfiguration loadGeneratorConfig(ResourceManager manager) {
        ImmutableList.Builder builder = ImmutableList.builder();
        GeneratorPartTextureJsonGenerator.StatOverride.Builder stats = new GeneratorPartTextureJsonGenerator.StatOverride.Builder();
        block7: for (String namespace : manager.m_7187_()) {
            ResourceLocation location = new ResourceLocation(namespace, GENERATOR_PART_TEXTURES);
            List resources = manager.m_213829_(location);
            if (resources.isEmpty()) continue;
            for (int r = resources.size() - 1; r >= 0; --r) {
                Resource resource = (Resource)resources.get(r);
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonObject object = GsonHelper.m_13859_((Reader)reader);
                        List parts = (List)AbstractPartSpriteProvider.PartSpriteInfo.LIST_LOADABLE.getIfPresent(object, "parts");
                        builder.addAll((Iterable)parts);
                        if (object.has("overrides")) {
                            for (Map.Entry entry : GsonHelper.m_13930_((JsonObject)object, (String)"overrides").entrySet()) {
                                String key = (String)entry.getKey();
                                MaterialStatsId statId = MaterialStatsId.PARSER.tryParse(key);
                                if (statId == null) {
                                    TConstruct.LOG.error("Invalid stat ID " + key);
                                    continue;
                                }
                                JsonArray array = GsonHelper.m_13924_((JsonElement)((JsonElement)entry.getValue()), (String)key);
                                for (int i = 0; i < array.size(); ++i) {
                                    stats.addVariant(statId, MaterialVariantId.parse(GsonHelper.m_13805_((JsonElement)array.get(i), (String)(key + "[" + i + "]"))));
                                }
                            }
                        }
                        if (!GsonHelper.m_13855_((JsonObject)object, (String)"replace", (boolean)false)) continue;
                        continue block7;
                    }
                    finally {
                        if (reader == null) continue block7;
                        reader.close();
                        continue block7;
                    }
                }
                catch (IOException ex) {
                    log.error("Failed to load modifier models from {} for pack {}", (Object)location, (Object)resource.m_215506_(), (Object)ex);
                }
            }
        }
        return new GeneratorConfiguration((List<AbstractPartSpriteProvider.PartSpriteInfo>)builder.build(), stats.build());
    }

    private static List<AbstractMaterialSpriteProvider.MaterialSpriteInfo> loadMaterialRenderInfoGenerators(ResourceManager manager, Predicate<MaterialVariantId> validMaterialId) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : manager.m_214159_("tinkering/materials", loc -> loc.m_135815_().endsWith(".json")).entrySet()) {
            MaterialVariantId id;
            ResourceLocation location = (ResourceLocation)entry.getKey();
            String localPath = JsonHelper.localize((String)location.m_135815_(), (String)"tinkering/materials", (String)".json");
            String variant = "";
            int slashIndex = localPath.lastIndexOf(47);
            if (slashIndex >= 0) {
                variant = localPath.substring(slashIndex + 1);
                localPath = localPath.substring(0, slashIndex);
            }
            if (!validMaterialId.test(id = MaterialVariantId.create(location.m_135827_(), localPath, variant))) continue;
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    MaterialRenderInfoJson json = (MaterialRenderInfoJson)MaterialRenderInfoLoader.GSON.fromJson((Reader)reader, MaterialRenderInfoJson.class);
                    MaterialRenderInfoJson.MaterialGeneratorJson generator = json.getGenerator();
                    if (generator == null) continue;
                    builder.add((Object)new AbstractMaterialSpriteProvider.MaterialSpriteInfo(Objects.requireNonNullElse(json.getTexture(), id.getLocation('_')), Objects.requireNonNullElse(json.getFallbacks(), new String[0]), generator));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonSyntaxException e) {
                log.error("Failed to read tool part texture generator info for {}", (Object)id, (Object)e);
            }
            catch (Exception exception) {}
        }
        return builder.build();
    }

    private record GeneratorConfiguration(List<AbstractPartSpriteProvider.PartSpriteInfo> sprites, GeneratorPartTextureJsonGenerator.StatOverride statOverrides) {
    }
}

