/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import com.google.common.collect.Multiset;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.armor.EffectImmunityModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorStatModule;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.modules.ranged.RestrictAngleModule;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierEvents {
    private static final TinkerDataCapability.TinkerDataKey<Float> PROJECTILE_EXPERIENCE = TConstruct.createKey("projectile_experience");

    @SubscribeEvent
    static void onKnockback(LivingKnockBackEvent event) {
        event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            int crystalbound;
            float knockback = data.get(TinkerDataKeys.KNOCKBACK, Float.valueOf(0.0f)).floatValue();
            if (knockback != 0.0f) {
                event.setStrength(event.getStrength() * (1.0f + knockback));
            }
            if ((crystalbound = data.get(TinkerDataKeys.CRYSTALSTRIKE, 0).intValue()) > 0) {
                RestrictAngleModule.onKnockback(event, crystalbound);
            }
        });
    }

    @SubscribeEvent
    static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        float boost = ArmorStatModule.getStat(entity, TinkerDataKeys.JUMP_BOOST);
        if (boost > 0.0f) {
            event.setDistance(Math.max(event.getDistance() - boost, 0.0f));
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        float boost = ArmorStatModule.getStat(entity, TinkerDataKeys.JUMP_BOOST);
        if (boost > 0.0f) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)boost * 0.1, 0.0));
        }
    }

    @SubscribeEvent
    static void isPotionApplicable(MobEffectEvent.Applicable event) {
        event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            if (((Multiset)data.computeIfAbsent(EffectImmunityModule.EFFECT_IMMUNITY)).contains((Object)event.getEffectInstance().m_19544_())) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    private static int boost(int original, float bonus) {
        return (int)((float)original * (1.0f + bonus));
    }

    @SubscribeEvent
    static void beforeBlockBreak(BlockEvent.BreakEvent event) {
        float bonus = ArmorStatModule.getStat((LivingEntity)event.getPlayer(), TinkerDataKeys.EXPERIENCE);
        if (bonus != 0.0f) {
            event.setExpToDrop(ModifierEvents.boost(event.getExpToDrop(), bonus));
        }
    }

    @SubscribeEvent
    static void onEntityKilled(LivingDeathEvent event) {
        Projectile projectile;
        ModifierNBT modifiers;
        Entity entity;
        DamageSource source = event.getSource();
        if (source != null && (entity = source.m_7640_()) instanceof Projectile && !(modifiers = EntityModifierCapability.getOrEmpty((Entity)(projectile = (Projectile)entity))).isEmpty()) {
            event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(PROJECTILE_EXPERIENCE, Float.valueOf(modifiers.getEntry(ModifierIds.experienced).getEffectiveLevel())));
        }
    }

    @SubscribeEvent
    static void onExperienceDrop(LivingExperienceDropEvent event) {
        ToolStack tool;
        float boost;
        float projectileBoost;
        float armorBoost = 0.0f;
        Player player = event.getAttackingPlayer();
        if (player != null) {
            armorBoost = ArmorStatModule.getStat((LivingEntity)player, TinkerDataKeys.EXPERIENCE);
        }
        if ((projectileBoost = event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> data.get(PROJECTILE_EXPERIENCE)).orElse(Float.valueOf(-1.0f)).floatValue()) > 0.0f) {
            event.setDroppedExperience(ModifierEvents.boost(event.getDroppedExperience(), projectileBoost * 0.5f + armorBoost));
        } else if (projectileBoost != 0.0f && player != null && (boost = ((tool = Modifier.getHeldTool((LivingEntity)player, ModifierLootingHandler.getLootingSlot((LivingEntity)player))) != null ? tool.getModifier(ModifierIds.experienced).getEffectiveLevel() : 0.0f) * 0.5f + armorBoost) > 0.0f) {
            event.setDroppedExperience(ModifierEvents.boost(event.getDroppedExperience(), boost));
        }
    }
}

