/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class DragonbornModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final TinkerDataCapability.ComputableDataKey<ModifierMaxLevel> DRAGONBORN = TConstruct.createKey("dragonborn", ModifierMaxLevel::new);

    public DragonbornModifier() {
        super(DRAGONBORN);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, CriticalHitEvent.class, DragonbornModifier::onCritical);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule((HookProvider)ProtectionModule.builder().entity((IJsonPredicate<LivingEntity>)TinkerPredicate.AIRBORNE).eachLevel(2.5f));
    }

    private static void onCritical(CriticalHitEvent event) {
        if (event.getResult() != Event.Result.DENY) {
            Player living = event.getEntity();
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(arg_0 -> DragonbornModifier.lambda$onCritical$0(event, (LivingEntity)living, arg_0));
        }
    }

    private static /* synthetic */ void lambda$onCritical$0(CriticalHitEvent event, LivingEntity living, TinkerDataCapability.Holder data) {
        float max;
        ModifierMaxLevel dragonborn = data.get(DRAGONBORN);
        if (dragonborn != null && (max = dragonborn.getMax()) > 0.0f) {
            boolean isCritical;
            boolean bl = isCritical = event.isVanillaCritical() || event.getResult() == Event.Result.ALLOW;
            if (!isCritical && TinkerPredicate.AIRBORNE.matches((Object)living)) {
                isCritical = true;
                event.setResult(Event.Result.ALLOW);
            }
            if (isCritical) {
                event.setDamageModifier(event.getDamageModifier() + max * 0.05f);
            }
        }
    }
}

