/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import net.minecraft.world.entity.EquipmentSlot;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class MeleeProtectionModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final TinkerDataCapability.ComputableDataKey<ModifierMaxLevel> KEY = TConstruct.createKey("melee_protection", ModifierMaxLevel::new);

    public MeleeProtectionModifier() {
        super(KEY);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule((HookProvider)ProtectionModule.builder().sources(new IJsonPredicate[]{DamageSourcePredicate.CAN_PROTECT, DamageSourcePredicate.MELEE}).eachLevel(2.5f));
    }

    @Override
    protected void set(ModifierMaxLevel data, EquipmentSlot slot, float scaledLevel, EquipmentChangeContext context) {
        float oldMax = data.getMax();
        super.set(data, slot, scaledLevel, context);
        float newMax = data.getMax();
        if (oldMax != newMax) {
            context.getTinkerData().ifPresent(d -> d.add(TinkerDataKeys.USE_ITEM_SPEED, (newMax - oldMax) * 0.05f));
        }
    }
}

