/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ReduceToolDamageModule;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.stats.ToolType;

public class TemperateModifier
extends Modifier
implements ConditionalStatModifierHook,
ToolDamageModifierHook,
BreakSpeedModifierHook,
TooltipModifierHook,
ProtectionModifierHook {
    private static final float MAX_TEMPERATURE = 1.25f;
    private static final float BASELINE_TEMPERATURE = 0.75f;
    private static final float MAX_MINING_BOOST = 6.0f;
    private static final float MAX_DRAWSPEED_BOOST = 0.120000005f;
    private static final Component SPEED = TConstruct.makeTranslation("modifier", "temperate.speed");
    private static final Component REINFORCED = TConstruct.makeTranslation("modifier", "temperate.reinforced");

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.TOOL_DAMAGE, ModifierHooks.BREAK_SPEED, ModifierHooks.TOOLTIP, ModifierHooks.PROTECTION);
    }

    private static float diminishingPercent(float level) {
        if (level < 5.0f) {
            return 0.025f * level * (11.0f - level);
        }
        return 0.75f + (level - 5.0f) * 0.05f;
    }

    private static float getBonus(LivingEntity living, BlockPos pos) {
        return ((Biome)living.f_19853_.m_204166_(pos).m_203334_()).m_47505_(pos) - 0.75f;
    }

    @Override
    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        float bonus;
        if (holder != null && (bonus = TemperateModifier.getBonus(holder, holder.m_20183_())) > 0.0f) {
            return ReduceToolDamageModule.reduceDamage(amount, TemperateModifier.diminishingPercent(bonus * 2.0f * modifier.getEffectiveLevel() / 1.25f));
        }
        return amount;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        float bonus;
        Optional pos = event.getPosition();
        if (isEffective && pos.isPresent() && (bonus = TemperateModifier.getBonus((LivingEntity)event.getEntity(), (BlockPos)pos.get())) < 0.0f) {
            event.setNewSpeed(event.getNewSpeed() - bonus * 6.0f * tool.getMultiplier(ToolStats.MINING_SPEED) * miningSpeedModifier * modifier.getEffectiveLevel());
        }
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        float bonus;
        if (stat == ToolStats.DRAW_SPEED && (bonus = TemperateModifier.getBonus(living, living.m_20183_())) < 0.0f) {
            baseValue -= bonus * 0.120000005f * multiplier * modifier.getEffectiveLevel();
        }
        return baseValue;
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        LivingEntity target;
        float bonus;
        if (DamageSourcePredicate.CAN_PROTECT.matches((Object)source) && (bonus = TemperateModifier.getBonus(target = context.getEntity(), target.m_20183_())) < 0.0f) {
            modifierValue -= bonus * modifier.getEffectiveLevel();
        }
        return modifierValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        ToolType type = ToolType.from(tool.getItem(), ToolType.NO_MELEE);
        if (type != null) {
            float bonus = entry.getEffectiveLevel();
            bonus = player != null && key == TooltipKey.SHIFT ? (bonus *= TemperateModifier.getBonus((LivingEntity)player, player.m_20183_())) : (bonus *= -1.0f);
            if (bonus < -0.01f) {
                if (type == ToolType.ARMOR) {
                    ProtectionModule.addResistanceTooltip(tool, entry.getModifier(), -bonus, player, tooltip);
                } else {
                    float value = type == ToolType.HARVEST ? -bonus * tool.getMultiplier(ToolStats.MINING_SPEED) * 6.0f : -bonus * tool.getMultiplier(ToolStats.DRAW_SPEED) * 0.120000005f;
                    TooltipModifierHook.addFlatBoost(entry.getModifier(), SPEED, value, tooltip);
                }
            }
            if (bonus > 0.01f) {
                tooltip.add((Component)this.applyStyle(Component.m_237113_((String)(Util.PERCENT_FORMAT.format(TemperateModifier.diminishingPercent(bonus * 2.0f / 1.25f)) + " ")).m_7220_(REINFORCED)));
            }
        }
    }
}

