/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import java.util.List;
import net.minecraft.network.chat.Component;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public record PlatingMaterialStats(MaterialStatType<?> getType, int durability, float armor, float toughness, float knockbackResistance) implements IRepairableMaterialStats
{
    private static final LoadableField<Float, PlatingMaterialStats> TOUGHNESS = FloatLoadable.FROM_ZERO.defaultField("toughness", (Object)Float.valueOf(0.0f), PlatingMaterialStats::toughness);
    private static final LoadableField<Float, PlatingMaterialStats> KNOCKBACK_RESISTANCE = FloatLoadable.FROM_ZERO.defaultField("knockback_resistance", (Object)Float.valueOf(0.0f), PlatingMaterialStats::knockbackResistance);
    private static final RecordLoadable<PlatingMaterialStats> LOADABLE = RecordLoadable.create((RecordField)MaterialStatType.CONTEXT_KEY.requiredField(), IRepairableMaterialStats.DURABILITY_FIELD, (RecordField)FloatLoadable.FROM_ZERO.defaultField("armor", (Object)Float.valueOf(0.0f), true, PlatingMaterialStats::armor), TOUGHNESS, KNOCKBACK_RESISTANCE, PlatingMaterialStats::new);
    private static final List<Component> DESCRIPTION = List.of(ToolStats.DURABILITY.getDescription(), ToolStats.ARMOR.getDescription(), ToolStats.ARMOR_TOUGHNESS.getDescription(), ToolStats.KNOCKBACK_RESISTANCE.getDescription());
    private static final List<Component> SHIELD_DESCRIPTION = List.of(ToolStats.DURABILITY.getDescription(), ToolStats.ARMOR_TOUGHNESS.getDescription(), ToolStats.KNOCKBACK_RESISTANCE.getDescription());
    public static final MaterialStatType<PlatingMaterialStats> HELMET = PlatingMaterialStats.makeType("plating_helmet");
    public static final MaterialStatType<PlatingMaterialStats> CHESTPLATE = PlatingMaterialStats.makeType("plating_chestplate");
    public static final MaterialStatType<PlatingMaterialStats> LEGGINGS = PlatingMaterialStats.makeType("plating_leggings");
    public static final MaterialStatType<PlatingMaterialStats> BOOTS = PlatingMaterialStats.makeType("plating_boots");
    public static final MaterialStatType<PlatingMaterialStats> SHIELD = new MaterialStatType<PlatingMaterialStats>(new MaterialStatsId("tconstruct", "plating_shield"), type -> new PlatingMaterialStats((MaterialStatType<?>)type, 1, 0.0f, 0.0f, 0.0f), RecordLoadable.create((RecordField)MaterialStatType.CONTEXT_KEY.requiredField(), IRepairableMaterialStats.DURABILITY_FIELD, TOUGHNESS, KNOCKBACK_RESISTANCE, (type, durability, toughness, knockbackResistance) -> new PlatingMaterialStats((MaterialStatType<?>)type, (int)durability, 0.0f, toughness.floatValue(), knockbackResistance.floatValue())));
    public static final List<MaterialStatType<PlatingMaterialStats>> TYPES = List.of(BOOTS, LEGGINGS, CHESTPLATE, HELMET, SHIELD);

    @Override
    public List<Component> getLocalizedInfo() {
        Component durability = ToolStats.DURABILITY.formatValue(this.durability);
        Component toughness = ToolStats.ARMOR_TOUGHNESS.formatValue(this.toughness);
        Component knockbackResistance = ToolStats.KNOCKBACK_RESISTANCE.formatValue(this.knockbackResistance * 10.0f);
        if (this.getType == SHIELD) {
            return List.of(durability, toughness, knockbackResistance);
        }
        return List.of(durability, ToolStats.ARMOR.formatValue(this.armor), toughness, knockbackResistance);
    }

    @Override
    public List<Component> getLocalizedDescriptions() {
        return this.getType == SHIELD ? SHIELD_DESCRIPTION : DESCRIPTION;
    }

    @Override
    public void apply(ModifierStatsBuilder builder, float scale) {
        ToolStats.DURABILITY.update(builder, Float.valueOf((float)this.durability * scale));
        ToolStats.ARMOR.update(builder, Float.valueOf(this.armor * scale));
        ToolStats.ARMOR_TOUGHNESS.update(builder, Float.valueOf(this.toughness * scale));
        ToolStats.KNOCKBACK_RESISTANCE.update(builder, Float.valueOf(this.knockbackResistance * scale));
    }

    private static MaterialStatType<PlatingMaterialStats> makeType(String name) {
        return new MaterialStatType<PlatingMaterialStats>(new MaterialStatsId("tconstruct", name), type -> new PlatingMaterialStats((MaterialStatType<?>)type, 1, 0.0f, 0.0f, 0.0f), LOADABLE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements ArmorSlotType.ArmorShieldBuilder<PlatingMaterialStats> {
        private final int[] durability = new int[4];
        private int shieldDurability = 0;
        private final float[] armor = new float[4];
        private float toughness = 0.0f;
        private float knockbackResistance = 0.0f;

        private Builder() {
        }

        public Builder durabilityFactor(float maxDamageFactor) {
            for (ArmorSlotType slotType : ArmorSlotType.values()) {
                int index = slotType.getIndex();
                this.durability[index] = (int)((float)ArmorSlotType.MAX_DAMAGE_ARRAY[index] * maxDamageFactor);
            }
            if (this.shieldDurability == 0) {
                this.shieldDurability = (int)(maxDamageFactor * 18.0f);
            }
            return this;
        }

        public Builder armor(float boots, float leggings, float chestplate, float helmet) {
            this.armor[ArmorSlotType.BOOTS.getIndex()] = boots;
            this.armor[ArmorSlotType.LEGGINGS.getIndex()] = leggings;
            this.armor[ArmorSlotType.CHESTPLATE.getIndex()] = chestplate;
            this.armor[ArmorSlotType.HELMET.getIndex()] = helmet;
            return this;
        }

        @Override
        public PlatingMaterialStats build(ArmorSlotType slot) {
            int index = slot.getIndex();
            return new PlatingMaterialStats(TYPES.get(index), this.durability[index], this.armor[index], this.toughness, this.knockbackResistance);
        }

        @Override
        public PlatingMaterialStats buildShield() {
            return new PlatingMaterialStats(SHIELD, this.shieldDurability, 0.0f, this.toughness, this.knockbackResistance);
        }

        public Builder shieldDurability(int shieldDurability) {
            this.shieldDurability = shieldDurability;
            return this;
        }

        public Builder toughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        public Builder knockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }
    }
}

