/*
 * Decompiled with CFR 0.152.
 */
package net.createarmory.item.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.createarmory.interfaces.RendersPlayerArms;
import net.createarmory.item.PipePistolItem;
import net.createarmory.item.model.PipePistolItemModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoItemRenderer;

public class PipePistolItemRenderer
extends GeoItemRenderer<PipePistolItem>
implements RendersPlayerArms {
    private static final float SCALE_RECIPROCAL = 0.0625f;
    protected boolean renderArms = false;
    protected MultiBufferSource currentBuffer;
    protected RenderType renderType;
    public ItemTransforms.TransformType transformType;
    protected PipePistolItem animatable;
    private float aimProgress = 0.0f;
    private final Set<String> hiddenBones = new HashSet<String>();
    private final Set<String> suppressedBones = new HashSet<String>();
    private final Map<String, Vector3f> queuedBoneSetMovements = new HashMap<String, Vector3f>();
    private final Map<String, Vector3f> queuedBoneSetRotations = new HashMap<String, Vector3f>();
    private final Map<String, Vector3f> queuedBoneAddRotations = new HashMap<String, Vector3f>();

    public PipePistolItemRenderer() {
        super((AnimatedGeoModel)new PipePistolItemModel());
    }

    public RenderType getRenderType(PipePistolItem animatable, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, ResourceLocation texture) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void m_108829_(ItemStack itemStack, ItemTransforms.TransformType transformType, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int p_239207_6_) {
        this.transformType = transformType;
        super.m_108829_(itemStack, transformType, matrixStack, bufferIn, combinedLightIn, p_239207_6_);
    }

    public void render(GeoModel model, PipePistolItem animatable, float partialTicks, RenderType type, PoseStack matrixStackIn, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.currentBuffer = renderTypeBuffer;
        this.renderType = type;
        this.animatable = animatable;
        super.render(model, (Object)animatable, partialTicks, type, matrixStackIn, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (this.renderArms) {
            this.renderArms = false;
        }
    }

    public void render(PipePistolItem animatable, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn, ItemStack itemStack) {
        Minecraft mc = Minecraft.m_91087_();
        float sign = 1.0f;
        this.aimProgress = Mth.m_14036_((float)(this.aimProgress + mc.m_91296_() * sign * 0.1f), (float)0.0f, (float)1.0f);
        stack.m_85836_();
        animatable.setupAnimationState(this, itemStack, stack, this.aimProgress);
        super.render((Item)animatable, stack, bufferIn, packedLightIn, itemStack);
        stack.m_85849_();
        if (this.animatable != null) {
            this.animatable.getTransformType(this.transformType);
        }
    }

    public ResourceLocation getTextureLocation(PipePistolItem instance) {
        return super.getTextureLocation((Item)instance);
    }

    public Integer getUniqueID(PipePistolItem animatable) {
        if (this.currentItemStack == null || this.transformType != ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND && this.transformType != ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
            return -1;
        }
        return super.getUniqueID((Item)animatable);
    }

    public void hideBone(String name, boolean hide) {
        if (hide) {
            this.hiddenBones.add(name);
        } else {
            this.hiddenBones.remove(name);
        }
    }

    @Override
    public void setRenderArms(boolean renderArms) {
        this.renderArms = renderArms;
    }

    public ItemTransforms.TransformType getCurrentTransform() {
        return this.transformType;
    }

    public void suppressModification(String name) {
        this.suppressedBones.add(name);
    }

    public void allowModification(String name) {
        this.suppressedBones.remove(name);
    }

    public void setBonePosition(String name, float x, float y, float z) {
        this.queuedBoneSetMovements.put(name, new Vector3f(x, y, z));
    }

    public void addToBoneRotation(String name, float x, float y, float z) {
        this.queuedBoneAddRotations.put(name, new Vector3f(x, y, z));
    }

    public void setBoneRotation(String name, float x, float y, float z) {
        this.queuedBoneSetRotations.put(name, new Vector3f(x, y, z));
    }

    public ItemStack getCurrentItem() {
        return this.currentItemStack;
    }

    @Override
    public boolean shouldAllowHandRender(ItemStack mainhand, ItemStack offhand, InteractionHand renderingHand) {
        return renderingHand == InteractionHand.MAIN_HAND;
    }

    static {
        AnimationController.addModelFetcher(animatable -> {
            if (animatable instanceof PipePistolItem) {
                Item item = (Item)animatable;
                PipePistolItemRenderer ister = new PipePistolItemRenderer();
                if (ister instanceof GeoItemRenderer) {
                    return ((GeoItemRenderer)ister).getGeoModelProvider();
                }
            }
            return null;
        });
    }
}

