/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.man_of_many_planes.entity;

import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirplaneEntity;
import immersive_aircraft.entity.misc.Trail;
import java.util.List;
import net.conczin.man_of_many_planes.ManOfManyPlanes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EconomyPlaneEntity
extends AirplaneEntity {
    private final List<Trail> trails = List.of(new Trail(60), new Trail(60), new Trail(30), new Trail(30));

    public EconomyPlaneEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    public Item asItem() {
        return ManOfManyPlanes.ECONOMY_PLANE_ITEM.get();
    }

    public List<Trail> getTrails() {
        return this.trails;
    }

    protected void trail(Matrix4f transform, int index, float x, float y, float z, float thickness) {
        Vector4f p0 = this.transformPosition(transform, x, y - thickness, z);
        Vector4f p1 = this.transformPosition(transform, x, y + thickness, z);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(Math.sqrt(this.m_20184_().m_82553_()) * (double)(0.5f + this.pressingInterpolatedX.getSmooth() * x * 0.025f) - 0.25)));
        this.getTrails().get(index).add(p0, p1, trailStrength);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.isWithinParticleRange()) {
                Matrix4f transform = this.getVehicleTransform();
                Matrix3f normalTransform = this.getVehicleNormalTransform();
                this.trail(transform, 0, -5.5f, 2.2f, -0.6f, 0.25f);
                this.trail(transform, 1, 5.5f, 2.2f, -0.6f, 0.25f);
                this.trail(transform, 2, -3.2f, 2.5f, -6.6f, 0.15f);
                this.trail(transform, 3, 3.2f, 2.5f, -6.6f, 0.15f);
                float power = this.getEnginePower();
                if ((double)power > 0.05) {
                    Vector4f p = this.transformPosition(transform, 0.5f * (this.f_19797_ % 2 == 0 ? -1.0f : 1.0f), 2.5f, -2.2f + 0.8f * ((float)this.f_19797_ / 2.0f % 2.0f));
                    Vector3f vel = this.transformVector(normalTransform, 0.2f * (this.f_19797_ % 2 == 0 ? -1.0f : 1.0f), 0.0f, 0.0f);
                    Vec3 velocity = this.m_20184_();
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)p.m_123601_(), (double)p.m_123615_(), (double)p.m_123616_(), (double)vel.m_122239_() + velocity.f_82479_, (double)vel.m_122260_() + velocity.f_82480_, (double)vel.m_122269_() + velocity.f_82481_);
                }
            } else {
                this.trails.get(0).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
                this.trails.get(1).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
            }
        }
    }

    public double getZoom() {
        return 12.0;
    }
}

