/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import immersive_aircraft.Main;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.VehicleEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class OverlayRenderer
extends GuiComponent {
    static OverlayRenderer INSTANCE = new OverlayRenderer();
    private static final ResourceLocation ENGINE_TEX = Main.locate("textures/gui/engine.png");
    private static final ResourceLocation POWER_TEX = Main.locate("textures/gui/power.png");
    private static final ResourceLocation ICONS_TEX = Main.locate("textures/gui/icons.png");
    private float bootUp = 0.0f;
    private float lastTime = 0.0f;

    public static void renderOverlay(PoseStack matrices, float tickDelta) {
        Minecraft client = Minecraft.m_91087_();
        if (!client.f_91066_.f_92062_ && client.f_91072_ != null && client.f_91074_ != null) {
            Entity entity;
            if (Config.getInstance().showHotbarEngineGauge && (entity = client.f_91074_.m_20201_()) instanceof EngineAircraft) {
                EngineAircraft aircraft = (EngineAircraft)entity;
                INSTANCE.renderAircraftGui(client, matrices, tickDelta, aircraft);
            }
            if ((entity = client.f_91074_.m_20201_()) instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)entity;
                INSTANCE.renderAircraftHealth(client, matrices, vehicle);
            }
        }
    }

    private void renderAircraftHealth(Minecraft minecraft, PoseStack poseStack, VehicleEntity vehicle) {
        int shaderTexture = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS_TEX);
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        int maxHearts = 10;
        int health = (int)Math.ceil(vehicle.getHealth() * (float)maxHearts * 2.0f);
        int y = screenHeight - 49 - Config.getInstance().healthBarRow * 10;
        int ox = screenWidth / 2 + 91;
        for (int i = 0; i < maxHearts; ++i) {
            int u = 52;
            int x = ox - i * 8 - 9;
            OverlayRenderer.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)u, (float)9.0f, (int)9, (int)9, (int)64, (int)64);
            if (i * 2 + 1 < health) {
                OverlayRenderer.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)9, (int)9, (int)64, (int)64);
            }
            if (i * 2 + 1 != health) continue;
            OverlayRenderer.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)10.0f, (float)0.0f, (int)9, (int)9, (int)64, (int)64);
        }
        RenderSystem.m_157453_((int)0, (int)shaderTexture);
    }

    private void renderAircraftGui(Minecraft client, PoseStack matrices, float tickDelta, EngineAircraft aircraft) {
        assert (client.f_91073_ != null);
        if (aircraft.getGuiStyle() == EngineAircraft.GUI_STYLE.ENGINE) {
            int frame;
            float time = (float)(client.f_91073_.m_46467_() % 65536L) + tickDelta;
            float delta = time - this.lastTime;
            this.lastTime = time;
            if (aircraft.getEngineTarget() > 0.0f && (double)aircraft.getEnginePower() > 0.001) {
                if (this.bootUp < 1.0f) {
                    this.bootUp = Math.min(1.0f, this.bootUp + delta * 0.2f);
                    frame = (int)(this.bootUp * 5.0f);
                } else {
                    int FPS = 30;
                    int animation = (int)(aircraft.engineRotation.getSmooth(tickDelta) / 20.0f * 30.0f);
                    frame = 5 + animation % 6;
                }
            } else if (this.bootUp > 0.0f) {
                this.bootUp = Math.max(0.0f, this.bootUp - delta * 0.1f);
                frame = 10 + (int)((1.0 - (double)this.bootUp) * 10.0);
            } else {
                frame = 20;
            }
            int powerFrame = (int)((double)((1.0f - aircraft.getEnginePower()) * 10.0f) + 10.5);
            int powerFrameTarget = (int)((double)((1.0f - aircraft.getEngineTarget()) * 10.0f) + 10.5);
            int x = client.m_91268_().m_85445_() / 2;
            int y = client.m_91268_().m_85446_() - 37;
            if (client.f_91072_ != null && !client.f_91072_.m_105288_()) {
                y += 7;
            }
            int shaderTexture = RenderSystem.m_157203_((int)0);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ENGINE_TEX);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(x - 9), (int)(y - 9), (float)(frame % 5 * 18), (float)(Math.floorDiv(frame, 5) * 18), (int)18, (int)18, (int)90, (int)90);
            RenderSystem.m_157456_((int)0, (ResourceLocation)POWER_TEX);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(x - 9), (int)(y - 9), (float)(powerFrame % 5 * 18), (float)(Math.floorDiv(powerFrame, 5) * 18), (int)18, (int)18, (int)90, (int)90);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(x - 9), (int)(y - 9), (float)(powerFrameTarget % 5 * 18), (float)(Math.floorDiv(powerFrameTarget, 5) * 18), (int)18, (int)18, (int)90, (int)90);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157453_((int)0, (int)shaderTexture);
        }
    }
}

