/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.item.upgrade.AircraftStat;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GyrodyneEntity
extends Rotorcraft {
    @Override
    public EngineAircraft.GUI_STYLE getGuiStyle() {
        return EngineAircraft.GUI_STYLE.NONE;
    }

    public GyrodyneEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, false);
    }

    @Override
    protected SoundEvent getEngineStartSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    public Item asItem() {
        return Items.GYRODYNE.get();
    }

    @Override
    protected float getGravity() {
        return (1.0f - this.getEnginePower()) * super.getGravity();
    }

    private void updateEnginePowerTooltip() {
        Entity entity = this.m_6688_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_9236_().f_46443_ && (double)this.getFuelUtilization() > 0.0) {
                player.m_5661_((Component)Component.m_237110_((String)"immersive_aircraft.gyrodyne_target", (Object[])new Object[]{(int)(this.getEngineTarget() * 100.0f + 0.5f)}), true);
            }
        }
    }

    @Override
    protected String getFuelType() {
        return "fat";
    }

    @Override
    protected boolean isFuelLow() {
        return false;
    }

    @Override
    protected void updateController() {
        super.updateController();
        if (this.getEngineTarget() < 1.0f) {
            Entity entity;
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + this.pressingInterpolatedZ.getValue() * 0.05f - 0.035f)));
            this.updateEnginePowerTooltip();
            if ((double)this.getEngineTarget() == 1.0 && (entity = this.m_6688_()) instanceof Player) {
                Player player = (Player)entity;
                if (player.m_9236_().f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"immersive_aircraft.gyrodyne_target_reached"), true);
                    if (this.f_19861_) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
                    }
                }
            }
        }
        float power = this.getEnginePower() * this.getProperties().get(AircraftStat.VERTICAL_SPEED) * this.pressingInterpolatedY.getSmooth();
        this.m_20256_(this.m_20184_().m_82549_(this.getTopDirection().m_82490_((double)power)));
        Vec3 direction = this.getForwardDirection();
        float sin = Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.getProperties().get(AircraftStat.ENGINE_SPEED)) * sin;
        if (this.f_19861_ && (double)this.getEngineTarget() < 1.0) {
            thrust = this.getProperties().get(AircraftStat.PUSH_SPEED) / (1.0f + (float)this.m_20184_().m_82553_() * 5.0f) * this.pressingInterpolatedZ.getSmooth() * ((double)this.pressingInterpolatedZ.getSmooth() > 0.0 ? 1.0f : 0.5f) * this.getEnginePower();
        }
        this.m_20256_(this.m_20184_().m_82549_(direction.m_82490_((double)thrust)));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_6688_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float consumption = this.getFuelConsumption() * 0.025f;
            player.m_36324_().m_38703_(consumption);
        }
    }

    @Override
    public float getFuelUtilization() {
        Player player;
        Entity entity = this.m_6688_();
        if (entity instanceof Player && (player = (Player)entity).m_36324_().m_38702_() > 5) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public double getZoom() {
        return 2.0;
    }
}

