/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import immersive_aircraft.util.Rect2iCommon;
import immersive_aircraft.util.Utils;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.FriendlyByteBuf;

public class VehicleInventoryDescription {
    int height = 0;
    int lastIndex = 0;
    int lastSyncIndex = 0;
    final List<Rect2iCommon> rectangles = new LinkedList<Rect2iCommon>();
    EnumMap<SlotType, List<Slot>> slotMap = new EnumMap(SlotType.class);
    final List<Slot> slots = new LinkedList<Slot>();

    public VehicleInventoryDescription() {
        for (SlotType value : SlotType.values()) {
            this.slotMap.put(value, new LinkedList());
        }
    }

    public VehicleInventoryDescription(FriendlyByteBuf buffer) {
        for (SlotType value : SlotType.values()) {
            this.slotMap.put(value, new LinkedList());
        }
        int slotCount = buffer.readInt();
        for (int i = 0; i < slotCount; ++i) {
            SlotType type = SlotType.values()[buffer.readInt()];
            this.addSlot(type, buffer.readInt(), buffer.readInt());
        }
        int rectCount = buffer.readInt();
        for (int i = 0; i < rectCount; ++i) {
            this.addRectangle(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
        this.build();
    }

    public VehicleInventoryDescription(JsonArray inventorySlots) {
        for (SlotType value : SlotType.values()) {
            this.slotMap.put(value, new LinkedList());
        }
        inventorySlots.forEach(jsonElement -> {
            JsonObject slot = jsonElement.getAsJsonObject();
            int cols = Utils.getIntElement(slot, "cols", 1);
            int rows = Utils.getIntElement(slot, "rows", 1);
            this.addSlots(SlotType.valueOf(slot.get("type").getAsString().toUpperCase(Locale.ROOT)), slot.get("x").getAsInt(), slot.get("y").getAsInt(), cols, rows, slot.has("boxed") && slot.getAsJsonPrimitive("boxed").getAsBoolean());
        });
        this.build();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slots.size());
        for (Slot slot : this.slots) {
            buffer.writeInt(slot.type.ordinal());
            buffer.writeInt(slot.x);
            buffer.writeInt(slot.y);
        }
        buffer.writeInt(this.rectangles.size());
        for (Rect2iCommon rectangle : this.rectangles) {
            buffer.writeInt(rectangle.getX());
            buffer.writeInt(rectangle.getY());
            buffer.writeInt(rectangle.getWidth());
            buffer.writeInt(rectangle.getHeight());
        }
    }

    public int getInventorySize() {
        return this.slots.size();
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public List<Slot> getSlots(SlotType type) {
        return this.slotMap.get((Object)type);
    }

    public VehicleInventoryDescription addSlot(SlotType type, int x, int y) {
        Slot slot = new Slot(x, y, this.lastIndex++, type);
        this.slotMap.get((Object)type).add(slot);
        this.slots.add(slot);
        if (type != SlotType.INVENTORY) {
            this.lastSyncIndex = this.lastIndex;
        }
        return this;
    }

    public VehicleInventoryDescription addSlots(SlotType type, int x, int y, int cols, int rows, boolean boxed) {
        if (boxed) {
            this.addRectangle(x - 8, y + 2, cols * 18 + 14, rows * 18 + 14);
        }
        for (int sx = 0; sx < cols; ++sx) {
            for (int sy = 0; sy < rows; ++sy) {
                this.addSlot(type, x + sx * 18, y + sy * 18);
            }
        }
        return this;
    }

    public VehicleInventoryDescription addRectangle(int x, int y, int w, int h) {
        this.rectangles.add(new Rect2iCommon(x, y, w, h));
        return this;
    }

    public VehicleInventoryDescription build() {
        for (Slot slot : this.slots) {
            if (slot.x < 0 || slot.x >= 176) continue;
            this.height = Math.max(this.height, slot.y + 28);
        }
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLastSyncIndex() {
        return this.lastSyncIndex;
    }

    public List<Rect2iCommon> getRectangles() {
        return this.rectangles;
    }

    public static enum SlotType {
        INVENTORY,
        BOILER,
        WEAPON,
        UPGRADE,
        BOOSTER,
        BANNER,
        DYE;

    }

    public record Slot(int x, int y, int index, SlotType type) {
    }
}

