/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapons;

import com.mojang.math.Vector3f;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapons.RotationalManager;
import immersive_aircraft.entity.weapons.Weapon;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class Telescope
extends Weapon {
    private final RotationalManager rotationalManager = new RotationalManager(this);
    int lastFireTick = 0;

    public Telescope(VehicleEntity entity, ItemStack stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    @Override
    public void tick() {
        Entity pilot;
        this.rotationalManager.tick();
        this.rotationalManager.pointTo(this.getEntity());
        --this.lastFireTick;
        if (this.lastFireTick == 0 && (pilot = this.getEntity().m_6688_()) != null) {
            pilot.m_5496_(SoundEvents.f_144232_, 1.0f, 1.0f);
        }
    }

    @Override
    public void fire(Vector3f direction) {
    }

    @Override
    public void clientFire(int index) {
        Entity pilot = this.getEntity().m_6688_();
        assert (pilot != null);
        if (this.lastFireTick <= 0) {
            pilot.m_5496_(SoundEvents.f_144231_, 1.0f, 1.0f);
        }
        this.lastFireTick = 2;
    }

    public Boolean isScoping() {
        return this.lastFireTick > 0;
    }

    @Override
    public <T extends AircraftEntity> void setAnimationVariables(T entity, float time) {
        float tickDelta = time % 1.0f;
        BBAnimationVariables.set("pitch", (float)((double)this.rotationalManager.getPitch(tickDelta) / Math.PI * 180.0));
        BBAnimationVariables.set("yaw", (float)((double)this.rotationalManager.getYaw(tickDelta) / Math.PI * 180.0));
        BBAnimationVariables.set("roll", (float)((double)this.rotationalManager.getRoll(tickDelta) / Math.PI * 180.0));
    }
}

