/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.block.QuarkDoorBlock;
import vazkii.quark.base.block.QuarkFenceBlock;
import vazkii.quark.base.block.QuarkFenceGateBlock;
import vazkii.quark.base.block.QuarkPillarBlock;
import vazkii.quark.base.block.QuarkPressurePlateBlock;
import vazkii.quark.base.block.QuarkStandingSignBlock;
import vazkii.quark.base.block.QuarkTrapdoorBlock;
import vazkii.quark.base.block.QuarkWallSignBlock;
import vazkii.quark.base.block.QuarkWoodenButtonBlock;
import vazkii.quark.base.client.render.QuarkBoatRenderer;
import vazkii.quark.base.handler.FuelHandler;
import vazkii.quark.base.handler.ToolInteractionHandler;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.item.QuarkSignItem;
import vazkii.quark.base.item.boat.QuarkBoat;
import vazkii.quark.base.item.boat.QuarkBoatDispenseItemBehavior;
import vazkii.quark.base.item.boat.QuarkBoatItem;
import vazkii.quark.base.item.boat.QuarkChestBoat;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.block.HollowLogBlock;
import vazkii.quark.content.building.block.VariantBookshelfBlock;
import vazkii.quark.content.building.block.VariantLadderBlock;
import vazkii.quark.content.building.block.WoodPostBlock;
import vazkii.quark.content.building.module.HollowLogsModule;
import vazkii.quark.content.building.module.VariantBookshelvesModule;
import vazkii.quark.content.building.module.VariantChestsModule;
import vazkii.quark.content.building.module.VariantLaddersModule;
import vazkii.quark.content.building.module.VerticalPlanksModule;
import vazkii.quark.content.building.module.WoodenPostsModule;

public class WoodSetHandler {
    private static final Map<String, QuarkBoatType> quarkBoatTypes = new HashMap<String, QuarkBoatType>();
    public static EntityType<QuarkBoat> quarkBoatEntityType = null;
    public static EntityType<QuarkChestBoat> quarkChestBoatEntityType = null;
    private static final List<WoodSet> woodSets = new ArrayList<WoodSet>();

    public static void register() {
        quarkBoatEntityType = EntityType.Builder.m_20704_(QuarkBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).setCustomClientFactory((spawnEntity, world) -> new QuarkBoat((EntityType<? extends Boat>)quarkBoatEntityType, (Level)world)).m_20712_("quark_boat");
        quarkChestBoatEntityType = EntityType.Builder.m_20704_(QuarkChestBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).setCustomClientFactory((spawnEntity, world) -> new QuarkChestBoat((EntityType<? extends Boat>)quarkChestBoatEntityType, (Level)world)).m_20712_("quark_chest_boat");
        RegistryHelper.register(quarkBoatEntityType, (String)"quark_boat", (ResourceKey)Registry.f_122903_);
        RegistryHelper.register(quarkChestBoatEntityType, (String)"quark_chest_boat", (ResourceKey)Registry.f_122903_);
    }

    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Map registry = DispenserBlock.f_52661_;
            for (WoodSet set : woodSets) {
                registry.put(set.boatItem, new QuarkBoatDispenseItemBehavior(set.name, false));
                registry.put(set.chestBoatItem, new QuarkBoatDispenseItemBehavior(set.name, true));
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_(quarkBoatEntityType, r -> new QuarkBoatRenderer(r, false));
        EntityRenderers.m_174036_(quarkChestBoatEntityType, r -> new QuarkBoatRenderer(r, true));
        event.enqueueWork(() -> {
            for (WoodSet set : woodSets) {
                Sheets.addWoodType((WoodType)set.type);
            }
        });
    }

    public static WoodSet addWoodSet(QuarkModule module, String name, MaterialColor color, MaterialColor barkColor, boolean flammable) {
        return WoodSetHandler.addWoodSet(module, name, color, barkColor, true, true, flammable);
    }

    public static WoodSet addWoodSet(QuarkModule module, String name, MaterialColor color, MaterialColor barkColor, boolean hasLog, boolean hasBoat, boolean flammable) {
        WoodType type = WoodType.m_61844_((WoodType)WoodType.create((String)("quark:" + name)));
        WoodSet set = new WoodSet(name, module, type);
        if (hasLog) {
            set.log = WoodSetHandler.log(name + "_log", module, color, barkColor);
            set.wood = new QuarkPillarBlock(name + "_wood", module, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)barkColor).m_60978_(2.0f).m_60918_(SoundType.f_56736_));
            set.strippedLog = WoodSetHandler.log("stripped_" + name + "_log", module, color, color);
            set.strippedWood = new QuarkPillarBlock("stripped_" + name + "_wood", module, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(2.0f).m_60918_(SoundType.f_56736_));
        }
        set.planks = new QuarkBlock(name + "_planks", module, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
        set.slab = VariantHandler.addSlab((IQuarkBlock)set.planks).getBlock();
        set.stairs = VariantHandler.addStairs((IQuarkBlock)set.planks).getBlock();
        set.fence = new QuarkFenceBlock(name + "_fence", module, CreativeModeTab.f_40750_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
        set.fenceGate = new QuarkFenceGateBlock(name + "_fence_gate", module, CreativeModeTab.f_40751_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
        set.door = new QuarkDoorBlock(name + "_door", module, CreativeModeTab.f_40751_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_());
        set.trapdoor = new QuarkTrapdoorBlock(name + "_trapdoor", module, CreativeModeTab.f_40751_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_((s, g, p, e) -> false));
        set.button = new QuarkWoodenButtonBlock(name + "_button", module, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_));
        set.pressurePlate = new QuarkPressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, name + "_pressure_plate", module, CreativeModeTab.f_40751_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_));
        set.sign = new QuarkStandingSignBlock(name + "_sign", module, type, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_));
        set.wallSign = new QuarkWallSignBlock(name + "_wall_sign", module, type, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_).lootFrom(() -> set.sign));
        set.bookshelf = new VariantBookshelfBlock(name, module, true).setCondition(() -> ModuleLoader.INSTANCE.isModuleEnabledOrOverlapping(VariantBookshelvesModule.class));
        set.ladder = new VariantLadderBlock(name, module, true).setCondition(() -> ModuleLoader.INSTANCE.isModuleEnabledOrOverlapping(VariantLaddersModule.class));
        set.post = new WoodPostBlock(module, set.fence, "", false).setCondition(() -> ModuleLoader.INSTANCE.isModuleEnabledOrOverlapping(WoodenPostsModule.class));
        set.strippedPost = new WoodPostBlock(module, set.fence, "stripped_", false).setCondition(() -> ModuleLoader.INSTANCE.isModuleEnabledOrOverlapping(WoodenPostsModule.class));
        set.verticalPlanks = VerticalPlanksModule.add(name, set.planks, module).setCondition(() -> ModuleLoader.INSTANCE.isModuleEnabledOrOverlapping(VerticalPlanksModule.class));
        if (hasLog) {
            set.hollowLog = new HollowLogBlock(set.log, module, flammable).setCondition(() -> ModuleLoader.INSTANCE.isModuleEnabledOrOverlapping(HollowLogsModule.class));
        }
        VariantChestsModule.addChest(name, module, () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50087_), true);
        set.signItem = new QuarkSignItem(module, set.sign, set.wallSign);
        if (hasBoat) {
            set.boatItem = new QuarkBoatItem(name, module, false);
            set.chestBoatItem = new QuarkBoatItem(name, module, true);
        }
        WoodSetHandler.makeSignWork(set.sign, set.wallSign);
        if (hasLog) {
            ToolInteractionHandler.registerInteraction(ToolActions.AXE_STRIP, set.log, set.strippedLog);
            ToolInteractionHandler.registerInteraction(ToolActions.AXE_STRIP, set.wood, set.strippedWood);
        }
        ToolInteractionHandler.registerInteraction(ToolActions.AXE_STRIP, set.post, set.strippedPost);
        VariantLaddersModule.variantLadders.add(set.ladder);
        if (hasBoat) {
            FuelHandler.addFuel(set.boatItem, 1200);
            FuelHandler.addFuel(set.chestBoatItem, 1200);
            WoodSetHandler.addQuarkBoatType(name, new QuarkBoatType(name, set.boatItem, set.chestBoatItem, set.planks));
        }
        woodSets.add(set);
        return set;
    }

    public static void makeSignWork(Block sign, Block wallSign) {
        HashSet<Block> validBlocks = new HashSet<Block>();
        validBlocks.add(sign);
        validBlocks.add(wallSign);
        validBlocks.addAll(BlockEntityType.f_58924_.f_58915_);
        BlockEntityType.f_58924_.f_58915_ = ImmutableSet.copyOf(validBlocks);
    }

    private static RotatedPillarBlock log(String name, QuarkModule module, MaterialColor topColor, MaterialColor sideColor) {
        return new QuarkPillarBlock(name, module, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, s -> s.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? topColor : sideColor).m_60978_(2.0f).m_60918_(SoundType.f_56736_));
    }

    public static void addQuarkBoatType(String name, QuarkBoatType type) {
        quarkBoatTypes.put(name, type);
    }

    public static QuarkBoatType getQuarkBoatType(String name) {
        return quarkBoatTypes.get(name);
    }

    public static Stream<String> boatTypes() {
        return quarkBoatTypes.keySet().stream();
    }

    public static class WoodSet {
        public final String name;
        public final WoodType type;
        public final QuarkModule module;
        public Block log;
        public Block wood;
        public Block planks;
        public Block strippedLog;
        public Block strippedWood;
        public Block slab;
        public Block stairs;
        public Block fence;
        public Block fenceGate;
        public Block door;
        public Block trapdoor;
        public Block button;
        public Block pressurePlate;
        public Block sign;
        public Block wallSign;
        public Block bookshelf;
        public Block ladder;
        public Block post;
        public Block strippedPost;
        public Block verticalPlanks;
        public Block hollowLog;
        public Item signItem;
        public Item boatItem;
        public Item chestBoatItem;

        public WoodSet(String name, QuarkModule module, WoodType type) {
            this.name = name;
            this.module = module;
            this.type = type;
        }
    }

    public record QuarkBoatType(String name, Item boat, Item chestBoat, Block planks) {
    }
}

